/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.expressions;

import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.internal.expressions.Expressions;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.w3c.dom.Element;

public class EqualsExpression
extends Expression {
    private static final int HASH_INITIAL = EqualsExpression.class.getName().hashCode();
    private Object fExpectedValue;

    public EqualsExpression(Object expectedValue) {
        Assert.isNotNull((Object)expectedValue);
        this.fExpectedValue = expectedValue;
    }

    public EqualsExpression(IConfigurationElement element) throws CoreException {
        String value = element.getAttribute("value");
        Expressions.checkAttribute("value", value);
        this.fExpectedValue = Expressions.convertArgument(value);
    }

    public EqualsExpression(Element element) throws CoreException {
        String value = element.getAttribute("value");
        Expressions.checkAttribute("value", value.length() > 0 ? value : null);
        this.fExpectedValue = Expressions.convertArgument(value);
    }

    @Override
    public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
        Object element = context.getDefaultVariable();
        return EvaluationResult.valueOf(element.equals(this.fExpectedValue));
    }

    @Override
    public void collectExpressionInfo(ExpressionInfo info) {
        info.markDefaultVariableAccessed();
    }

    public boolean equals(Object object) {
        if (!(object instanceof EqualsExpression)) {
            return false;
        }
        EqualsExpression that = (EqualsExpression)object;
        return this.fExpectedValue.equals(that.fExpectedValue);
    }

    @Override
    protected int computeHashCode() {
        return HASH_INITIAL * 89 + this.fExpectedValue.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
        builder.append(" [expected=");
        builder.append(this.fExpectedValue);
        builder.append("]");
        return builder.toString();
    }
}

