/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.fileupload.internal;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.eclipse.rap.fileupload.FileUploadHandler;
import org.eclipse.rap.fileupload.FileUploadReceiver;
import org.eclipse.rap.fileupload.UploadSizeLimitExceededException;
import org.eclipse.rap.fileupload.UploadTimeLimitExceededException;
import org.eclipse.rap.fileupload.internal.FileDetailsImpl;
import org.eclipse.rap.fileupload.internal.FileUploadTracker;

final class FileUploadProcessor {
    private final FileUploadHandler handler;
    private final FileUploadTracker tracker;
    private String fileName;
    private long deadline;

    FileUploadProcessor(FileUploadHandler handler) {
        this.handler = handler;
        this.tracker = new FileUploadTracker(handler);
        this.deadline = -1L;
    }

    void handleFileUpload(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.handler.getUploadTimeLimit() > 0L) {
            this.deadline = System.currentTimeMillis() + this.handler.getUploadTimeLimit();
        }
        try {
            ServletFileUpload upload = this.createUpload();
            FileItemIterator iter = upload.getItemIterator(request);
            while (iter.hasNext()) {
                FileItemStream item = iter.next();
                if (item.isFormField()) continue;
                this.receive(item);
            }
            if (this.tracker.isEmpty()) {
                String errorMessage = "No file upload data found in request";
                this.tracker.setException(new Exception(errorMessage));
                this.tracker.handleFailed();
                response.sendError(400, errorMessage);
            } else {
                this.tracker.handleFinished();
            }
        }
        catch (Exception exception) {
            Throwable cause = exception.getCause();
            if (cause instanceof FileUploadBase.FileSizeLimitExceededException) {
                long sizeLimit = this.handler.getMaxFileSize();
                exception = new UploadSizeLimitExceededException(sizeLimit, this.fileName);
            } else if (cause instanceof UploadTimeLimitExceededException) {
                exception = (UploadTimeLimitExceededException)cause;
            }
            this.tracker.setException(exception);
            this.tracker.handleFailed();
            int errorCode = 500;
            if (exception instanceof UploadSizeLimitExceededException) {
                errorCode = 413;
            } else if (exception instanceof UploadTimeLimitExceededException) {
                errorCode = 408;
            }
            response.sendError(errorCode, exception.getMessage());
        }
    }

    private ServletFileUpload createUpload() {
        ServletFileUpload upload = new ServletFileUpload();
        upload.setFileSizeMax(this.handler.getMaxFileSize());
        upload.setProgressListener(this.createProgressListener());
        return upload;
    }

    private ProgressListener createProgressListener() {
        ProgressListener result = new ProgressListener(){
            long prevTotalBytesRead = -1L;

            public void update(long totalBytesRead, long contentLength, int item) {
                if (totalBytesRead > this.prevTotalBytesRead) {
                    if (FileUploadProcessor.this.deadline > 0L && System.currentTimeMillis() > FileUploadProcessor.this.deadline) {
                        long timeLimit = FileUploadProcessor.this.handler.getUploadTimeLimit();
                        UploadTimeLimitExceededException exception = new UploadTimeLimitExceededException(timeLimit, FileUploadProcessor.this.fileName);
                        throw new RuntimeException(exception);
                    }
                    this.prevTotalBytesRead = totalBytesRead;
                    FileUploadProcessor.this.tracker.setContentLength(contentLength);
                    FileUploadProcessor.this.tracker.setBytesRead(totalBytesRead);
                    FileUploadProcessor.this.tracker.handleProgress();
                }
            }
        };
        return result;
    }

    private void receive(FileItemStream item) throws IOException {
        try (InputStream stream = item.openStream();){
            this.fileName = FileUploadProcessor.stripFileName(item.getName());
            String contentType = item.getContentType();
            FileDetailsImpl details = new FileDetailsImpl(this.fileName, contentType);
            FileUploadReceiver receiver = this.handler.getReceiver();
            receiver.receive(stream, details);
            this.tracker.addFile(details);
        }
    }

    private static String stripFileName(String name) {
        String result = name;
        int lastSlash = result.lastIndexOf(47);
        if (lastSlash != -1) {
            result = result.substring(lastSlash + 1);
        } else {
            int lastBackslash = result.lastIndexOf(92);
            if (lastBackslash != -1) {
                result = result.substring(lastBackslash + 1);
            }
        }
        return result;
    }
}

