/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.custom.scrolledcompositekit;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCA;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.custom.scrolledcompositekit.ScrolledCompositeOperationHandler;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Widget;

public final class ScrolledCompositeLCA
extends WidgetLCA<ScrolledComposite> {
    public static final ScrolledCompositeLCA INSTANCE = new ScrolledCompositeLCA();
    private static final String TYPE = "rwt.widgets.ScrolledComposite";
    private static final String[] ALLOWED_STYLES = new String[]{"H_SCROLL", "V_SCROLL", "BORDER"};
    private static final String PROP_ORIGIN = "origin";
    private static final String PROP_CONTENT = "content";
    private static final String PROP_SHOW_FOCUSED_CONTROL = "showFocusedControl";
    private static final Point DEFAULT_ORIGIN = new Point(0, 0);

    @Override
    public void preserveValues(ScrolledComposite composite) {
        WidgetLCAUtil.preserveProperty((Widget)composite, PROP_ORIGIN, ScrolledCompositeLCA.getOrigin(composite));
        WidgetLCAUtil.preserveProperty((Widget)composite, PROP_CONTENT, composite.getContent());
        WidgetLCAUtil.preserveProperty((Widget)composite, PROP_SHOW_FOCUSED_CONTROL, composite.getShowFocusedControl());
    }

    @Override
    public void renderInitialization(ScrolledComposite composite) throws IOException {
        RemoteObject remoteObject = RemoteObjectFactory.createRemoteObject(composite, TYPE);
        remoteObject.setHandler(new ScrolledCompositeOperationHandler(composite));
        remoteObject.set("parent", WidgetUtil.getId(composite.getParent()));
        remoteObject.set("style", JsonUtil.createJsonArray(WidgetLCAUtil.getStyles(composite, ALLOWED_STYLES)));
    }

    @Override
    public void renderChanges(ScrolledComposite composite) throws IOException {
        ControlLCAUtil.renderChanges(composite);
        WidgetLCAUtil.renderCustomVariant(composite);
        WidgetLCAUtil.renderProperty((Widget)composite, PROP_CONTENT, composite.getContent(), null);
        WidgetLCAUtil.renderProperty((Widget)composite, PROP_ORIGIN, ScrolledCompositeLCA.getOrigin(composite), DEFAULT_ORIGIN);
        WidgetLCAUtil.renderProperty((Widget)composite, PROP_SHOW_FOCUSED_CONTROL, composite.getShowFocusedControl(), false);
    }

    private static Point getOrigin(ScrolledComposite composite) {
        ScrollBar verticalBar;
        Point result = new Point(0, 0);
        ScrollBar horizontalBar = composite.getHorizontalBar();
        if (horizontalBar != null) {
            result.x = horizontalBar.getSelection();
        }
        if ((verticalBar = composite.getVerticalBar()) != null) {
            result.y = verticalBar.getSelection();
        }
        return result;
    }

    private ScrolledCompositeLCA() {
    }
}

