/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.swt;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.jface.databinding.swt.WidgetValueProperty;
import org.eclipse.swt.widgets.DateTime;

public class DateTimeSelectionProperty
extends WidgetValueProperty<DateTime, Date> {
    private static final ThreadLocal<Calendar> calendar = ThreadLocal.withInitial(Calendar::getInstance);

    public DateTimeSelectionProperty() {
        super(13);
    }

    public Object getValueType() {
        return Date.class;
    }

    protected Date doGetValue(DateTime source) {
        Calendar cal = calendar.get();
        cal.clear();
        if ((source.getStyle() & 0x80) != 0) {
            cal.set(11, source.getHours());
            cal.set(12, source.getMinutes());
            cal.set(13, source.getSeconds());
        } else {
            cal.set(1, source.getYear());
            cal.set(2, source.getMonth());
            cal.set(5, source.getDay());
        }
        return cal.getTime();
    }

    protected void doSetValue(DateTime source, Date value) {
        if (value == null) {
            throw new IllegalArgumentException("Cannot set null selection on DateTime");
        }
        Calendar cal = calendar.get();
        cal.setTime(value);
        if ((source.getStyle() & 0x80) != 0) {
            source.setTime(cal.get(11), cal.get(12), cal.get(13));
        } else {
            source.setDate(cal.get(1), cal.get(2), cal.get(5));
        }
    }
}

