/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.jmx;

import java.util.List;
import org.eclipse.jetty.jmx.ObjectMBean;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;

public class AbstractHandlerMBean
extends ObjectMBean {
    public AbstractHandlerMBean(Object managedObject) {
        super(managedObject);
    }

    public String getObjectContextBasis() {
        if (this._managed != null) {
            String basis = null;
            Object object = this._managed;
            if (object instanceof ContextHandler) {
                ContextHandler contextHandler = (ContextHandler)object;
                contextName = this.getContextName(contextHandler);
                if (contextName == null) {
                    contextName = contextHandler.getDisplayName();
                }
                if (contextName != null) {
                    return contextName;
                }
            } else {
                ContextHandler context;
                Handler.Abstract handler;
                Server server;
                contextName = this._managed;
                if (contextName instanceof Handler.Abstract && (server = (handler = (Handler.Abstract)contextName).getServer()) != null && (context = (ContextHandler)server.getContainer(handler, ContextHandler.class)) != null) {
                    basis = this.getContextName(context);
                }
            }
            if (basis != null) {
                return basis;
            }
        }
        return super.getObjectContextBasis();
    }

    protected String getContextName(ContextHandler context) {
        List<String> vhosts;
        Object name = null;
        if (context.getContextPath() != null && context.getContextPath().length() > 0) {
            int idx = context.getContextPath().lastIndexOf(47);
            Object object = name = idx < 0 ? context.getContextPath() : context.getContextPath().substring(++idx);
            if (name == null || ((String)name).length() == 0) {
                name = "ROOT";
            }
        }
        if (name == null && context.getBaseResource() != null) {
            name = context.getBaseResource().getPath().getFileName().toString();
        }
        if ((vhosts = context.getVirtualHosts()).size() > 0) {
            name = "\"" + (String)name + "@" + vhosts.get(0) + "\"";
        }
        return name;
    }
}

