/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.service;

import org.eclipse.rap.rwt.internal.lifecycle.CurrentPhase;
import org.eclipse.rap.rwt.internal.serverpush.ServerPushManager;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.service.UISession;
import org.eclipse.swt.internal.SerializableCompatibility;

public class ServerPushSession
implements SerializableCompatibility {
    private final UISession uiSession;

    public ServerPushSession() {
        this.checkThread();
        this.uiSession = ContextProvider.getUISession();
    }

    public void start() {
        this.checkThread();
        ServerPushManager.getInstance().activateServerPushFor(this);
    }

    public void stop() {
        this.uiSession.exec(new Runnable(){

            @Override
            public void run() {
                ServerPushManager.getInstance().deactivateServerPushFor(ServerPushSession.this);
            }
        });
    }

    private void checkThread() {
        if (!ContextProvider.hasContext() || this.uiSession != null && ContextProvider.getUISession() != this.uiSession || CurrentPhase.get() == null) {
            throw new IllegalStateException("Invalid thread access");
        }
    }
}

