/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.client;

import org.eclipse.rap.rwt.SingletonUtil;
import org.eclipse.rap.rwt.client.Client;
import org.eclipse.rap.rwt.client.service.BrowserNavigation;
import org.eclipse.rap.rwt.client.service.ClientFileLoader;
import org.eclipse.rap.rwt.client.service.ClientFileUploader;
import org.eclipse.rap.rwt.client.service.ClientInfo;
import org.eclipse.rap.rwt.client.service.ClientService;
import org.eclipse.rap.rwt.client.service.ExitConfirmation;
import org.eclipse.rap.rwt.client.service.JavaScriptExecutor;
import org.eclipse.rap.rwt.client.service.JavaScriptLoader;
import org.eclipse.rap.rwt.client.service.StartupParameters;
import org.eclipse.rap.rwt.client.service.UrlLauncher;
import org.eclipse.rap.rwt.internal.client.BrowserNavigationImpl;
import org.eclipse.rap.rwt.internal.client.ClientFileLoaderImpl;
import org.eclipse.rap.rwt.internal.client.ClientFileUploaderImpl;
import org.eclipse.rap.rwt.internal.client.ClientInfoImpl;
import org.eclipse.rap.rwt.internal.client.ClientMessages;
import org.eclipse.rap.rwt.internal.client.ConnectionMessages;
import org.eclipse.rap.rwt.internal.client.ConnectionMessagesImpl;
import org.eclipse.rap.rwt.internal.client.ExitConfirmationImpl;
import org.eclipse.rap.rwt.internal.client.JavaScriptExecutorImpl;
import org.eclipse.rap.rwt.internal.client.JavaScriptLoaderImpl;
import org.eclipse.rap.rwt.internal.client.StartupParametersImpl;
import org.eclipse.rap.rwt.internal.client.UrlLauncherImpl;
import org.eclipse.rap.rwt.internal.client.WebClientMessages;
import org.eclipse.rap.rwt.internal.resources.JavaScriptModuleLoader;
import org.eclipse.rap.rwt.internal.resources.JavaScriptModuleLoaderImpl;

public class WebClient
implements Client {
    private static final String PREFIX = "org.eclipse.rap.rwt.webclient";
    public static final String THEME_ID = "org.eclipse.rap.rwt.webclient.themeId";
    public static final String HEAD_HTML = "org.eclipse.rap.rwt.webclient.additionalHeaders";
    public static final String BODY_HTML = "org.eclipse.rap.rwt.webclient.bodyHtml";
    public static final String PAGE_TITLE = "org.eclipse.rap.rwt.webclient.pageTitle";
    public static final String PAGE_OVERFLOW = "org.eclipse.rap.rwt.webclient.pageOverflow";
    public static final String FAVICON = "org.eclipse.rap.rwt.webclient.favicon";
    public static final String CSP = "org.eclipse.rap.rwt.webclient.contentSecurityPolicy";
    public static final String DISABLE_SHUTDOWN_REQUEST = "org.eclipse.rap.rwt.webclient.disableShutdownRequest";

    public WebClient() {
        WebClient.initializeServices();
    }

    @Override
    public <T extends ClientService> T getService(Class<T> type) {
        ClientService result = null;
        if (type == JavaScriptExecutor.class) {
            result = WebClient.getServiceImpl(JavaScriptExecutorImpl.class);
        } else if (type == JavaScriptLoader.class) {
            result = WebClient.getServiceImpl(JavaScriptLoaderImpl.class);
        } else if (type == UrlLauncher.class) {
            result = WebClient.getServiceImpl(UrlLauncherImpl.class);
        } else if (type == JavaScriptModuleLoader.class) {
            result = WebClient.getServiceImpl(JavaScriptModuleLoaderImpl.class);
        } else if (type == BrowserNavigation.class) {
            result = WebClient.getServiceImpl(BrowserNavigationImpl.class);
        } else if (type == ExitConfirmation.class) {
            result = WebClient.getServiceImpl(ExitConfirmationImpl.class);
        } else if (type == ConnectionMessages.class) {
            result = WebClient.getServiceImpl(ConnectionMessagesImpl.class);
        } else if (type == ClientInfo.class) {
            result = WebClient.getServiceImpl(ClientInfoImpl.class);
        } else if (type == ClientMessages.class) {
            result = WebClient.getServiceImpl(WebClientMessages.class);
        } else if (type == ClientFileLoader.class) {
            result = WebClient.getServiceImpl(ClientFileLoaderImpl.class);
        } else if (type == ClientFileUploader.class) {
            result = WebClient.getServiceImpl(ClientFileUploaderImpl.class);
        } else if (type == StartupParameters.class) {
            result = WebClient.getServiceImpl(StartupParametersImpl.class);
        }
        return (T)result;
    }

    private static <T> T getServiceImpl(Class<T> impl) {
        return SingletonUtil.getSessionInstance(impl);
    }

    private static void initializeServices() {
        WebClient.getServiceImpl(ClientInfoImpl.class);
        WebClient.getServiceImpl(BrowserNavigationImpl.class);
        WebClient.getServiceImpl(StartupParametersImpl.class);
    }
}

