/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.scrollbarkit;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCA;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.internal.remote.RemoteObjectImpl;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.swt.internal.widgets.scrollbarkit.ScrollBarOperationHandler;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Widget;

public final class ScrollBarLCA
extends WidgetLCA<ScrollBar> {
    public static final ScrollBarLCA INSTANCE = new ScrollBarLCA();
    private static final String TYPE = "rwt.widgets.ScrollBar";
    private static final String[] ALLOWED_STYLES = new String[]{"HORIZONTAL", "VERTICAL"};
    private static final String PROP_VISIBILITY = "visibility";

    @Override
    public void preserveValues(ScrollBar scrollBar) {
        WidgetLCAUtil.preserveProperty((Widget)scrollBar, PROP_VISIBILITY, scrollBar.getVisible());
    }

    @Override
    public void renderInitialization(ScrollBar scrollBar) throws IOException {
        RemoteObject remoteObject = RemoteObjectFactory.createRemoteObject(scrollBar, TYPE);
        remoteObject.setHandler(new ScrollBarOperationHandler(scrollBar));
        remoteObject.set("parent", WidgetUtil.getId(scrollBar.getParent()));
        remoteObject.set("style", JsonUtil.createJsonArray(WidgetLCAUtil.getStyles(scrollBar, ALLOWED_STYLES)));
    }

    @Override
    public void renderChanges(ScrollBar scrollBar) throws IOException {
        WidgetLCAUtil.renderProperty((Widget)scrollBar, PROP_VISIBILITY, scrollBar.getVisible(), false);
        WidgetLCAUtil.renderListenSelection(scrollBar);
    }

    @Override
    public void renderDispose(ScrollBar widget) throws IOException {
        RemoteObjectImpl remoteObject = (RemoteObjectImpl)RemoteObjectFactory.getRemoteObject(widget);
        remoteObject.markDestroyed();
    }

    private ScrollBarLCA() {
    }
}

