/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.branding;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.ui.internal.branding.AbstractBranding;
import org.eclipse.rap.ui.internal.branding.Header;
import org.osgi.framework.Bundle;

public final class Branding
extends AbstractBranding {
    private static final Header[] EMPTY_HEADERS = new Header[0];
    private final String contributor;
    private String title;
    private String favIcon;
    private List<Header> headers;
    private String body;
    private String themeId;
    private String brandingId;

    public Branding(String contributor) {
        this.contributor = contributor;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setFavIcon(String favIcon) {
        this.favIcon = favIcon;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void addHeader(String tagName, Map<String, String> attributes) {
        if (this.headers == null) {
            this.headers = new ArrayList<Header>();
        }
        Header header = new Header(tagName, attributes);
        this.headers.add(header);
    }

    public void setThemeId(String themeId) {
        this.themeId = themeId;
    }

    void setId(String brandingId) {
        this.brandingId = brandingId;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getFavIcon() {
        return this.favIcon;
    }

    @Override
    public Header[] getHeaders() {
        Header[] result;
        if (this.headers == null) {
            result = EMPTY_HEADERS;
        } else {
            result = new Header[this.headers.size()];
            this.headers.toArray(result);
        }
        return result;
    }

    @Override
    public String getBody() {
        return this.body;
    }

    @Override
    public String getThemeId() {
        return this.themeId;
    }

    @Override
    public String getId() {
        return this.brandingId;
    }

    @Override
    public void registerResources() throws IOException {
        Path file;
        Bundle bundle;
        InputStream stream;
        if (this.favIcon != null && !"".equals(this.favIcon) && (stream = FileLocator.openStream((Bundle)(bundle = Platform.getBundle((String)this.contributor)), (IPath)(file = new Path(this.favIcon)), (boolean)false)) != null) {
            try {
                RWT.getResourceManager().register(this.favIcon, stream);
            }
            finally {
                stream.close();
            }
        }
    }
}

