/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.theme;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class AppearancesUtil {
    private static final Pattern END_TEMPLATE_PATTERN = Pattern.compile("(\\r|\\n).*?END TEMPLATE");
    private static final Pattern BEGIN_TEMPLATE_PATTERN = Pattern.compile("BEGIN TEMPLATE.*(\\r|\\n)");

    private AppearancesUtil() {
    }

    public static String readAppearanceFile(InputStream inStream) throws IOException {
        StringBuilder sb = new StringBuilder();
        InputStreamReader reader = new InputStreamReader(inStream, "UTF-8");
        BufferedReader br = new BufferedReader(reader);
        int i = 0;
        while (i < 100) {
            int character = br.read();
            while (character != -1) {
                sb.append((char)character);
                character = br.read();
            }
            ++i;
        }
        return AppearancesUtil.stripTemplate(sb.toString());
    }

    private static String stripTemplate(String input) {
        int beginIndex = 0;
        int endIndex = input.length();
        Matcher matcher = BEGIN_TEMPLATE_PATTERN.matcher(input);
        if (matcher.find()) {
            beginIndex = matcher.end();
        }
        if ((matcher = END_TEMPLATE_PATTERN.matcher(input)).find()) {
            endIndex = matcher.start();
        }
        return input.substring(beginIndex, endIndex);
    }
}

