/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.osgi.internal;

import java.util.Collection;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import org.eclipse.rap.rwt.application.ApplicationConfiguration;
import org.eclipse.rap.rwt.application.ApplicationRunner;
import org.eclipse.rap.rwt.engine.RWTServlet;
import org.eclipse.rap.rwt.internal.application.ApplicationContextImpl;
import org.eclipse.rap.rwt.osgi.ApplicationReference;
import org.eclipse.rap.rwt.osgi.internal.ApplicationLauncherImpl;
import org.eclipse.rap.rwt.osgi.internal.CutOffContextPathWrapper;
import org.eclipse.rap.rwt.osgi.internal.HttpContextWrapper;
import org.eclipse.rap.rwt.osgi.internal.ServletContextWrapper;
import org.eclipse.rap.rwt.service.ApplicationContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;

class ApplicationReferenceImpl
implements ApplicationReference {
    static final String SERVLET_CONTEXT_FINDER_ALIAS = "/servlet_context_finder";
    static final String DEFAULT_ALIAS = "/rap";
    private ApplicationConfiguration configuration;
    private HttpService httpService;
    private HttpContext httpContext;
    private String contextLocation;
    private String contextName;
    private ServletContext servletContextWrapper;
    private ApplicationRunner applicationRunner;
    private ApplicationLauncherImpl applicationLauncher;
    private ServiceRegistration<?> serviceRegistration;
    private volatile boolean alive;

    ApplicationReferenceImpl(ApplicationConfiguration configuration, HttpService httpService, HttpContext httpContext, String contextName, String contextLocation, ApplicationLauncherImpl applicationLauncher) {
        this.configuration = configuration;
        this.httpService = httpService;
        this.httpContext = this.createWrappedHttpContext(httpContext);
        this.contextLocation = contextLocation;
        this.contextName = contextName;
        this.applicationLauncher = applicationLauncher;
    }

    void start() {
        this.createApplication(this.registerServletContextProviderServlet());
        try {
            this.startRWTApplication();
        }
        finally {
            this.unregisterServletContextProviderServlet();
        }
        this.markAlive();
    }

    private void createApplication(HttpServlet contextProviderServlet) {
        ServletContext servletContext = contextProviderServlet.getServletContext();
        this.servletContextWrapper = new ServletContextWrapper(servletContext, this.contextLocation);
        this.applicationRunner = new ApplicationRunner(this.configuration, this.servletContextWrapper);
    }

    private void startRWTApplication() {
        this.applicationRunner.start();
        this.registerServlets();
        this.registerResourceDirectory();
        this.registerAsService();
    }

    private void registerServlets() {
        Collection<String> aliases = this.getServletPaths();
        if (aliases.isEmpty()) {
            this.registerServlet(DEFAULT_ALIAS, (HttpServlet)new RWTServlet());
        }
        for (String alias : aliases) {
            this.registerServlet(alias, (HttpServlet)new RWTServlet());
        }
    }

    @Override
    public void stopApplication() {
        if (!this.hasBeenStopped()) {
            this.doStopApplication();
        }
    }

    private synchronized boolean hasBeenStopped() {
        boolean result;
        boolean bl = result = !this.alive;
        if (this.alive) {
            this.markNotAlive();
        }
        return result;
    }

    private void doStopApplication() {
        this.registerServletContextProviderServlet();
        this.notifyAboutToStop();
        try {
            this.stopRWTApplication();
        }
        finally {
            this.unregisterServletContextProviderServlet();
        }
        this.clearFields();
    }

    private void stopRWTApplication() {
        Collection<String> aliases = this.getServletPaths();
        this.serviceRegistration.unregister();
        this.applicationRunner.stop();
        this.unregisterServlets(aliases);
        this.unregisterResourcesDirectory();
    }

    private void unregisterServlets(Collection<String> aliases) {
        if (aliases.isEmpty()) {
            this.unregisterServlet(DEFAULT_ALIAS);
        }
        for (String alias : aliases) {
            this.unregisterServlet(alias);
        }
    }

    private Collection<String> getServletPaths() {
        ApplicationContext applicationContext = this.applicationRunner.getApplicationContext();
        ApplicationContextImpl applicationContextImpl = (ApplicationContextImpl)applicationContext;
        return applicationContextImpl.getEntryPointManager().getServletPaths();
    }

    boolean belongsTo(Object service) {
        return this.configuration == service || this.httpService == service;
    }

    private void unregisterServletContextProviderServlet() {
        this.unregisterServlet(SERVLET_CONTEXT_FINDER_ALIAS);
    }

    private HttpContext createWrappedHttpContext(HttpContext httpContext) {
        HttpContextWrapper result = httpContext == null ? this.wrapHttpContext(this.httpService.createDefaultHttpContext()) : this.wrapHttpContext(httpContext);
        return result;
    }

    private HttpContextWrapper wrapHttpContext(HttpContext createDefaultHttpContext) {
        return new HttpContextWrapper(createDefaultHttpContext);
    }

    private HttpServlet registerServletContextProviderServlet() {
        HttpServlet result = new HttpServlet(){
            private static final long serialVersionUID = 1L;
        };
        this.registerServlet(SERVLET_CONTEXT_FINDER_ALIAS, result);
        return result;
    }

    private void registerAsService() {
        String clazz = ApplicationReference.class.getName();
        this.serviceRegistration = this.getBundleContext().registerService(clazz, (Object)this, null);
    }

    private BundleContext getBundleContext() {
        return this.applicationLauncher.getBundleContext();
    }

    private void registerServlet(String alias, HttpServlet servlet) {
        try {
            CutOffContextPathWrapper wrapper = new CutOffContextPathWrapper(servlet, this.servletContextWrapper, alias);
            this.httpService.registerServlet(String.valueOf(this.getContextSegment()) + alias, (Servlet)wrapper, null, this.httpContext);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception shouldNotHappen) {
            throw new RuntimeException(shouldNotHappen);
        }
    }

    private void registerResourceDirectory() {
        String alias = "rwt-resources";
        String location = String.valueOf(this.contextLocation) + "/" + alias;
        try {
            this.httpService.registerResources(String.valueOf(this.getContextSegment()) + "/" + alias, location, this.httpContext);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception shouldNotHappen) {
            throw new RuntimeException(shouldNotHappen);
        }
    }

    private void clearFields() {
        this.applicationRunner = null;
        this.httpService = null;
        this.httpContext = null;
        this.configuration = null;
        this.contextName = null;
        this.contextLocation = null;
        this.applicationLauncher = null;
        this.servletContextWrapper = null;
    }

    private void unregisterServlet(String alias) {
        this.httpService.unregister(String.valueOf(this.getContextSegment()) + alias);
    }

    private void unregisterResourcesDirectory() {
        this.httpService.unregister(String.valueOf(this.getContextSegment()) + "/" + "rwt-resources");
    }

    private void notifyAboutToStop() {
        this.applicationLauncher.notifyContextAboutToStop(this);
    }

    private String getContextSegment() {
        String result = "";
        if (this.contextName != null) {
            result = "/" + this.contextName;
        }
        return result;
    }

    boolean isAlive() {
        return this.alive;
    }

    private void markAlive() {
        this.alive = true;
    }

    private void markNotAlive() {
        this.alive = false;
    }
}

