/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper.type;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.persistence.internal.helper.ConcurrencyManager;

public class CacheKeyToThreadRelationships {
    private final ConcurrencyManager cacheKeyBeingDescribed;
    private final List<Thread> threadsThatAcquiredReadLock = new ArrayList<Thread>();
    private final List<Thread> threadsThatAcquiredDeferredLock = new ArrayList<Thread>();
    private final List<Thread> threadsThatAcquiredActiveLock = new ArrayList<Thread>();
    private final List<Thread> threadsKnownToBeStuckTryingToAcquireLock = new ArrayList<Thread>();
    private final List<Thread> threadsKnownToBeStuckTryingToAcquireLockForReading = new ArrayList<Thread>();

    public CacheKeyToThreadRelationships(ConcurrencyManager cacheKeyBeingDescribed) {
        this.cacheKeyBeingDescribed = cacheKeyBeingDescribed;
    }

    public ConcurrencyManager getCacheKeyBeingDescribed() {
        return this.cacheKeyBeingDescribed;
    }

    public List<Thread> getThreadsThatAcquiredReadLock() {
        return Collections.unmodifiableList(this.threadsThatAcquiredReadLock);
    }

    public List<Thread> getThreadsThatAcquiredDeferredLock() {
        return Collections.unmodifiableList(this.threadsThatAcquiredDeferredLock);
    }

    public List<Thread> getThreadsThatAcquiredActiveLock() {
        return Collections.unmodifiableList(this.threadsThatAcquiredActiveLock);
    }

    public List<Thread> getThreadsKnownToBeStuckTryingToAcquireLock() {
        return Collections.unmodifiableList(this.threadsKnownToBeStuckTryingToAcquireLock);
    }

    public List<String> getThreadNamesThatAcquiredReadLock() {
        return this.mapThreadToThreadName(this.threadsThatAcquiredReadLock);
    }

    public List<String> getThreadNamesThatAcquiredDeferredLock() {
        return this.mapThreadToThreadName(this.threadsThatAcquiredDeferredLock);
    }

    public List<String> getThreadNamesThatAcquiredActiveLock() {
        return this.mapThreadToThreadName(this.threadsThatAcquiredActiveLock);
    }

    public List<String> getThreadNamesKnownToBeStuckTryingToAcquireLock() {
        return this.mapThreadToThreadName(this.threadsKnownToBeStuckTryingToAcquireLock);
    }

    protected List<String> mapThreadToThreadName(List<Thread> threads) {
        ArrayList<String> result = new ArrayList<String>();
        for (Thread currentThread : threads) {
            result.add(currentThread.getName());
        }
        return result;
    }

    public void addThreadsThatAcquiredReadLock(Thread thread) {
        this.threadsThatAcquiredReadLock.add(thread);
    }

    public void addThreadsThatAcquiredDeferredLock(Thread thread) {
        this.threadsThatAcquiredDeferredLock.add(thread);
    }

    public void addThreadsThatAcquiredActiveLock(Thread thread) {
        this.threadsThatAcquiredActiveLock.add(thread);
    }

    public void addThreadsKnownToBeStuckTryingToAcquireLock(Thread thread) {
        this.threadsKnownToBeStuckTryingToAcquireLock.add(thread);
    }

    public void addThreadsKnownToBeStuckTryingToAcquireLockForReading(Thread thread) {
        this.threadsKnownToBeStuckTryingToAcquireLockForReading.add(thread);
    }

    public List<String> getThreadNamesKnownToBeStuckTryingToAcquireLockForReading() {
        return this.mapThreadToThreadName(this.threadsKnownToBeStuckTryingToAcquireLockForReading);
    }

    public List<Thread> getThreadsKnownToBeStuckTryingToAcquireLockForReading() {
        return Collections.unmodifiableList(this.threadsKnownToBeStuckTryingToAcquireLockForReading);
    }
}

