/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo;

import commonj.sdo.ChangeSummary;
import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Sequence;
import commonj.sdo.helper.HelperContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.sdo.SDODataGraph;
import org.eclipse.persistence.sdo.SDODataObject;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.SDOSequence;
import org.eclipse.persistence.sdo.SDOSetting;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.ValueStore;
import org.eclipse.persistence.sdo.helper.ListWrapper;
import org.eclipse.persistence.sdo.helper.SDOCopyHelper;

public class SDOChangeSummary
implements ChangeSummary {
    private SDODataObject rootDataObject;
    private boolean logging;
    private boolean loggingMapping;
    private DataGraph dataGraph;
    private List createdList = new ArrayList();
    private List deletedList;
    private Map deepCopies = new HashMap();
    private List createdXPaths;
    private List deletedXPaths;
    private List modifiedDoms;
    private Map unsetPropsMap;
    private Map originalValueStores;
    private Map originalElements;
    private Map oldContainer;
    private Map oldContainmentProperty;
    private Map oldSequences;
    private Map originalSequences;
    private Map unsetOCPropsMap;
    private Map oldSettings;
    private Map reverseDeletedMap;
    private HelperContext aHelperContext;

    public SDOChangeSummary() {
        this.deletedList = new ArrayList();
        this.oldSettings = new HashMap();
        this.oldContainer = new HashMap();
        this.oldContainmentProperty = new HashMap();
        this.unsetPropsMap = new HashMap();
        this.unsetOCPropsMap = new HashMap();
        this.originalValueStores = new HashMap();
        this.originalElements = new HashMap();
        this.reverseDeletedMap = new HashMap();
    }

    public SDOChangeSummary(SDODataObject dataObject, HelperContext aContext) {
        this();
        this.aHelperContext = aContext;
        this.rootDataObject = dataObject;
    }

    public SDOChangeSummary(SDODataGraph dataGraph, HelperContext aContext) {
        this();
        this.aHelperContext = aContext;
        this.dataGraph = dataGraph;
    }

    public boolean isLogging() {
        return this.logging;
    }

    public void setCreated(DataObject anObject, boolean created) {
        if (this.getRootObject() == anObject) {
            return;
        }
        if (this.isLogging() && !created) {
            this.createdList.remove(anObject);
        }
        if (this.isLogging() && !this.isCreated(anObject) && created) {
            this.deletedList.remove(anObject);
            this.createdList.add(anObject);
        }
    }

    public boolean setDeleted(DataObject anObject, boolean deleted) {
        if (this.getRootObject() == anObject) {
            return false;
        }
        if (this.isLogging() && !deleted) {
            this.deletedList.remove(anObject);
        }
        if (this.isLogging() && !this.isDeleted(anObject) && deleted) {
            if (this.isCreated(anObject)) {
                this.createdList.remove(anObject);
                this.oldSettings.remove(anObject);
                this.originalValueStores.remove(anObject);
                this.originalElements.remove(anObject);
                return false;
            }
            this.pauseLogging();
            this.deletedList.add(anObject);
            this.resumeLogging();
        }
        return true;
    }

    public void setOldContainer(SDODataObject aKey, DataObject aValue) {
        this.oldContainer.put(aKey, aValue);
    }

    public Map getOldContainers() {
        return this.oldContainer;
    }

    public void setOldContainmentProperty(SDODataObject aKey, Property aValue) {
        this.oldContainmentProperty.put(aKey, aValue);
    }

    public void setOldSequence(SDODataObject aKey, Sequence aValue) {
        this.getOldSequences().put(aKey, aValue);
    }

    public DataGraph getDataGraph() {
        return this.dataGraph;
    }

    public List getChangedDataObjects() {
        ArrayList aList = new ArrayList();
        aList.addAll(this.getModified());
        if (this.deletedList != null) {
            aList.addAll(this.deletedList);
        }
        if (this.createdList != null) {
            aList.addAll(this.createdList);
        }
        return aList;
    }

    public List getModified() {
        ArrayList modifiedList = new ArrayList();
        this.getModified(this.rootDataObject, modifiedList);
        return modifiedList;
    }

    private void getModified(SDODataObject sdoDataObject, List modifiedList) {
        if (null == sdoDataObject) {
            return;
        }
        if (this.isModified(sdoDataObject)) {
            modifiedList.add(sdoDataObject);
        }
        List properties = sdoDataObject.getInstanceProperties();
        for (int x = 0; x < properties.size(); ++x) {
            Property property = (Property)properties.get(x);
            if (!property.isContainment()) continue;
            if (property.isMany()) {
                List dataObjects = sdoDataObject.getList(property);
                for (int y = 0; y < dataObjects.size(); ++y) {
                    this.getModified((SDODataObject)dataObjects.get(y), modifiedList);
                }
                continue;
            }
            if (property.getType() == null || ((SDOType)property.getType()).isChangeSummaryType()) continue;
            this.getModified(sdoDataObject.getDataObject(property), modifiedList);
        }
    }

    public List getDeleted() {
        return this.deletedList;
    }

    public List getCreated() {
        return this.createdList;
    }

    public boolean isCreated(DataObject dataObject) {
        return this.createdList != null && this.createdList.contains(dataObject);
    }

    public boolean isDeleted(DataObject dataObject) {
        return this.deletedList != null && this.deletedList.contains(dataObject);
    }

    public boolean isModified(DataObject dataObject) {
        return this.originalValueStores.get(dataObject) != null && !this.isDeleted(dataObject);
    }

    public List getOldValues(DataObject dataObject) {
        if (dataObject == null || !this.isDeleted(dataObject) && ((SDODataObject)dataObject).getChangeSummary() != null && ((SDODataObject)dataObject).getChangeSummary() != this) {
            return new ArrayList();
        }
        if (!this.isCreated(dataObject) && this.isDirty(dataObject)) {
            ArrayList<ChangeSummary.Setting> oldSettingsList = new ArrayList<ChangeSummary.Setting>();
            for (int i = 0; i < dataObject.getInstanceProperties().size(); ++i) {
                SDOProperty nextProp = (SDOProperty)dataObject.getInstanceProperties().get(i);
                ChangeSummary.Setting setting = this.getOldValueForChangedDataObject(dataObject, nextProp);
                if (setting == null) continue;
                oldSettingsList.add(setting);
            }
            List openProps = (List)this.getUnsetOCPropertiesMap().get(dataObject);
            if (openProps != null) {
                for (int i = 0; i < openProps.size(); ++i) {
                    SDOProperty nextProp = (SDOProperty)openProps.get(i);
                    ChangeSummary.Setting setting = this.getOldValueForChangedDataObject(dataObject, nextProp);
                    if (setting == null) continue;
                    oldSettingsList.add(setting);
                }
            }
            return oldSettingsList;
        }
        return new ArrayList();
    }

    public List getUnsetProps(DataObject dataObject) {
        this.getOldValues(dataObject);
        Object value = this.unsetPropsMap.get(dataObject);
        if (value == null) {
            return new ArrayList();
        }
        return (List)value;
    }

    public Map getUnsetOCPropertiesMap() {
        return this.unsetOCPropsMap;
    }

    public List getUnsetOCProperties(DataObject dataObject) {
        Object value = this.unsetOCPropsMap.get(dataObject);
        if (null == value) {
            return new ArrayList();
        }
        return (List)value;
    }

    public void setUnsetOCProperty(DataObject dataObject, Property ocKey) {
        Object value = this.unsetOCPropsMap.get(dataObject);
        if (null == value) {
            ArrayList<Property> aList = new ArrayList<Property>();
            aList.add(ocKey);
            this.unsetOCPropsMap.put(dataObject, aList);
        } else if (!((List)value).contains(ocKey)) {
            ((List)value).add(ocKey);
        }
    }

    public void removeUnsetOCProperty(DataObject dataObject, Property ocKey) {
        Object value = this.unsetOCPropsMap.get(dataObject);
        if (value != null && ((List)value).remove(ocKey) && ((List)value).size() <= 0) {
            this.unsetOCPropsMap.remove(dataObject);
        }
    }

    public void beginLogging() {
        if (!this.logging) {
            this.logging = true;
            this.loggingMapping = true;
            this.resetChanges();
            this.rootDataObject.resetChanges();
        }
    }

    public void resumeLogging() {
        if (!this.logging) {
            this.logging = true;
            this.loggingMapping = true;
        }
    }

    public void endLogging() {
        this.logging = false;
        this.loggingMapping = false;
    }

    public void pauseLogging() {
        this.logging = false;
        this.loggingMapping = false;
    }

    private void resetChanges() {
        this.createdList.clear();
        this.deletedList.clear();
        this.oldSettings.clear();
        this.deepCopies.clear();
        this.oldContainer.clear();
        this.oldContainmentProperty.clear();
        this.unsetPropsMap.clear();
        this.unsetOCPropsMap.clear();
        this.originalValueStores.clear();
        this.originalElements.clear();
        this.reverseDeletedMap.clear();
        this.getOldSequences().clear();
        this.getOriginalSequences().clear();
    }

    public SDODataObject getRootObject() {
        return this.rootDataObject;
    }

    public ChangeSummary.Setting getOldValue(DataObject dataObject, Property property) {
        if (dataObject == null || !this.isDeleted(dataObject) && ((SDODataObject)dataObject).getChangeSummary() != null && ((SDODataObject)dataObject).getChangeSummary() != this) {
            return null;
        }
        if (!this.isCreated(dataObject) && this.isDirty(dataObject)) {
            return this.getOldValueForChangedDataObject(dataObject, (SDOProperty)property);
        }
        return null;
    }

    private ChangeSummary.Setting getOldValueForChangedDataObject(DataObject dataObject, SDOProperty property) {
        if (null == property || property.getType().isChangeSummaryType()) {
            return null;
        }
        ChangeSummary.Setting setting = this.getPropertyInOldSettings(dataObject, property);
        if (setting == null) {
            SDODataObject sdoDataObject = (SDODataObject)dataObject;
            boolean isDeleted = this.isDeleted(dataObject);
            ArrayList oldValue = this.getPropertyInternal(sdoDataObject, property);
            Object currentValue = sdoDataObject.getPropertyInternal(property);
            boolean isSet = sdoDataObject.isSetInternal(property);
            boolean wasSet = this.wasSet(sdoDataObject, property);
            if (property.isMany()) {
                currentValue = ((ListWrapper)currentValue).getCurrentElements();
                if (this.isDirty((ListWrapper)((Object)oldValue))) {
                    List elements = (List)this.getOriginalElements().get(oldValue);
                    oldValue = new ArrayList(elements);
                    if (!property.getType().isDataType()) {
                        for (int i = 0; i < ((List)oldValue).size(); ++i) {
                            Object next = ((List)oldValue).get(i);
                            DataObject deepCopy = this.getOrCreateDeepCopy((DataObject)next);
                            ((List)oldValue).set(i, deepCopy);
                        }
                    }
                } else {
                    oldValue = currentValue;
                }
            }
            if (isDeleted || wasSet != isSet || oldValue != currentValue) {
                if (oldValue != null && !property.getType().isDataType() && oldValue instanceof DataObject) {
                    oldValue = this.getOrCreateDeepCopy((DataObject)oldValue);
                }
                setting = this.buildAndAddOldSetting((SDODataObject)dataObject, property, oldValue, wasSet);
            }
        }
        return setting;
    }

    private ChangeSummary.Setting buildAndAddOldSetting(SDODataObject dataObject, Property property, Object value, boolean isSet) {
        List theList;
        SDOSetting setting = new SDOSetting(property, value);
        setting.setIsSet(isSet);
        if (this.oldSettings.get(dataObject) == null) {
            ArrayList<SDOSetting> aList = new ArrayList<SDOSetting>();
            aList.add(setting);
            this.oldSettings.put(dataObject, aList);
        } else {
            theList = (List)this.oldSettings.get(dataObject);
            theList.add(setting);
        }
        if (!setting.isSet()) {
            theList = (List)this.unsetPropsMap.get(dataObject);
            if (theList == null) {
                ArrayList<String> aList = new ArrayList<String>();
                aList.add(setting.getProperty().getName());
                this.unsetPropsMap.put(dataObject, aList);
            } else if (!theList.contains(setting.getProperty().getName())) {
                theList.add(setting.getProperty().getName());
            }
        }
        return setting;
    }

    public SDODataObject getOldContainer(DataObject dataObject) {
        return (SDODataObject)this.oldContainer.get(dataObject);
    }

    public SDOProperty getOldContainmentProperty(DataObject dataObject) {
        return (SDOProperty)this.oldContainmentProperty.get(dataObject);
    }

    public SDOSequence getOldSequence(DataObject dataObject) {
        if (dataObject == null || !this.isDeleted(dataObject) && ((SDODataObject)dataObject).getChangeSummary() != null && ((SDODataObject)dataObject).getChangeSummary() != this) {
            return null;
        }
        if (!this.isCreated(dataObject) && dataObject.getType().isSequenced()) {
            if (this.getOldSequences().containsKey(dataObject)) {
                return (SDOSequence)this.getOldSequences().get(dataObject);
            }
            SDOSequence originalSeq = (SDOSequence)this.getOriginalSequences().get(dataObject);
            if (originalSeq == null) {
                originalSeq = (SDOSequence)dataObject.getSequence();
            }
            SDOSequence seqWithDeepCopies = new SDOSequence((SDODataObject)dataObject);
            for (int i = 0; i < originalSeq.size(); ++i) {
                Object nextOriginalSettingValue = originalSeq.getValue(i);
                if (nextOriginalSettingValue == null) continue;
                SDOProperty nextOriginalSettingProp = originalSeq.getProperty(i);
                if (nextOriginalSettingProp == null) {
                    seqWithDeepCopies.addText(nextOriginalSettingValue.toString());
                    continue;
                }
                if (nextOriginalSettingProp.getType().isDataType()) {
                    seqWithDeepCopies.addSettingWithoutModifyingDataObject(nextOriginalSettingProp, nextOriginalSettingValue, false);
                    continue;
                }
                seqWithDeepCopies.addSettingWithoutModifyingDataObject(nextOriginalSettingProp, this.getOrCreateDeepCopy((DataObject)nextOriginalSettingValue), false);
            }
            this.getOldSequences().put(dataObject, seqWithDeepCopies);
            return seqWithDeepCopies;
        }
        return null;
    }

    public void undoChanges() {
        SDOProperty oldProp = this.getOldContainmentProperty(this.rootDataObject);
        String oldName = null;
        if (oldProp != null) {
            oldName = oldProp.getName();
        }
        this.rootDataObject.undoChanges(true, this, this.getOldContainer(this.rootDataObject), oldName);
        this.resetChanges();
        this.rootDataObject.resetChanges();
    }

    public void setRootDataObject(DataObject dataObject) {
        this.rootDataObject = (SDODataObject)dataObject;
    }

    public void setLogging(boolean logging) {
        if (logging) {
            this.beginLogging();
        } else {
            this.endLogging();
        }
        this.loggingMapping = logging;
    }

    private ChangeSummary.Setting getPropertyInOldSettings(DataObject dataObject, Property property) {
        Iterator iterOldSettings = null;
        List aList = (List)this.oldSettings.get(dataObject);
        if (aList != null) {
            for (ChangeSummary.Setting curSetting : aList) {
                if (!curSetting.getProperty().equals(property)) continue;
                return curSetting;
            }
        }
        return null;
    }

    public void setHelperContext(HelperContext helperContext) {
        this.aHelperContext = helperContext;
    }

    public void setCreatedXPaths(List createdXPathsList) {
        this.createdXPaths = createdXPathsList;
    }

    public List getCreatedXPaths() {
        return this.createdXPaths;
    }

    public boolean isLoggingMapping() {
        return this.loggingMapping;
    }

    public void setModifiedDoms(List modifiedDomsList) {
        this.modifiedDoms = modifiedDomsList;
    }

    public List getModifiedDoms() {
        return this.modifiedDoms;
    }

    public void setDeletedXPaths(List deletedXPathsList) {
        this.deletedXPaths = deletedXPathsList;
    }

    public Map getOldContainmentProperty() {
        return this.oldContainmentProperty;
    }

    public Map getOldContainer() {
        return this.oldContainer;
    }

    public boolean wasSet(DataObject dataObject, Property property) {
        ValueStore vs = (ValueStore)this.originalValueStores.get(dataObject);
        if (null == vs) {
            vs = ((SDODataObject)dataObject)._getCurrentValueStore();
        }
        if (property.isOpenContent()) {
            return vs.isSetOpenContentProperty(property);
        }
        return vs.isSetDeclaredProperty(((SDOProperty)property).getIndexInType());
    }

    public Object getPropertyInternal(DataObject dataObject, Property property) {
        ValueStore vs = (ValueStore)this.originalValueStores.get(dataObject);
        if (null == vs) {
            vs = ((SDODataObject)dataObject)._getCurrentValueStore();
        }
        if (property.isOpenContent()) {
            return vs.getOpenContentProperty(property);
        }
        return vs.getDeclaredProperty(((SDOProperty)property).getIndexInType());
    }

    public void setPropertyInternal(DataObject dataObject, Property property, Object value) {
        ValueStore vs = (ValueStore)this.originalValueStores.get(dataObject);
        if (property.isOpenContent()) {
            vs.setOpenContentProperty(property, value);
        } else {
            vs.setDeclaredProperty(((SDOProperty)property).getIndexInType(), value);
        }
    }

    public Map getOriginalValueStores() {
        return this.originalValueStores;
    }

    public boolean isDirty(DataObject dataObject) {
        ValueStore vs = (ValueStore)this.originalValueStores.get(dataObject);
        return vs != null;
    }

    public boolean isDirty(ListWrapper aListWrapper) {
        Object originalList = this.getOriginalElements().get(aListWrapper);
        return originalList != null;
    }

    public boolean isDirty(SDOSequence aSequence) {
        Object originalSequence = this.getOriginalSequences().get(aSequence.getDataObject());
        return originalSequence != null;
    }

    public void unsetPropertyInternal(DataObject dataObject, Property property) {
        ValueStore vs = (ValueStore)this.originalValueStores.get(dataObject);
        if (property.isMany()) {
            ListWrapper currentValue = (ListWrapper)dataObject.getList(property);
            this.originalElements.put(currentValue, new ArrayList());
            if (property.isOpenContent()) {
                vs.unsetOpenContentProperty(property);
            } else {
                vs.unsetDeclaredProperty(((SDOProperty)property).getIndexInType());
            }
        } else if (property.isOpenContent()) {
            vs.unsetOpenContentProperty(property);
        } else {
            vs.unsetDeclaredProperty(((SDOProperty)property).getIndexInType());
        }
    }

    public Map getOriginalElements() {
        return this.originalElements;
    }

    private DataObject getOrCreateDeepCopy(DataObject original) {
        DataObject value = (DataObject)this.getDeepCopies().get(original);
        if (null == value) {
            DataObject undoneCopy = ((SDOCopyHelper)this.aHelperContext.getCopyHelper()).copy(original, this);
            this.getDeepCopies().put(original, undoneCopy);
            this.getReverseDeletedMap().put(undoneCopy, original);
            return undoneCopy;
        }
        return value;
    }

    public Map getDeepCopies() {
        return this.deepCopies;
    }

    public Map getReverseDeletedMap() {
        return this.reverseDeletedMap;
    }

    public Map getOriginalSequences() {
        if (null == this.originalSequences) {
            this.originalSequences = new HashMap();
        }
        return this.originalSequences;
    }

    public Map getOldSequences() {
        if (null == this.oldSequences) {
            this.oldSequences = new HashMap();
        }
        return this.oldSequences;
    }

    public String toString() {
        StringBuffer aBuffer = new StringBuffer();
        aBuffer.append("ChangeSummary@");
        aBuffer.append(this.getClass().hashCode());
        aBuffer.append(" [logging: ");
        aBuffer.append(this.logging);
        aBuffer.append(", root: ");
        aBuffer.append(this.rootDataObject);
        List aList = this.getChangedDataObjects();
        if (aList != null) {
            aBuffer.append(", ");
            aBuffer.append(aList.size());
            aBuffer.append(" changes: <");
            boolean first = true;
            Iterator i = aList.iterator();
            while (i.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    aBuffer.append(", ");
                }
                aBuffer.append(i.next());
            }
        }
        aBuffer.append(">]");
        return aBuffer.toString();
    }
}

