/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.io.IOException;
import java.io.Writer;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.tools.schemaframework.VarrayDefinition;

public class ObjectVarrayDefinition
extends VarrayDefinition {
    protected boolean isNullAllowed = false;

    @Override
    public void appendTypeString(Writer writer, AbstractSession session) throws ValidationException {
        try {
            if (this.getType() == null) {
                throw ValidationException.oracleObjectTypeIsNotDefined(this.getTypeName());
            }
            if (this.getTypeName() == "") {
                throw ValidationException.oracleObjectTypeNameIsNotDefined(this.getType());
            }
            FieldTypeDefinition fieldType = new FieldTypeDefinition(this.getTypeName());
            writer.write(fieldType.getName());
            if (!this.isNullAllowed) {
                writer.write(" NOT NULL");
            }
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    public boolean isNullAllowed() {
        return this.isNullAllowed;
    }

    public void setIsNullAllowed(boolean isNullAllowed) {
        this.isNullAllowed = isNullAllowed;
    }
}

