/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.osgi.services.remoteserviceadmin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.eclipse.ecf.remoteservice.IRemoteServiceRegistration;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesUtil {
    protected static final List osgiProperties = Arrays.asList("objectClass", "service.id", "service.bundleid", "service.scope", "endpoint.framework.uuid", "endpoint.id", "endpoint.service.id", "remote.configs.supported", "remote.intents.supported", "service.exported.configs", "service.exported.intents", "service.exported.intents.extra", "service.exported.interfaces", "service.imported", "service.imported.configs", "service.intents");
    protected static final List ecfProperties = Arrays.asList("ecf.robjectClass", "ecf.rsvc.id", "osgirsvc_", "ecf.endpoint.discovery.namingauthority", "ecf.endpoint.discovery.protocols", "ecf.endpoint.discovery.scope", "ecf.endpoint.discovery.servicename", "ecf.endpoint.connecttarget.id", "ecf.endpoint.id", "ecf.endpoint.id.ns", "ecf.endpoint.ts", "ecf.endpoint.idfilter.ids", "ecf.endpoint.rsfilter", "ecf.exported.containerconnectcontext", "ecf.exported.containerfactoryargs", "ecf.exported.containerid", "ecf.service.imported.valuetype", "ecfosgirsvc");

    public static String verifyStringProperty(Map properties, String propName) {
        Object r = properties.get(propName);
        try {
            return (String)r;
        }
        catch (ClassCastException e) {
            IllegalArgumentException iae = new IllegalArgumentException("property value is not a String: " + propName);
            iae.initCause(e);
            throw iae;
        }
    }

    public static Object convertToStringPlusValue(List<String> values) {
        if (values == null) {
            return null;
        }
        int valuesSize = values.size();
        switch (valuesSize) {
            case 0: {
                return null;
            }
            case 1: {
                return values.get(0);
            }
        }
        return values.toArray(new String[valuesSize]);
    }

    public static String[] getStringArrayFromPropertyValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return new String[]{(String)value};
        }
        if (value instanceof String[]) {
            return (String[])value;
        }
        if (value instanceof Collection) {
            return ((Collection)value).toArray(new String[0]);
        }
        return null;
    }

    public static String[] getExportedInterfaces(ServiceReference serviceReference, Map<String, ?> overridingProperties) {
        Object overridingPropValue = overridingProperties.get("service.exported.interfaces");
        if (overridingPropValue != null) {
            return PropertiesUtil.getExportedInterfaces(serviceReference, overridingPropValue);
        }
        return PropertiesUtil.getExportedInterfaces(serviceReference);
    }

    public static String[] getMatchingInterfaces(String[] origin, Object propValue) {
        if (propValue == null || origin == null) {
            return null;
        }
        boolean wildcard = propValue.equals("*");
        if (wildcard) {
            return origin;
        }
        String[] stringArrayValue = PropertiesUtil.getStringArrayFromPropertyValue(propValue);
        if (stringArrayValue == null) {
            return null;
        }
        if (stringArrayValue.length == 1 && stringArrayValue[0].equals("*")) {
            return origin;
        }
        return stringArrayValue;
    }

    private static String[] getExportedInterfaces(ServiceReference serviceReference, Object propValue) {
        if (propValue == null) {
            return null;
        }
        String[] objectClass = (String[])serviceReference.getProperty("objectClass");
        return PropertiesUtil.getMatchingInterfaces(objectClass, propValue);
    }

    public static String[] getExportedInterfaces(ServiceReference serviceReference) {
        return PropertiesUtil.getExportedInterfaces(serviceReference, serviceReference.getProperty("service.exported.interfaces"));
    }

    public static String[] getServiceIntents(ServiceReference serviceReference, Map overridingProperties) {
        String[] extraIntents;
        String[] exportedIntents;
        ArrayList<String> results = new ArrayList<String>();
        String[] intents = PropertiesUtil.getStringArrayFromPropertyValue(overridingProperties.get("service.intents"));
        if (intents == null) {
            intents = PropertiesUtil.getStringArrayFromPropertyValue(serviceReference.getProperty("service.intents"));
        }
        if (intents != null) {
            results.addAll(Arrays.asList(intents));
        }
        if ((exportedIntents = PropertiesUtil.getStringArrayFromPropertyValue(overridingProperties.get("service.exported.intents"))) == null) {
            exportedIntents = PropertiesUtil.getStringArrayFromPropertyValue(serviceReference.getProperty("service.exported.intents"));
        }
        if (exportedIntents != null) {
            results.addAll(Arrays.asList(exportedIntents));
        }
        if ((extraIntents = PropertiesUtil.getStringArrayFromPropertyValue(overridingProperties.get("service.exported.intents.extra"))) == null) {
            extraIntents = PropertiesUtil.getStringArrayFromPropertyValue(serviceReference.getProperty("service.exported.intents.extra"));
        }
        if (extraIntents != null) {
            results.addAll(Arrays.asList(extraIntents));
        }
        if (results.size() == 0) {
            return null;
        }
        return results.toArray(new String[results.size()]);
    }

    public static List getStringPlusProperty(Map properties, String key) {
        Object value = properties.get(key);
        if (value == null) {
            return Collections.EMPTY_LIST;
        }
        if (value instanceof String) {
            return Collections.singletonList((String)value);
        }
        if (value instanceof String[]) {
            String[] values = (String[])value;
            ArrayList<String> result = new ArrayList<String>(values.length);
            int i = 0;
            while (i < values.length) {
                if (values[i] != null) {
                    result.add(values[i]);
                }
                ++i;
            }
            return Collections.unmodifiableList(result);
        }
        if (value instanceof Collection) {
            Collection values = (Collection)value;
            ArrayList<String> result = new ArrayList<String>(values.size());
            for (Object v : values) {
                if (!(v instanceof String)) continue;
                result.add((String)v);
            }
            return Collections.unmodifiableList(result);
        }
        return Collections.EMPTY_LIST;
    }

    public static Object getPropertyValue(ServiceReference serviceReference, String key) {
        return serviceReference == null ? null : serviceReference.getProperty(key);
    }

    public static Object getPropertyValue(ServiceReference serviceReference, Map<String, Object> overridingProperties, String key) {
        Object result = null;
        if (overridingProperties != null) {
            result = overridingProperties.get(key);
        }
        return result != null ? result : PropertiesUtil.getPropertyValue(serviceReference, key);
    }

    public static boolean isOSGiProperty(String key) {
        return osgiProperties.contains(key) || key.startsWith("endpoint.package.version.");
    }

    public static boolean isECFProperty(String key) {
        return ecfProperties.contains(key);
    }

    public static boolean isPrivateProperty(String key) {
        return key.startsWith(".");
    }

    public static boolean isReservedProperty(String key) {
        return PropertiesUtil.isOSGiProperty(key) || PropertiesUtil.isECFProperty(key) || PropertiesUtil.isPrivateProperty(key);
    }

    public static Map createMapFromDictionary(Dictionary input) {
        if (input == null) {
            return null;
        }
        HashMap result = new HashMap();
        Enumeration e = input.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object val = input.get(key);
            result.put(key, val);
        }
        return result;
    }

    public static Dictionary createDictionaryFromMap(Map propMap) {
        if (propMap == null) {
            return null;
        }
        Properties result = new Properties();
        for (Object key : propMap.keySet()) {
            Object val = propMap.get(key);
            if (key == null || val == null) continue;
            ((Dictionary)result).put(key, val);
        }
        return result;
    }

    public static Long getLongWithDefault(Map props, String key, Long def) {
        Object o = props.get(key);
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof String) {
            return Long.valueOf((String)o);
        }
        return def;
    }

    public static String[] getStringArrayWithDefault(Map<String, Object> properties, String key, String[] def) {
        Object o = properties.get(key);
        if (o instanceof String) {
            return new String[]{(String)o};
        }
        if (o instanceof String[]) {
            return (String[])o;
        }
        if (o instanceof List) {
            List l = (List)o;
            return l.toArray(new String[l.size()]);
        }
        return def;
    }

    public static String getStringWithDefault(Map props, String key, String def) {
        Object o = props.get(key);
        if (o == null || !(o instanceof String)) {
            return def;
        }
        return (String)o;
    }

    public static Map<String, Object> copyProperties(IRemoteServiceRegistration rsRegistration, Map<String, Object> target) {
        String[] keys = rsRegistration.getPropertyKeys();
        int i = 0;
        while (i < keys.length) {
            target.put(keys[i], rsRegistration.getProperty(keys[i]));
            ++i;
        }
        return target;
    }

    public static Map<String, Object> copyProperties(Map<String, Object> source, Map<String, Object> target) {
        for (String key : source.keySet()) {
            target.put(key, source.get(key));
        }
        return target;
    }

    public static Map<String, Object> copyProperties(ServiceReference serviceReference, Map<String, Object> target) {
        String[] keys = serviceReference.getPropertyKeys();
        int i = 0;
        while (i < keys.length) {
            target.put(keys[i], serviceReference.getProperty(keys[i]));
            ++i;
        }
        return target;
    }

    public static Map<String, Object> copyNonECFProperties(Map<String, Object> source, Map<String, Object> target) {
        for (String key : source.keySet()) {
            if (PropertiesUtil.isECFProperty(key)) continue;
            target.put(key, source.get(key));
        }
        return target;
    }

    public static Map<String, Object> copyNonReservedProperties(Map<String, Object> source, Map<String, Object> target) {
        for (String key : source.keySet()) {
            if (PropertiesUtil.isReservedProperty(key)) continue;
            target.put(key, source.get(key));
        }
        return target;
    }

    public static Map<String, Object> copyNonECFProperties(ServiceReference serviceReference, Map<String, Object> target) {
        String[] keys = serviceReference.getPropertyKeys();
        int i = 0;
        while (i < keys.length) {
            if (!PropertiesUtil.isECFProperty(keys[i])) {
                target.put(keys[i], serviceReference.getProperty(keys[i]));
            }
            ++i;
        }
        return target;
    }

    public static Map<String, Object> copyNonReservedProperties(ServiceReference serviceReference, Map<String, Object> target) {
        String[] keys = serviceReference.getPropertyKeys();
        int i = 0;
        while (i < keys.length) {
            if (!PropertiesUtil.isReservedProperty(keys[i])) {
                target.put(keys[i], serviceReference.getProperty(keys[i]));
            }
            ++i;
        }
        return target;
    }

    public static Map<String, Object> copyNonReservedProperties(IRemoteServiceReference rsReference, Map<String, Object> target) {
        String[] keys = rsReference.getPropertyKeys();
        int i = 0;
        while (i < keys.length) {
            if (!PropertiesUtil.isReservedProperty(keys[i])) {
                target.put(keys[i], rsReference.getProperty(keys[i]));
            }
            ++i;
        }
        return target;
    }

    public static Map mergeProperties(ServiceReference serviceReference, Map<String, Object> overrides) {
        return PropertiesUtil.mergeProperties(PropertiesUtil.copyProperties(serviceReference, new HashMap<String, Object>()), overrides);
    }

    public static Map mergeProperties(Map<String, Object> source, Map<String, Object> overrides) {
        Map<String, Object> target = PropertiesUtil.copyProperties(source, new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER));
        Set<String> keySet = overrides.keySet();
        for (String key : keySet) {
            if ("service.id".equals(key) || "objectClass".equals(key)) continue;
            target.remove(key.toLowerCase());
            target.put(key.toLowerCase(), overrides.get(key));
        }
        return target;
    }
}

