/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.sync.doc.cola;

import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.internal.sync.doc.cola.ColaDocumentChangeMessage;
import org.eclipse.ecf.internal.sync.doc.cola.ColaTransformationStrategy;
import org.eclipse.ecf.sync.doc.DocumentChangeMessage;

public class ColaInsertionTransformationStategy
implements ColaTransformationStrategy {
    private static final long serialVersionUID = 5192625383622519749L;
    private static ColaInsertionTransformationStategy INSTANCE;

    private ColaInsertionTransformationStategy() {
    }

    public static ColaTransformationStrategy getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ColaInsertionTransformationStategy();
        }
        return INSTANCE;
    }

    public ColaDocumentChangeMessage getOperationalTransform(ColaDocumentChangeMessage remoteIncomingMsg, ColaDocumentChangeMessage localAppliedMsg, boolean localMsgHighPrio) {
        Trace.entering((String)"org.eclipse.ecf.sync", (String)"org.eclipse.ecf.sync/debug/methods/entering", this.getClass(), (String)"getOperationalTransform", (Object[])new Object[]{remoteIncomingMsg, localAppliedMsg, new Boolean(localMsgHighPrio)});
        ColaDocumentChangeMessage remoteTransformedMsg = remoteIncomingMsg;
        if (localAppliedMsg.isInsertion()) {
            if (remoteTransformedMsg.getOffset() < localAppliedMsg.getOffset()) {
                localAppliedMsg.setOffset(localAppliedMsg.getOffset() + remoteTransformedMsg.getOffset());
            } else if (remoteTransformedMsg.getOffset() == localAppliedMsg.getOffset()) {
                if (localMsgHighPrio) {
                    remoteTransformedMsg.setOffset(remoteTransformedMsg.getOffset() + localAppliedMsg.getText().length());
                } else {
                    localAppliedMsg.setOffset(localAppliedMsg.getOffset() + remoteTransformedMsg.getText().length());
                }
            } else if (remoteTransformedMsg.getOffset() > localAppliedMsg.getOffset()) {
                remoteTransformedMsg.setOffset(remoteTransformedMsg.getOffset() + localAppliedMsg.getText().length());
            }
        } else if (localAppliedMsg.isDeletion()) {
            if (remoteTransformedMsg.getOffset() <= localAppliedMsg.getOffset()) {
                localAppliedMsg.setOffset(localAppliedMsg.getOffset() + remoteTransformedMsg.getLengthOfInsertedText());
            } else if (remoteTransformedMsg.getOffset() > localAppliedMsg.getOffset()) {
                if (remoteTransformedMsg.getOffset() > localAppliedMsg.getOffset() + localAppliedMsg.getLengthOfReplacedText()) {
                    remoteTransformedMsg.setOffset(remoteTransformedMsg.getOffset() - localAppliedMsg.getLengthOfReplacedText());
                } else if (remoteTransformedMsg.getOffset() <= localAppliedMsg.getOffset() + localAppliedMsg.getLengthOfReplacedText()) {
                    DocumentChangeMessage deletionFirstMessage = new DocumentChangeMessage(localAppliedMsg.getOffset(), remoteTransformedMsg.getOffset() - localAppliedMsg.getOffset(), localAppliedMsg.getText());
                    ColaDocumentChangeMessage deletionFirstPart = new ColaDocumentChangeMessage(deletionFirstMessage, localAppliedMsg.getLocalOperationsCount(), localAppliedMsg.getRemoteOperationsCount());
                    localAppliedMsg.addToSplitUpRepresentation(deletionFirstPart);
                    DocumentChangeMessage deletionSecondMessage = new DocumentChangeMessage(localAppliedMsg.getOffset() + remoteTransformedMsg.getLengthOfInsertedText(), localAppliedMsg.getLengthOfReplacedText() - deletionFirstPart.getLengthOfReplacedText(), localAppliedMsg.getText());
                    ColaDocumentChangeMessage deletionSecondPart = new ColaDocumentChangeMessage(deletionSecondMessage, localAppliedMsg.getLocalOperationsCount(), localAppliedMsg.getRemoteOperationsCount());
                    localAppliedMsg.addToSplitUpRepresentation(deletionSecondPart);
                    localAppliedMsg.setSplitUp(true);
                    remoteTransformedMsg.setOffset(localAppliedMsg.getOffset());
                }
            }
        }
        Trace.exiting((String)"org.eclipse.ecf.sync", (String)"org.eclipse.ecf.sync/debug/methods/exiting", this.getClass(), (String)"getOperationalTransform", (Object)remoteTransformedMsg);
        return remoteTransformedMsg;
    }
}

