/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.discovery;

import java.net.URI;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.discovery.identity.IServiceTypeID;
import org.eclipse.ecf.discovery.identity.ServiceID;

public class DiscoveryNamespace
extends Namespace {
    private static final long serialVersionUID = 6474091408790223505L;
    public static final String NAME = "ecf.namespace.discovery";

    public DiscoveryNamespace() {
    }

    public DiscoveryNamespace(String description) {
        super(NAME, description);
    }

    public ID createInstance(Object[] parameters) throws IDCreateException {
        if (parameters != null && parameters.length == 1 && parameters[0] instanceof IServiceTypeID) {
            return (ID)parameters[0];
        }
        if (parameters != null && parameters.length == 2 && parameters[0] instanceof IServiceTypeID && parameters[1] instanceof URI) {
            IServiceTypeID type = (IServiceTypeID)parameters[0];
            URI uri = (URI)parameters[1];
            return new DiscoveryServiceID(this, type, uri);
        }
        throw new IDCreateException("Parameters must be of type IServiceTypeID");
    }

    public String getScheme() {
        return "discovery";
    }

    private static class DiscoveryServiceID
    extends ServiceID {
        private static final long serialVersionUID = -9017925060137305026L;

        public DiscoveryServiceID(Namespace namespace, IServiceTypeID type, URI uri) {
            super(namespace, type, uri);
        }
    }
}

