/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smackx.FormField;
import org.jivesoftware.smackx.packet.DataForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportedData {
    private List<Column> columns = new ArrayList<Column>();
    private List<Row> rows = new ArrayList<Row>();
    private String title = "";

    public static ReportedData getReportedDataFrom(Packet packet) {
        DataForm dataForm;
        PacketExtension packetExtension = packet.getExtension("x", "jabber:x:data");
        if (packetExtension != null && (dataForm = (DataForm)packetExtension).getReportedData() != null) {
            return new ReportedData(dataForm);
        }
        return null;
    }

    private ReportedData(DataForm dataForm) {
        Iterator<FormField> fields = dataForm.getReportedData().getFields();
        while (fields.hasNext()) {
            FormField field = fields.next();
            this.columns.add(new Column(field.getLabel(), field.getVariable(), field.getType()));
        }
        Iterator<DataForm.Item> items = dataForm.getItems();
        while (items.hasNext()) {
            DataForm.Item item = items.next();
            ArrayList<Field> fieldList = new ArrayList<Field>(this.columns.size());
            Iterator<FormField> fields2 = item.getFields();
            while (fields2.hasNext()) {
                FormField field = fields2.next();
                ArrayList<String> values = new ArrayList<String>();
                Iterator<String> it = field.getValues();
                while (it.hasNext()) {
                    values.add(it.next());
                }
                fieldList.add(new Field(field.getVariable(), values));
            }
            this.rows.add(new Row(fieldList));
        }
        this.title = dataForm.getTitle();
    }

    public ReportedData() {
    }

    public void addRow(Row row) {
        this.rows.add(row);
    }

    public void addColumn(Column column) {
        this.columns.add(column);
    }

    public Iterator<Row> getRows() {
        return Collections.unmodifiableList(new ArrayList<Row>(this.rows)).iterator();
    }

    public Iterator<Column> getColumns() {
        return Collections.unmodifiableList(new ArrayList<Column>(this.columns)).iterator();
    }

    public String getTitle() {
        return this.title;
    }

    public static class Column {
        private String label;
        private String variable;
        private String type;

        public Column(String label, String variable, String type) {
            this.label = label;
            this.variable = variable;
            this.type = type;
        }

        public String getLabel() {
            return this.label;
        }

        public String getType() {
            return this.type;
        }

        public String getVariable() {
            return this.variable;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Field {
        private String variable;
        private List<String> values;

        public Field(String variable, List<String> values) {
            this.variable = variable;
            this.values = values;
        }

        public String getVariable() {
            return this.variable;
        }

        public Iterator<String> getValues() {
            return Collections.unmodifiableList(this.values).iterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Row {
        private List<Field> fields = new ArrayList<Field>();

        public Row(List<Field> fields) {
            this.fields = fields;
        }

        public Iterator getValues(String variable) {
            Iterator<Field> it = this.getFields();
            while (it.hasNext()) {
                Field field = it.next();
                if (!variable.equalsIgnoreCase(field.getVariable())) continue;
                return field.getValues();
            }
            return null;
        }

        private Iterator<Field> getFields() {
            return Collections.unmodifiableList(new ArrayList<Field>(this.fields)).iterator();
        }
    }
}

