/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.generic;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.GUID;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.LongID;
import org.eclipse.ecf.core.identity.StringID;
import org.eclipse.ecf.core.identity.URIID;
import org.eclipse.ecf.core.provider.IContainerInstantiator;
import org.eclipse.ecf.core.provider.IRemoteServiceContainerInstantiator;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.internal.provider.ProviderPlugin;
import org.eclipse.ecf.provider.generic.SOContainerConfig;
import org.eclipse.ecf.provider.generic.TCPClientSOContainer;
import org.eclipse.ecf.provider.generic.TCPServerSOContainer;

public class GenericContainerInstantiator
implements IContainerInstantiator,
IRemoteServiceContainerInstantiator {
    protected static final String[] genericProviderIntents = new String[]{"passByValue", "exactlyOnce", "ordered"};
    public static final String TCPCLIENT_NAME = "ecf.generic.client";
    public static final String TCPSERVER_NAME = "ecf.generic.server";
    private static final int CREATE_INSTANCE_ERROR_CODE = 4441;
    private static final String ID_PROP = "id";
    private static final String KEEPALIVE_PROP = "keepAlive";
    private static final Object HOSTNAME_PROP = "hostname";
    private static final Object PORT_PROP = "port";
    private static final Object PATH_PROP = "path";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    protected ID getIDFromArg(Object arg) throws IDCreateException {
        if (arg == null) {
            throw new IDCreateException("id cannot be null");
        }
        String val = null;
        if (arg instanceof StringID) {
            return (ID)arg;
        }
        if (arg instanceof GUID) {
            val = ((GUID)arg).getName();
        } else if (arg instanceof URIID) {
            val = ((URIID)arg).toURI().toString();
        } else if (arg instanceof LongID) {
            val = ((LongID)arg).getName();
        }
        if (arg instanceof String) {
            val = (String)arg;
        }
        if (arg instanceof Integer) {
            val = IDFactory.getDefault().createGUID(((Integer)arg).intValue()).getName();
        }
        if (val == null) {
            val = IDFactory.getDefault().createGUID().getName();
        }
        return IDFactory.getDefault().createStringID(val);
    }

    protected Integer getIntegerFromArg(Object arg) {
        if (arg == null) {
            return new Integer(-1);
        }
        if (arg instanceof Integer) {
            return (Integer)arg;
        }
        if (arg instanceof String) {
            return new Integer((String)arg);
        }
        throw new IllegalArgumentException("arg=" + arg + " is not of integer type");
    }

    protected GenericContainerArgs getClientArgs(Object[] args) throws IDCreateException {
        ID newID = null;
        Integer ka = null;
        if (args != null && args.length > 0) {
            if (args[0] instanceof Map) {
                Map map = (Map)args[0];
                Object idVal = map.get(ID_PROP);
                if (idVal == null) {
                    idVal = IDFactory.getDefault().createGUID();
                } else {
                    newID = this.getIDFromArg(idVal);
                }
                Object o = map.get(KEEPALIVE_PROP);
                if (o == null) {
                    o = map.get(KEEPALIVE_PROP.toLowerCase());
                }
                ka = this.getIntegerFromArg(o);
            } else if (args.length > 1) {
                if (args[0] instanceof String || args[0] instanceof ID) {
                    newID = this.getIDFromArg(args[0]);
                }
                if (args[1] instanceof String || args[1] instanceof Integer) {
                    ka = this.getIntegerFromArg(args[1]);
                }
            } else {
                newID = this.getIDFromArg(args[0]);
            }
        }
        if (newID == null) {
            newID = IDFactory.getDefault().createStringID(IDFactory.getDefault().createGUID().getName());
        }
        if (ka == null) {
            ka = new Integer(TCPServerSOContainer.DEFAULT_KEEPALIVE);
        }
        return new GenericContainerArgs(newID, ka);
    }

    protected boolean isClient(ContainerTypeDescription description) {
        return !description.getName().equals(TCPSERVER_NAME);
    }

    protected GenericContainerArgs getServerArgs(Object[] args) throws IDCreateException {
        ID newID = null;
        Integer ka = null;
        if (args != null && args.length > 0) {
            if (args[0] instanceof Map) {
                Map map = (Map)args[0];
                Object idVal = map.get(ID_PROP);
                if (idVal != null) {
                    newID = this.getIDFromArg(idVal);
                } else {
                    String hostname = TCPServerSOContainer.DEFAULT_HOST;
                    Object hostVal = map.get(HOSTNAME_PROP);
                    if (hostVal != null) {
                        if (!(hostVal instanceof String)) {
                            throw new IllegalArgumentException("hostname value must be of type String");
                        }
                        hostname = (String)hostVal;
                    }
                    int port = -1;
                    Object portVal = map.get(PORT_PROP);
                    if (portVal != null) {
                        port = this.getIntegerFromArg(portVal);
                    }
                    if (port < 0) {
                        port = this.getTCPServerPort(port);
                    }
                    String path = TCPServerSOContainer.DEFAULT_NAME;
                    Object pathVal = map.get(PATH_PROP);
                    if (pathVal != null) {
                        if (!(pathVal instanceof String)) {
                            throw new IllegalArgumentException("path value must be of type String");
                        }
                        path = (String)pathVal;
                    }
                    newID = this.createTCPServerID(hostname, port, path);
                }
                Object o = map.get(KEEPALIVE_PROP);
                if (o == null) {
                    o = map.get(KEEPALIVE_PROP.toLowerCase());
                }
                ka = this.getIntegerFromArg(o);
            } else if (args.length > 1) {
                if (args[0] instanceof String || args[0] instanceof ID) {
                    newID = this.getIDFromArg(args[0]);
                }
                if (args[1] instanceof String || args[1] instanceof Integer) {
                    ka = this.getIntegerFromArg(args[1]);
                }
            } else {
                newID = this.getIDFromArg(args[0]);
            }
        }
        if (newID == null) {
            int port = this.getTCPServerPort(-1);
            newID = this.createTCPServerID(TCPServerSOContainer.DEFAULT_HOST, port, TCPServerSOContainer.DEFAULT_NAME);
        }
        if (ka == null) {
            ka = new Integer(TCPServerSOContainer.DEFAULT_KEEPALIVE);
        }
        return new GenericContainerArgs(newID, ka);
    }

    private ID createTCPServerID(String hostname, int port, String path) {
        return IDFactory.getDefault().createStringID("ecftcp://" + hostname + ":" + port + path);
    }

    private int getTCPServerPort(int input) {
        if (TCPServerSOContainer.DEFAULT_FALLBACK_PORT) {
            input = this.getFreePort();
        } else if (this.portIsFree(TCPServerSOContainer.DEFAULT_PORT)) {
            input = TCPServerSOContainer.DEFAULT_PORT;
        }
        if (input < 0) {
            throw new IDCreateException("No server port is available for generic server creation.  org.eclipse.ecf.provider.generic.port.fallback=" + TCPServerSOContainer.DEFAULT_FALLBACK_PORT + " and org.eclipse.ecf.provider.generic.port=" + TCPServerSOContainer.DEFAULT_PORT);
        }
        return input;
    }

    /*
     * Exception decompiling
     */
    private boolean portIsFree(int port) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [4 : 63->66)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int getFreePort() {
        int port = -1;
        try {
            ServerSocket ss = new ServerSocket(0);
            port = ss.getLocalPort();
            ss.close();
        }
        catch (IOException e) {
            return -1;
        }
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IContainer createInstance(ContainerTypeDescription description, Object[] args) throws ContainerCreateException {
        boolean isClient = this.isClient(description);
        try {
            GenericContainerArgs gcargs = null;
            if (isClient) {
                gcargs = this.getClientArgs(args);
                return new TCPClientSOContainer(new SOContainerConfig(gcargs.getID()), gcargs.getKeepAlive());
            }
            GenericContainerInstantiator genericContainerInstantiator = this;
            synchronized (genericContainerInstantiator) {
                gcargs = this.getServerArgs(args);
                return new TCPServerSOContainer(new SOContainerConfig(gcargs.getID()), gcargs.getKeepAlive());
            }
        }
        catch (Exception e) {
            Trace.catching((String)"org.eclipse.ecf.provider", (String)"org.eclipse.ecf.provider/debug/exceptions/catching", this.getClass(), (String)"createInstance", (Throwable)e);
            ProviderPlugin.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.provider", 4441, "createInstance", (Throwable)e));
            Trace.throwing((String)"org.eclipse.ecf.provider", (String)"org.eclipse.ecf.provider/debug/exceptions/throwing", this.getClass(), (String)"createInstance", (Throwable)e);
            throw new ContainerCreateException("Create of containerType=" + description.getName() + " failed.", (Throwable)e);
        }
    }

    protected Set getAdaptersForClass(Class clazz) {
        HashSet<String> result = new HashSet<String>();
        IAdapterManager adapterManager = ProviderPlugin.getDefault().getAdapterManager();
        if (adapterManager != null) {
            result.addAll(Arrays.asList(adapterManager.computeAdapterTypes(clazz)));
        }
        return result;
    }

    protected Set getInterfacesForClass(Set s, Class clazz) {
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz2)) {
            return s;
        }
        s.addAll(this.getInterfacesForClass(s, clazz.getSuperclass()));
        s.addAll(Arrays.asList(clazz.getInterfaces()));
        return s;
    }

    protected Set getInterfacesForClass(Class clazz) {
        Set clazzes = this.getInterfacesForClass(new HashSet(), clazz);
        HashSet<String> result = new HashSet<String>();
        Iterator i = clazzes.iterator();
        while (i.hasNext()) {
            result.add(((Class)i.next()).getName());
        }
        return result;
    }

    protected String[] getInterfacesAndAdaptersForClass(Class clazz) {
        Set result = this.getAdaptersForClass(clazz);
        result.addAll(this.getInterfacesForClass(clazz));
        return result.toArray(new String[0]);
    }

    public String[] getSupportedAdapterTypes(ContainerTypeDescription description) {
        if (!this.isClient(description)) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ecf.provider.generic.TCPServerSOContainer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return this.getInterfacesAndAdaptersForClass(clazz);
        }
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.ecf.provider.generic.TCPClientSOContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return this.getInterfacesAndAdaptersForClass(clazz);
    }

    public Class[][] getSupportedParameterTypes(ContainerTypeDescription description) {
        if (!this.isClient(description)) {
            Class[][] classArray = new Class[2][];
            Class[] classArray2 = new Class[1];
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.eclipse.ecf.core.identity.ID");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray2[0] = clazz;
            classArray[0] = classArray2;
            Class[] classArray3 = new Class[2];
            Class<?> clazz2 = class$3;
            if (clazz2 == null) {
                try {
                    clazz2 = class$3 = Class.forName("org.eclipse.ecf.core.identity.ID");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray3[0] = clazz2;
            Class<?> clazz3 = class$4;
            if (clazz3 == null) {
                try {
                    clazz3 = class$4 = Class.forName("java.lang.Integer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray3[1] = clazz3;
            classArray[1] = classArray3;
            return classArray;
        }
        Class[][] classArray = new Class[3][];
        classArray[0] = new Class[0];
        Class[] classArray4 = new Class[1];
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.ecf.core.identity.ID");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray4[0] = clazz;
        classArray[1] = classArray4;
        Class[] classArray5 = new Class[2];
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.ecf.core.identity.ID");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray5[0] = clazz4;
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray5[1] = clazz5;
        classArray[2] = classArray5;
        return classArray;
    }

    public String[] getSupportedIntents(ContainerTypeDescription description) {
        return genericProviderIntents;
    }

    public String[] getSupportedConfigs(ContainerTypeDescription description) {
        return new String[]{description.getName()};
    }

    public String[] getImportedConfigs(ContainerTypeDescription description, String[] exporterSupportedConfigs) {
        if (exporterSupportedConfigs == null) {
            return null;
        }
        ArrayList<String> results = new ArrayList<String>();
        List<String> supportedConfigs = Arrays.asList(exporterSupportedConfigs);
        if (TCPSERVER_NAME.equals(description.getName())) {
            if (supportedConfigs.contains(TCPCLIENT_NAME)) {
                results.add(TCPSERVER_NAME);
            }
        } else if (TCPCLIENT_NAME.equals(description.getName()) && (supportedConfigs.contains(TCPSERVER_NAME) || supportedConfigs.contains(TCPCLIENT_NAME))) {
            results.add(TCPCLIENT_NAME);
        }
        if (results.size() == 0) {
            return null;
        }
        return results.toArray(new String[0]);
    }

    public Dictionary getPropertiesForImportedConfigs(ContainerTypeDescription description, String[] importedConfigs, Dictionary exportedProperties) {
        return null;
    }

    protected class GenericContainerArgs {
        ID id;
        Integer keepAlive;

        public GenericContainerArgs(ID id, Integer keepAlive) {
            this.id = id;
            this.keepAlive = keepAlive;
        }

        public ID getID() {
            return this.id;
        }

        public Integer getKeepAlive() {
            return this.keepAlive;
        }
    }
}

