/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.eclipse.ecf.internal.remoteservice.Activator;
import org.eclipse.ecf.remoteservice.util.StreamUtil;

public class ObjectSerializationUtil {
    public static final int DEFAULT_BAOS_BUFFER_SIZE = 4096;
    private StreamUtil streamUtil = new StreamUtil(4096);

    public byte[] readToByteArray(InputStream input) throws IOException {
        return this.streamUtil.toByteArray(input);
    }

    public void writeByteArray(OutputStream outs, byte[] bytes) throws IOException {
        this.streamUtil.writeByteArray(outs, bytes);
    }

    public Object deserializeFromBytes(byte[] bytes) throws IOException {
        if (bytes.length == 0) {
            return null;
        }
        ByteArrayInputStream bins = new ByteArrayInputStream(bytes);
        ObjectInputStream oins = Activator.getDefault().createObjectInputStream(bins);
        Object result = null;
        try {
            result = oins.readObject();
        }
        catch (ClassNotFoundException e) {
            IOException t = new IOException("Class not found when deserializing object");
            t.setStackTrace(e.getStackTrace());
            throw t;
        }
        return result;
    }

    public byte[] serializeToBytes(Object object) throws IOException {
        if (object == null) {
            return new byte[0];
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(4096);
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(object);
        return bos.toByteArray();
    }
}

