/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ecf.ui.subscriber;

import org.eclipse.core.resources.IResource;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.jface.action.IAction;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.internal.ecf.core.RemoteShare;
import org.eclipse.team.internal.ecf.core.variants.RemoteResourceVariantTreeSubscriber;
import org.eclipse.team.internal.ecf.ui.Messages;
import org.eclipse.team.internal.ecf.ui.actions.OverrideWithRemoteAction;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.SubscriberParticipant;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;

public class RemoteSubscriberParticipant
extends SubscriberParticipant {
    public RemoteSubscriberParticipant(RemoteShare share, ID ownId, ID remoteId) {
        this.setSubscriber((Subscriber)new RemoteResourceVariantTreeSubscriber(share, ownId, remoteId));
    }

    public void setResources(IResource[] resources) {
        RemoteResourceVariantTreeSubscriber subscriber = (RemoteResourceVariantTreeSubscriber)this.getSubscriber();
        subscriber.setResources(resources);
    }

    protected void initializeConfiguration(ISynchronizePageConfiguration configuration) {
        super.initializeConfiguration(configuration);
        configuration.setProperty("org.eclipse.team.ui.P_PAGE_DESCRIPTION", (Object)Messages.RemoteSubscriberParticipant_PageDescription);
        configuration.addActionContribution(new SynchronizePageActionGroup(){

            public void initialize(ISynchronizePageConfiguration pageConfiguration) {
                super.initialize(pageConfiguration);
                this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", "synchronize", (IAction)new OverrideWithRemoteAction(pageConfiguration));
            }
        });
        configuration.setSupportedModes(15);
        configuration.setMode(4);
    }

    public String getName() {
        return Messages.RemoteSubscriberParticipant_PageDescription;
    }

    public String getId() {
        return "org.eclipse.ecf.sync.team.participant";
    }

    public String getSecondaryId() {
        return "secondaryId";
    }
}

