/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core.sharedobject.model;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.sharedobject.OptimisticSharedObject;
import org.eclipse.ecf.core.sharedobject.SharedObjectMsg;
import org.eclipse.ecf.core.sharedobject.model.ISharedModelEvent;
import org.eclipse.ecf.core.sharedobject.model.ISharedModelListener;
import org.eclipse.ecf.core.sharedobject.model.ISharedModelPropertyAddEvent;
import org.eclipse.ecf.core.sharedobject.model.ISharedModelPropertyRemoveEvent;
import org.eclipse.ecf.core.sharedobject.model.ISharedModelPropertyValueChangeEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedModel
extends OptimisticSharedObject {
    private List<ISharedModelListener> listeners = new ArrayList<ISharedModelListener>();
    private Map<String, Property> properties = new HashMap<String, Property>();
    protected final String SEND_PROPERTY_TO_MSG = ".sendPropertyTo.";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addListener(ISharedModelListener listener) {
        List<ISharedModelListener> list = this.listeners;
        synchronized (list) {
            return this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(ISharedModelListener listener) {
        List<ISharedModelListener> list = this.listeners;
        synchronized (list) {
            return this.listeners.remove(listener);
        }
    }

    protected void handleListenerException(ISharedModelListener l, Throwable exception) {
        this.log(0, "Exception in listener " + l, exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireListeners(final ISharedModelEvent event) {
        ArrayList<ISharedModelListener> localCopy = null;
        List<ISharedModelListener> list = this.listeners;
        synchronized (list) {
            localCopy = new ArrayList<ISharedModelListener>(this.listeners);
        }
        Iterator iterator = localCopy.iterator();
        while (iterator.hasNext()) {
            ISharedModelListener l;
            final ISharedModelListener list2 = l = (ISharedModelListener)iterator.next();
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    SharedModel.this.handleListenerException(list2, exception);
                }

                public void run() throws Exception {
                    list2.handleEvent(event);
                }
            });
        }
    }

    @Override
    public void dispose(ID containerID) {
        super.dispose(containerID);
        this.listeners.clear();
        this.removeAllProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<Property> copyProperties() {
        ArrayList<Property> results = new ArrayList<Property>();
        Map<String, Property> map = this.properties;
        synchronized (map) {
            for (String name : this.properties.keySet()) {
                results.add(this.properties.get(name));
            }
        }
        return results;
    }

    protected Property addProperty(String name) {
        return this.addProperty(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Property addProperty(String name, Object value) {
        Map<String, Property> map = this.properties;
        synchronized (map) {
            Property p;
            block4: {
                p = this.getProperty(name);
                if (p == null) break block4;
                return null;
            }
            p = new Property(this, name, value);
            this.addProperty(p);
            return p;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Property addProperty(final Property property) {
        if (property == null) {
            throw new NullPointerException("property cannot be null");
        }
        Property oldProperty = null;
        Map<String, Property> map = this.properties;
        synchronized (map) {
            oldProperty = this.properties.put(property.getName(), property);
        }
        final Property op = oldProperty;
        this.fireListeners(new ISharedModelPropertyAddEvent(){

            public SharedModel getSource() {
                return SharedModel.this;
            }

            public Property getAddedProperty() {
                return property;
            }

            public Property getPreAddedProperty() {
                return op;
            }
        });
        return op;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Property removeProperty(String propertyName) {
        if (propertyName == null) {
            throw new NullPointerException("propertyName cannot be null");
        }
        Property oldProperty = null;
        Map<String, Property> map = this.properties;
        synchronized (map) {
            oldProperty = this.properties.remove(propertyName);
        }
        final Property op = oldProperty;
        this.fireListeners(new ISharedModelPropertyRemoveEvent(){

            public SharedModel getSource() {
                return SharedModel.this;
            }

            public Property getRemovedProperty() {
                return op;
            }
        });
        return op;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Property getProperty(String propertyName) {
        if (propertyName == null) {
            throw new NullPointerException("propertyName cannot be null");
        }
        Map<String, Property> map = this.properties;
        synchronized (map) {
            return this.properties.get(propertyName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Property getOrAddProperty(String propertyName) {
        if (propertyName == null) {
            throw new NullPointerException("propertyName cannot be null");
        }
        Map<String, Property> map = this.properties;
        synchronized (map) {
            Property p = this.getProperty(propertyName);
            if (p != null) {
                return p;
            }
            return this.addProperty(propertyName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Property setOrAddProperty(String propertyName, Object value) {
        if (propertyName == null) {
            throw new NullPointerException("propertyName cannot be null");
        }
        Map<String, Property> map = this.properties;
        synchronized (map) {
            Property p = this.getProperty(propertyName);
            if (p != null) {
                p.setValue(value);
                return p;
            }
            return this.addProperty(propertyName, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAllProperties() {
        Map<String, Property> map = this.properties;
        synchronized (map) {
            this.properties.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, ?> getMapFromProperties() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<String, Property> map = this.properties;
        synchronized (map) {
            for (String key : this.properties.keySet()) {
                Property p = this.getProperty(key);
                if (p != null) {
                    result.put(key, p.getValue());
                    continue;
                }
                result.put(key, null);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPropertiesFromMap(Map<String, ?> map) {
        if (map == null) {
            return;
        }
        Map<String, Property> map2 = this.properties;
        synchronized (map2) {
            for (String key : map.keySet()) {
                Property p = this.getProperty(key);
                Object val = map.get(key);
                if (p != null) {
                    p.setValue(val);
                    continue;
                }
                this.addProperty(key, val);
            }
        }
    }

    protected final void sendPropertyTo(ID target, String msg, Property property) throws IOException {
        if (property == null) {
            throw new IOException("property to send cannot be null");
        }
        this.sendSharedObjectMsgTo(target, SharedObjectMsg.createMsg(SharedModel.class.getName(), ".sendPropertyTo." + msg, property));
    }

    protected final void sendPropertyTo(ID target, Property property) throws IOException {
        this.sendPropertyTo(target, property.getName(), property);
    }

    @Override
    protected boolean handleSharedObjectMsg(ID fromID, SharedObjectMsg msg) {
        String methodName;
        if (SharedModel.class.getName().equals(msg.getClassName()) && (methodName = msg.getMethod()) != null && methodName.startsWith(".sendPropertyTo.")) {
            return this.handlePropertyTo(fromID, methodName.substring(0, ".sendPropertyTo.".length() - 1), (Property)msg.getParameters()[0]);
        }
        return super.handleSharedObjectMsg(fromID, msg);
    }

    protected boolean handlePropertyTo(ID fromID, String msg, Property property) {
        return false;
    }

    public class Property
    implements Serializable {
        private static final long serialVersionUID = -716933143243026805L;
        private SharedModel model;
        private String name;
        private Object value;

        public Property(SharedModel model, String name, Object value) {
            Assert.isNotNull((Object)model);
            this.model = model;
            Assert.isNotNull((Object)name);
            this.name = name;
            this.value = value;
        }

        public Property(SharedModel model, String name) {
            this(model, name, null);
        }

        public SharedModel getModel() {
            return this.model;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object newValue) {
            final Object previousValue = this.value;
            this.value = newValue;
            this.getModel().fireListeners(new ISharedModelPropertyValueChangeEvent(){

                public SharedModel getSource() {
                    return Property.this.getModel();
                }

                public Property getProperty() {
                    return Property.this;
                }

                public Object getPreviousValue() {
                    return previousValue;
                }

                public Object getValue() {
                    return Property.this.getValue();
                }
            });
            return previousValue;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("SharedModel.Property[");
            buf.append("modelid=" + this.getModel().getID());
            buf.append(";name=" + this.getName());
            buf.append(";value=" + this.getValue());
            return buf.toString();
        }
    }
}

