/****************************************************************************
 * Copyright (c) 2004 Composent, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * Contributors: Composent, Inc. - initial API and implementation
 *
 * SPDX-License-Identifier: EPL-2.0
 *****************************************************************************/
package org.eclipse.ecf.filetransfer.events;

import org.eclipse.ecf.filetransfer.IOutgoingFileTransfer;

/**
 * Super interface for outgoing file transfer events
 * 
 */
public interface IOutgoingFileTransferEvent extends IFileTransferEvent {
	/**
	 * Get {@link IOutgoingFileTransfer} source associated with this event
	 * 
	 * @return IOutgoingFileTransfer that is source of this event. Will not be
	 *         <code>null</code>.
	 */
	public IOutgoingFileTransfer getSource();
}
