/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.msn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.user.IUser;
import org.eclipse.ecf.internal.provider.msn.MSNID;
import org.eclipse.ecf.internal.provider.msn.Messages;
import org.eclipse.ecf.presence.IPresence;
import org.eclipse.ecf.presence.roster.IRoster;
import org.eclipse.ecf.presence.roster.IRosterEntry;
import org.eclipse.ecf.presence.roster.IRosterItem;
import org.eclipse.ecf.protocol.msn.Contact;
import org.eclipse.ecf.protocol.msn.Status;

final class MSNRosterEntry
implements IPresence,
IRosterEntry,
IUser {
    private static final long serialVersionUID = 5358415024505371809L;
    private Collection groups;
    private IRosterItem parent;
    private final Contact contact;
    private MSNID id;
    private IRoster roster;
    private Map properties;

    MSNRosterEntry(IRoster roster, Contact contact, Namespace namespace) {
        this.roster = roster;
        this.contact = contact;
        this.groups = Collections.EMPTY_LIST;
        this.properties = new HashMap(1);
        try {
            this.id = (MSNID)namespace.createInstance(new Object[]{contact.getEmail()});
        }
        catch (IDCreateException iDCreateException) {
            // empty catch block
        }
    }

    void updatePersonalMessage() {
        String message = this.contact.getPersonalMessage();
        if (message.equals("")) {
            this.properties.remove(Messages.MSNRosterEntry_Message);
        } else {
            this.properties.put(Messages.MSNRosterEntry_Message, message);
        }
    }

    Contact getContact() {
        return this.contact;
    }

    public String getName() {
        return this.contact.getDisplayName();
    }

    public IPresence.Mode getMode() {
        Status status = this.contact.getStatus();
        if (status == Status.ONLINE) {
            return IPresence.Mode.AVAILABLE;
        }
        if (status == Status.BUSY) {
            return IPresence.Mode.DND;
        }
        if (status == Status.APPEAR_OFFLINE) {
            return IPresence.Mode.INVISIBLE;
        }
        return IPresence.Mode.AWAY;
    }

    public Map getProperties() {
        return this.properties;
    }

    public String getStatus() {
        return this.contact.getPersonalMessage();
    }

    public IPresence.Type getType() {
        return this.contact.getStatus() == Status.OFFLINE ? IPresence.Type.UNAVAILABLE : IPresence.Type.AVAILABLE;
    }

    public Object getAdapter(Class adapter) {
        if (adapter != null && adapter.isInstance(this)) {
            return this;
        }
        return null;
    }

    public Collection getGroups() {
        return this.groups;
    }

    public IPresence getPresence() {
        return this;
    }

    public IUser getUser() {
        return this;
    }

    void setParent(IRosterItem parent) {
        this.parent = parent;
        if (parent instanceof IRoster) {
            this.groups = Collections.EMPTY_LIST;
        } else {
            ArrayList<IRosterItem> list = new ArrayList<IRosterItem>(1);
            list.add(parent);
            this.groups = Collections.unmodifiableCollection(list);
        }
    }

    public IRosterItem getParent() {
        return this.parent;
    }

    public byte[] getPictureData() {
        return new byte[0];
    }

    public ID getID() {
        return this.id;
    }

    public String getNickname() {
        return this.contact.getDisplayName();
    }

    public IRoster getRoster() {
        return this.roster;
    }
}

