/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.tests.serialization.load;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;
import org.eclipse.rmf.tests.serialization.model.nodes.Node;
import org.eclipse.rmf.tests.serialization.model.nodes.NodesPackage;
import org.eclipse.rmf.tests.serialization.model.nodes.SubNode;
import org.eclipse.rmf.tests.serialization.util.AbstractTestCase;
import org.eclipse.sphinx.emf.serialization.XMLPersistenceMappingResourceFactoryImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BasicLoadTests
extends AbstractTestCase {
    static final String INPUT_PATH = "org.eclipse.rmf.tests.serialization.load/";

    @Before
    public void setUp() throws Exception {
        super.setUp();
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/rmf/serialization/model/nodes.ecore", (Object)NodesPackage.eINSTANCE);
    }

    @Test
    public void testEAtribute_Atribute0100Many() {
        String inputFileName = "org.eclipse.rmf.tests.serialization.load/EAttribute_Attribute0100Many.xml";
        try {
            EObject modelRoot = this.loadInputFile(inputFileName, (ResourceFactoryImpl)new XMLPersistenceMappingResourceFactoryImpl(), null);
            this.validateEAttributeMany(modelRoot, (EStructuralFeature)NodesPackage.eINSTANCE.getNode_EAttribute_Attribute0100Many());
        }
        catch (Exception ex) {
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }

    @Test
    public void testEAtribute_Atribute1000Many() {
        String inputFileName = "org.eclipse.rmf.tests.serialization.load/EAttribute_Attribute1000Many.xml";
        try {
            EObject modelRoot = this.loadInputFile(inputFileName, (ResourceFactoryImpl)new XMLPersistenceMappingResourceFactoryImpl(), null);
            this.validateEAttributeMany(modelRoot, (EStructuralFeature)NodesPackage.eINSTANCE.getNode_EAttribute_Attribute1000Many());
        }
        catch (Exception ex) {
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }

    public void testEAtribute_Atribute0100Single() {
        String inputFileName = "org.eclipse.rmf.tests.serialization.load/EAttribute_Attribute0100Single.xml";
        try {
            EObject modelRoot = this.loadInputFile(inputFileName, (ResourceFactoryImpl)new XMLPersistenceMappingResourceFactoryImpl(), null);
            this.validateEAttributeSingle(modelRoot, (EStructuralFeature)NodesPackage.eINSTANCE.getNode_EAttribute_Attribute0100Single());
        }
        catch (Exception ex) {
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }

    @Test
    public void testEAtribute_Atribute1000Single() {
        String inputFileName = "org.eclipse.rmf.tests.serialization.load/EAttribute_Attribute1000Single.xml";
        try {
            EObject modelRoot = this.loadInputFile(inputFileName, (ResourceFactoryImpl)new XMLPersistenceMappingResourceFactoryImpl(), null);
            this.validateEAttributeSingle(modelRoot, (EStructuralFeature)NodesPackage.eINSTANCE.getNode_EAttribute_Attribute1000Single());
        }
        catch (Exception ex) {
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }

    @Test
    public void testEReference_Contained0001_Many() {
        String inputFileName = "org.eclipse.rmf.tests.serialization.load/EReference_Contained0001Many.xml";
        try {
            EObject modelRoot = this.loadInputFile(inputFileName, (ResourceFactoryImpl)new XMLPersistenceMappingResourceFactoryImpl(), null);
            this.validateModelMulti(modelRoot, (EStructuralFeature)NodesPackage.eINSTANCE.getNode_EReference_Contained0001Many(), (EStructuralFeature)NodesPackage.eINSTANCE.getNode_EReference_Contained0100Many());
        }
        catch (Exception ex) {
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }

    @Test
    public void testEReference_Contained0001_Single() {
        String inputFileName = "org.eclipse.rmf.tests.serialization.load/EReference_Contained0001Single.xml";
        try {
            EObject modelRoot = this.loadInputFile(inputFileName, (ResourceFactoryImpl)new XMLPersistenceMappingResourceFactoryImpl(), null);
            this.validateModelSingle(modelRoot, NodesPackage.eINSTANCE.getNode_EReference_Contained0001Many(), NodesPackage.eINSTANCE.getNode_EReference_Contained0001Many());
        }
        catch (Exception ex) {
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }

    @Test
    public void testEReference_Contained0100_Many() {
        String inputFileName = "org.eclipse.rmf.tests.serialization.load/EReference_Contained0100Many.xml";
        try {
            EObject modelRoot = this.loadInputFile(inputFileName, (ResourceFactoryImpl)new XMLPersistenceMappingResourceFactoryImpl(), null);
            this.validateModelMulti(modelRoot, (EStructuralFeature)NodesPackage.eINSTANCE.getNode_EReference_Contained0100Many(), (EStructuralFeature)NodesPackage.eINSTANCE.getNode_EReference_Contained0100Many());
        }
        catch (Exception ex) {
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }

    @Test
    public void testEReference_Contained0100_Single() {
        String inputFileName = "org.eclipse.rmf.tests.serialization.load/EReference_Contained0100Single.xml";
        try {
            EObject modelRoot = this.loadInputFile(inputFileName, (ResourceFactoryImpl)new XMLPersistenceMappingResourceFactoryImpl(), null);
            this.validateModelSingle(modelRoot, NodesPackage.eINSTANCE.getNode_EReference_Contained0100Single(), NodesPackage.eINSTANCE.getNode_EReference_Contained0100Single());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }

    @Test
    public void testEReference_Contained0101_Many() {
        String inputFileName = "org.eclipse.rmf.tests.serialization.load/EReference_Contained0101Many.xml";
        try {
            EObject modelRoot = this.loadInputFile(inputFileName, (ResourceFactoryImpl)new XMLPersistenceMappingResourceFactoryImpl(), null);
            this.validateModelMulti(modelRoot, (EStructuralFeature)NodesPackage.eINSTANCE.getNode_EReference_Contained0101Many(), (EStructuralFeature)NodesPackage.eINSTANCE.getNode_EReference_Contained0100Many());
        }
        catch (Exception ex) {
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }

    @Test
    public void testEReference_Contained0101_Single() {
        String inputFileName = "org.eclipse.rmf.tests.serialization.load/EReference_Contained0101Single.xml";
        try {
            EObject modelRoot = this.loadInputFile(inputFileName, (ResourceFactoryImpl)new XMLPersistenceMappingResourceFactoryImpl(), null);
            this.validateModelSingle(modelRoot, NodesPackage.eINSTANCE.getNode_EReference_Contained0101Single(), NodesPackage.eINSTANCE.getNode_EReference_Contained0101Single());
        }
        catch (Exception ex) {
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }

    @Test
    public void testEReference_Contained1001_Many() {
        String inputFileName = "org.eclipse.rmf.tests.serialization.load/EReference_Contained1001Many.xml";
        try {
            EObject modelRoot = this.loadInputFile(inputFileName, (ResourceFactoryImpl)new XMLPersistenceMappingResourceFactoryImpl(), null);
            this.validateModelMulti(modelRoot, (EStructuralFeature)NodesPackage.eINSTANCE.getNode_EReference_Contained1001Many(), (EStructuralFeature)NodesPackage.eINSTANCE.getNode_EReference_Contained0100Many());
        }
        catch (Exception ex) {
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }

    @Test
    public void testEReference_Contained1001_Single() {
        String inputFileName = "org.eclipse.rmf.tests.serialization.load/EReference_Contained1001Single.xml";
        try {
            EObject modelRoot = this.loadInputFile(inputFileName, (ResourceFactoryImpl)new XMLPersistenceMappingResourceFactoryImpl(), null);
            this.validateModelSingle(modelRoot, NodesPackage.eINSTANCE.getNode_EReference_Contained1001Single(), NodesPackage.eINSTANCE.getNode_EReference_Contained1001Single());
        }
        catch (Exception ex) {
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }

    @Test
    public void testEReference_Referenced0100_Many() {
        String inputFileName = "org.eclipse.rmf.tests.serialization.load/EReference_Referenced0100Many.xml";
        try {
            EObject modelRoot = this.loadInputFile(inputFileName, (ResourceFactoryImpl)new XMLPersistenceMappingResourceFactoryImpl(), null);
            this.validateReferencedMany(modelRoot, NodesPackage.eINSTANCE.getNode_EReference_Referenced0100Many());
        }
        catch (Exception ex) {
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }

    @Test
    public void testEReference_Referenced0100_Single() {
        String inputFileName = "org.eclipse.rmf.tests.serialization.load/EReference_Referenced0100Single.xml";
        try {
            EObject modelRoot = this.loadInputFile(inputFileName, (ResourceFactoryImpl)new XMLPersistenceMappingResourceFactoryImpl(), null);
            this.validateReferencedSingle(modelRoot, NodesPackage.eINSTANCE.getNode_EReference_Referenced0100Single());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }

    @Test
    public void testEReference_Referenced0101_Many() {
        String inputFileName = "org.eclipse.rmf.tests.serialization.load/EReference_Referenced0101Many.xml";
        try {
            EObject modelRoot = this.loadInputFile(inputFileName, (ResourceFactoryImpl)new XMLPersistenceMappingResourceFactoryImpl(), null);
            this.validateReferencedMany(modelRoot, NodesPackage.eINSTANCE.getNode_EReference_Referenced0101Many());
        }
        catch (Exception ex) {
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }

    @Test
    public void testEReference_Referenced0101_Single() {
        String inputFileName = "org.eclipse.rmf.tests.serialization.load/EReference_Referenced0101Single.xml";
        try {
            EObject modelRoot = this.loadInputFile(inputFileName, (ResourceFactoryImpl)new XMLPersistenceMappingResourceFactoryImpl(), null);
            this.validateReferencedSingle(modelRoot, NodesPackage.eINSTANCE.getNode_EReference_Referenced0101Single());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }

    @Test
    public void testEReference_Referenced1001_Many() {
        String inputFileName = "org.eclipse.rmf.tests.serialization.load/EReference_Referenced1001Many.xml";
        try {
            EObject modelRoot = this.loadInputFile(inputFileName, (ResourceFactoryImpl)new XMLPersistenceMappingResourceFactoryImpl(), null);
            this.validateReferencedMany(modelRoot, NodesPackage.eINSTANCE.getNode_EReference_Referenced1001Many());
        }
        catch (Exception ex) {
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }

    @Test
    public void testEReference_Referenced1001_Many_Empty() {
        String inputFileName = "org.eclipse.rmf.tests.serialization.load/EReference_Referenced1001Many_Empty.xml";
        try {
            EObject modelRoot = this.loadInputFile(inputFileName, (ResourceFactoryImpl)new XMLPersistenceMappingResourceFactoryImpl(), null);
            this.validateReferencedMany_Empty(modelRoot, NodesPackage.eINSTANCE.getNode_EReference_Referenced1001Many());
        }
        catch (Exception ex) {
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }

    @Test
    public void testEReference_Referenced1001_Single() {
        String inputFileName = "org.eclipse.rmf.tests.serialization.load/EReference_Referenced1001Single.xml";
        try {
            EObject modelRoot = this.loadInputFile(inputFileName, (ResourceFactoryImpl)new XMLPersistenceMappingResourceFactoryImpl(), null);
            this.validateReferencedSingle(modelRoot, NodesPackage.eINSTANCE.getNode_EReference_Referenced1001Single());
        }
        catch (Exception ex) {
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }

    protected void validateModelMulti(EObject modelRoot, EStructuralFeature topFeature, EStructuralFeature subFeature) {
        assert (topFeature.isMany());
        Assert.assertNotNull((Object)modelRoot);
        Assert.assertSame((Object)NodesPackage.eINSTANCE.getNode(), (Object)modelRoot.eClass());
        Node node = (Node)modelRoot;
        EList intermediateNodes = (EList)node.eGet(topFeature);
        Assert.assertSame((Object)4, (Object)intermediateNodes.size());
        Object intermediateNodeObject1 = intermediateNodes.get(0);
        Assert.assertTrue((boolean)(intermediateNodeObject1 instanceof Node));
        Node intermediateNode1 = (Node)intermediateNodeObject1;
        Assert.assertEquals((Object)"intermediateNode1", (Object)intermediateNode1.getName());
        Object intermediateNodeObject2 = intermediateNodes.get(1);
        Assert.assertTrue((boolean)(intermediateNodeObject2 instanceof Node));
        Node intermediateNode2 = (Node)intermediateNodeObject2;
        Assert.assertEquals((Object)"intermediateNode2", (Object)intermediateNode2.getName());
        Object intermediateSubNodeObject3 = intermediateNodes.get(2);
        Assert.assertTrue((boolean)(intermediateSubNodeObject3 instanceof SubNode));
        Node intermediateSubNode3 = (Node)intermediateSubNodeObject3;
        Assert.assertEquals((Object)"intermediateSubNode3", (Object)intermediateSubNode3.getName());
        Object intermediateSubNodeObject4 = intermediateNodes.get(3);
        Assert.assertTrue((boolean)(intermediateSubNodeObject4 instanceof SubNode));
        Node intermediateSubNode4 = (Node)intermediateSubNodeObject4;
        Assert.assertEquals((Object)"intermediateSubNode4", (Object)intermediateSubNode4.getName());
        EList leafNodes1 = (EList)intermediateNode1.eGet(subFeature);
        Assert.assertSame((Object)2, (Object)leafNodes1.size());
        Object leafNodeObject11 = leafNodes1.get(0);
        Assert.assertTrue((boolean)(leafNodeObject11 instanceof Node));
        Node leafNode11 = (Node)leafNodeObject11;
        Assert.assertEquals((Object)"leafNode11", (Object)leafNode11.getName());
        EList leafNodes11 = (EList)leafNode11.eGet(subFeature);
        Assert.assertSame((Object)0, (Object)leafNodes11.size());
        Object leafNodeObject12 = leafNodes1.get(1);
        Assert.assertTrue((boolean)(leafNodeObject12 instanceof Node));
        Node leafNode12 = (Node)leafNodeObject12;
        Assert.assertEquals((Object)"leafNode12", (Object)leafNode12.getName());
        EList leafNodes12 = (EList)leafNode12.eGet(subFeature);
        Assert.assertSame((Object)0, (Object)leafNodes12.size());
        EList leafNodes2 = (EList)intermediateNode2.eGet(subFeature);
        Assert.assertSame((Object)2, (Object)leafNodes2.size());
        Object leafNodeObject21 = leafNodes2.get(0);
        Assert.assertTrue((boolean)(leafNodeObject21 instanceof Node));
        Node leafNode21 = (Node)leafNodeObject21;
        Assert.assertEquals((Object)"leafNode21", (Object)leafNode21.getName());
        EList leafNodes21 = (EList)leafNode21.eGet(subFeature);
        Assert.assertSame((Object)0, (Object)leafNodes21.size());
        Object leafNodeObject22 = leafNodes2.get(1);
        Assert.assertTrue((boolean)(leafNodeObject22 instanceof Node));
        Node leafNode22 = (Node)leafNodeObject22;
        Assert.assertEquals((Object)"leafNode22", (Object)leafNode22.getName());
        EList leafNodes22 = (EList)leafNode22.eGet(subFeature);
        Assert.assertSame((Object)0, (Object)leafNodes22.size());
        EList leafNodes3 = (EList)intermediateSubNode3.eGet(subFeature);
        Assert.assertSame((Object)2, (Object)leafNodes3.size());
        Object leafNodeObject31 = leafNodes3.get(0);
        Assert.assertTrue((boolean)(leafNodeObject31 instanceof Node));
        Node leafNode31 = (Node)leafNodeObject31;
        Assert.assertEquals((Object)"leafNode31", (Object)leafNode31.getName());
        EList leafNodes31 = (EList)leafNode31.eGet(subFeature);
        Assert.assertSame((Object)0, (Object)leafNodes31.size());
        Object leafNodeObject32 = leafNodes3.get(1);
        Assert.assertTrue((boolean)(leafNodeObject32 instanceof Node));
        Node leafNode32 = (Node)leafNodeObject32;
        Assert.assertEquals((Object)"leafNode32", (Object)leafNode32.getName());
        EList leafNodes32 = (EList)leafNode32.eGet(subFeature);
        Assert.assertSame((Object)0, (Object)leafNodes32.size());
        EList leafNodes4 = (EList)intermediateSubNode4.eGet(subFeature);
        Assert.assertSame((Object)2, (Object)leafNodes4.size());
        Object leafNodeObject41 = leafNodes4.get(0);
        Assert.assertTrue((boolean)(leafNodeObject41 instanceof Node));
        Node leafNode41 = (Node)leafNodeObject41;
        Assert.assertEquals((Object)"leafNode41", (Object)leafNode41.getName());
        EList leafNodes41 = (EList)leafNode41.eGet(subFeature);
        Assert.assertSame((Object)0, (Object)leafNodes41.size());
        Object leafNodeObject42 = leafNodes4.get(1);
        Assert.assertTrue((boolean)(leafNodeObject42 instanceof Node));
        Node leafNode42 = (Node)leafNodeObject42;
        Assert.assertEquals((Object)"leafNode42", (Object)leafNode42.getName());
        EList leafNodes42 = (EList)leafNode42.eGet(subFeature);
        Assert.assertSame((Object)0, (Object)leafNodes42.size());
    }

    protected void validateModelSingle(EObject modelRoot, EReference topFeature, EReference subFeature) {
        Object leafNodeObject1;
        Object intermediateNodeObject1;
        Assert.assertNotNull((Object)modelRoot);
        Assert.assertSame((Object)NodesPackage.eINSTANCE.getNode(), (Object)modelRoot.eClass());
        Node node = (Node)modelRoot;
        if (topFeature.isMany()) {
            EList intermediateNodeObjects = (EList)node.eGet((EStructuralFeature)topFeature);
            Assert.assertSame((Object)1, (Object)intermediateNodeObjects.size());
            intermediateNodeObject1 = intermediateNodeObjects.get(0);
        } else {
            intermediateNodeObject1 = node.eGet((EStructuralFeature)topFeature);
        }
        Assert.assertNotNull((Object)intermediateNodeObject1);
        Assert.assertTrue((boolean)(intermediateNodeObject1 instanceof Node));
        Node intermediateNode1 = (Node)intermediateNodeObject1;
        Assert.assertEquals((Object)"intermediateNode1", (Object)intermediateNode1.getName());
        if (topFeature.isMany()) {
            EList leafNodeObjects = (EList)intermediateNode1.eGet((EStructuralFeature)subFeature);
            Assert.assertSame((Object)1, (Object)leafNodeObjects.size());
            leafNodeObject1 = leafNodeObjects.get(0);
        } else {
            leafNodeObject1 = intermediateNode1.eGet((EStructuralFeature)subFeature);
        }
        Assert.assertNotNull((Object)leafNodeObject1);
        Assert.assertTrue((boolean)(leafNodeObject1 instanceof Node));
        Node leafNode11 = (Node)leafNodeObject1;
        Assert.assertEquals((Object)"leafNode1", (Object)leafNode11.getName());
    }

    protected void validateEAttributeMany(EObject modelRoot, EStructuralFeature feature) {
        Assert.assertNotNull((Object)modelRoot);
        Assert.assertSame((Object)NodesPackage.eINSTANCE.getNode(), (Object)modelRoot.eClass());
        Node node = (Node)modelRoot;
        EList valueObjects = (EList)node.eGet(feature);
        Assert.assertSame((Object)2, (Object)valueObjects.size());
        Assert.assertEquals((Object)"value1", (Object)valueObjects.get(0));
        Assert.assertEquals((Object)"value2", (Object)valueObjects.get(1));
    }

    protected void validateEAttributeSingle(EObject modelRoot, EStructuralFeature feature) {
        Assert.assertNotNull((Object)modelRoot);
        Assert.assertSame((Object)NodesPackage.eINSTANCE.getNode(), (Object)modelRoot.eClass());
        Node node = (Node)modelRoot;
        Object valueObject = node.eGet(feature);
        Assert.assertNotNull((Object)valueObject);
        Assert.assertEquals((Object)"value1", (Object)valueObject);
    }

    protected void validateReferencedMany(EObject modelRoot, EReference feature) {
        Assert.assertNotNull((Object)modelRoot);
        Assert.assertSame((Object)NodesPackage.eINSTANCE.getNode(), (Object)modelRoot.eClass());
        Node node = (Node)modelRoot;
        EList<Node> childNodes = node.getEReference_Contained0100Many();
        Assert.assertSame((Object)2, (Object)childNodes.size());
        Node childNode1 = (Node)childNodes.get(0);
        Node childNode2 = (Node)childNodes.get(1);
        EList values = (EList)node.eGet((EStructuralFeature)feature);
        Assert.assertSame((Object)2, (Object)values.size());
        Assert.assertSame((Object)childNode1, (Object)values.get(0));
        Assert.assertSame((Object)childNode2, (Object)values.get(1));
    }

    protected void validateReferencedMany_Empty(EObject modelRoot, EReference feature) {
        Assert.assertNotNull((Object)modelRoot);
        Assert.assertSame((Object)NodesPackage.eINSTANCE.getNode(), (Object)modelRoot.eClass());
        Node node = (Node)modelRoot;
        EList<Node> childNodes = node.getEReference_Contained0100Many();
        Assert.assertSame((Object)2, (Object)childNodes.size());
        EList values = (EList)node.eGet((EStructuralFeature)feature);
        Assert.assertSame((Object)0, (Object)values.size());
        Assert.assertTrue((boolean)node.eIsSet((EStructuralFeature)feature));
    }

    protected void validateReferencedSingle(EObject modelRoot, EReference feature) {
        Assert.assertNotNull((Object)modelRoot);
        Assert.assertSame((Object)NodesPackage.eINSTANCE.getNode(), (Object)modelRoot.eClass());
        Node node = (Node)modelRoot;
        Object valueObject = node.eGet((EStructuralFeature)feature);
        Assert.assertNotNull((Object)valueObject);
        Assert.assertFalse((boolean)((EObject)valueObject).eIsProxy());
        Assert.assertSame((Object)node, (Object)valueObject);
    }
}

