/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.tests.serialization.env.emf;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xml.namespace.XMLNamespacePackage;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.rmf.tests.serialization.env.emf.myreqif.DocumentRoot;
import org.eclipse.rmf.tests.serialization.env.emf.myreqif.MyreqifPackage;
import org.eclipse.rmf.tests.serialization.env.emf.myreqif.util.MyreqifResourceFactoryImpl;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFDeserializationWithSchemaValidationTests {
    public static final String DATA_BASEDIR = "resources/input/org.eclipse.rmf.tests.serialization.env/data/";
    public static final String MODEL_BASEDIR = "resources/model/";

    @Test
    public void testSchemaValidationOnLoadWithValidFile() throws IOException {
        String fileName = "resources/input/org.eclipse.rmf.tests.serialization.env/data/simple.xml";
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/emf/2003/XMLType", (Object)XMLTypePackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)"http://www.w3.org/XML/1998/namespace", (Object)XMLNamespacePackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/rmf/tests/serialization/env/myreqif.xsd", (Object)MyreqifPackage.eINSTANCE);
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xml", new MyreqifResourceFactoryImpl());
        URI emfURI = URI.createURI((String)fileName, (boolean)true);
        Resource resource = resourceSet.createResource(emfURI);
        HashMap<String, Object> options = new HashMap<String, Object>();
        this.enableSchemaValidationAndNewMethods(options);
        try {
            resource.load(options);
        }
        catch (IOException ioe) {
            Assert.assertTrue((String)ioe.getMessage(), (boolean)false);
        }
        Assert.assertEquals((long)0L, (long)resource.getErrors().size());
    }

    @Test
    public void testSchemaValidationOnLoadWithInvalidFile() {
        String fileName = "resources/input/org.eclipse.rmf.tests.serialization.env/data/bare.xml";
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/emf/2003/XMLType", (Object)XMLTypePackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)"http://www.w3.org/XML/1998/namespace", (Object)XMLNamespacePackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/rmf/tests/serialization/env/myreqif.xsd", (Object)MyreqifPackage.eINSTANCE);
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xml", new MyreqifResourceFactoryImpl());
        URI emfURI = URI.createURI((String)fileName, (boolean)true);
        Resource resource = resourceSet.createResource(emfURI);
        HashMap<String, Object> options = new HashMap<String, Object>();
        this.enableSchemaValidationAndNewMethods(options);
        try {
            resource.load(options);
        }
        catch (IOException ioe) {
            Assert.assertTrue((String)ioe.getMessage(), (boolean)ioe.getMessage().contains("cvc-complex-type.2.4.a:"));
        }
        Assert.assertEquals((long)1L, (long)resource.getErrors().size());
        Assert.assertTrue((boolean)(resource.getContents().get(0) instanceof DocumentRoot));
    }

    private void enableSchemaValidationAndNewMethods(Map<String, Object> options) {
        HashMap<String, Boolean> parserFeatures = new HashMap<String, Boolean>();
        HashMap<String, String> parserProperties = new HashMap<String, String>();
        parserFeatures.put("http://xml.org/sax/features/namespaces", true);
        parserFeatures.put("http://xml.org/sax/features/namespace-prefixes", false);
        parserFeatures.put("http://xml.org/sax/features/validation", true);
        parserFeatures.put("http://apache.org/xml/features/validation/schema", true);
        parserProperties.put("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        parserProperties.put("http://apache.org/xml/properties/schema/external-schemaLocation", "http://www.eclipse.org/rmf/tests/serialization/env/myreqif.xsd ../../../model/myreqif.xsd");
        options.put("PARSER_FEATURES", parserFeatures);
        options.put("PARSER_PROPERTIES", parserProperties);
        options.put("USE_DEPRECATED_METHODS", Boolean.FALSE);
    }
}

