/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.pror.editor.agilegrid;

import org.agilemore.agilegrid.AgileGrid;
import org.agilemore.agilegrid.Cell;
import org.agilemore.agilegrid.EditorActivationEvent;
import org.agilemore.agilegrid.editors.TextCellEditor;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.rmf.reqif10.AttributeValue;
import org.eclipse.rmf.reqif10.common.util.ReqIF10Util;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;

public abstract class ProrCellEditor
extends TextCellEditor {
    protected AttributeValue attributeValue;
    protected final EditingDomain editingDomain;
    protected Object affectedObject;
    protected Object parent;

    public ProrCellEditor(AgileGrid agileGrid, EditingDomain editingDomain, Object parent, Object affectedObject) {
        super(agileGrid, 64);
        this.editingDomain = editingDomain;
        this.affectedObject = affectedObject;
        this.parent = parent;
    }

    protected boolean isCorrect(Object value) {
        boolean result = super.isCorrect(value);
        this.setStatusBar(this.getErrorMessage());
        this.setErrorColor(result);
        return result;
    }

    protected void setStatusBar(String message) {
        IWorkbenchPartSite site = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite();
        IStatusLineManager mgr = null;
        if (site instanceof IEditorSite) {
            mgr = ((IEditorSite)site).getActionBars().getStatusLineManager();
        } else if (site instanceof IViewSite) {
            mgr = ((IViewSite)site).getActionBars().getStatusLineManager();
        }
        if (mgr != null) {
            mgr.setErrorMessage(message);
        }
    }

    protected void setErrorColor(boolean isCorrect) {
        int colorCode = isCorrect ? 2 : 3;
        Color color = Display.getDefault().getSystemColor(colorCode);
        this.getControl().setForeground(color);
    }

    protected void doSetValue(Object value) {
        this.attributeValue = null;
        if (value instanceof AttributeValue) {
            this.attributeValue = (AttributeValue)value;
            value = ReqIF10Util.getTheValue((AttributeValue)this.attributeValue);
        }
        super.doSetValue(value);
    }

    protected abstract Object doGetValue();

    public void activate(EditorActivationEvent activationEvent) {
        if (activationEvent.sourceEvent instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent)activationEvent.sourceEvent;
            if (this.isValidCellEditorCharacter(keyEvent) && keyEvent.character != '\u007f') {
                this.text.setText("" + keyEvent.character);
                super.activate(activationEvent);
                this.text.setSelection(1, 1);
                return;
            }
            if (keyEvent.character != '\u007f') {
                super.activate(activationEvent);
            }
        } else {
            super.activate(activationEvent);
        }
    }

    protected boolean isValidCellEditorCharacter(KeyEvent keyEvent) {
        switch (keyEvent.character) {
            case '\b': 
            case '\r': 
            case ' ': 
            case '\u007f': {
                return false;
            }
        }
        return (Character.isLetterOrDigit(keyEvent.character) || keyEvent.keyCode > 32 && keyEvent.keyCode < 254 && keyEvent.keyCode != 127) && keyEvent.keyCode != 262144 && keyEvent.keyCode != 65536 && (keyEvent.stateMask & 0x40000) == 0 && (keyEvent.stateMask & 0x10000) == 0;
    }

    protected void onTraverse(TraverseEvent traverseEvent) {
        Cell cellBefore = this.agileGrid.getFocusCell();
        super.onTraverse(traverseEvent);
        Cell cellAfter = this.agileGrid.getFocusCell();
        if (!(traverseEvent.keyCode != 0x1000001 && traverseEvent.keyCode != 0x1000002 || cellBefore.equals((Object)cellAfter))) {
            if (traverseEvent.keyCode == 0x1000002 && cellAfter.row == 0) {
                return;
            }
            if (cellAfter != null && cellAfter.row >= 0) {
                this.agileGrid.focusCell(cellAfter);
                this.agileGrid.triggerEditorActivationEvent(new EditorActivationEvent(cellAfter, null, traverseEvent), null);
                this.agileGrid.focusCell(cellAfter);
                this.agileGrid.triggerEditorActivationEvent(new EditorActivationEvent(cellAfter, null, traverseEvent), null);
            }
        }
    }
}

