/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.csv.importer.ui.wizards.pages;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.action.CopyAction;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.emf.edit.ui.action.CutAction;
import org.eclipse.emf.edit.ui.action.DeleteAction;
import org.eclipse.emf.edit.ui.action.PasteAction;
import org.eclipse.emf.edit.ui.action.RedoAction;
import org.eclipse.emf.edit.ui.action.StaticSelectionCommandAction;
import org.eclipse.emf.edit.ui.action.UndoAction;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.rmf.reqif10.csv.importer.CSVImporterPlugin;
import org.eclipse.rmf.reqif10.csv.importer.mapping.provider.MappingItemProviderAdapterFactory;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class LeftMappingPart
extends Composite {
    private TreeViewer treeViewer;
    private Resource resource;
    private ComposedAdapterFactory adapterFactory;
    private EditingDomain editingDomain;
    private EObject input;

    public LeftMappingPart(Composite parent, EObject input) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        this.input = input;
        this.createControls();
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    private void createControls() {
        this.createAdapterFactory();
        this.createEditingDomain();
        this.resource = this.editingDomain.getResourceSet().createResource(URI.createURI((String)"TEMP"));
        this.resource.getContents().add((Object)this.input);
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createTreeViewer(composite);
        this.treeViewer.setInput((Object)this.resource);
        this.treeViewer.expandAll();
        new TreeViewerActionProvider(this.treeViewer);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.treeViewer.addSelectionChangedListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.treeViewer.removeSelectionChangedListener(listener);
    }

    private void createAdapterFactory() {
        this.adapterFactory = new ComposedAdapterFactory();
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new MappingItemProviderAdapterFactory());
    }

    private void createEditingDomain() {
        BasicCommandStack commandStack = new BasicCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                LeftMappingPart.this.handleCommandStackChanged(((CommandStack)event.getSource()).getMostRecentCommand());
            }
        });
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)commandStack);
    }

    protected void handleCommandStackChanged(Command mostRecentCommand) {
        if (mostRecentCommand != null) {
            this.setSelectionToViewer(mostRecentCommand.getAffectedObjects());
        }
    }

    protected void setSelectionToViewer(Collection<?> selections) {
        if (selections != null && !selections.isEmpty()) {
            final Object[] selectionsArray = selections.toArray();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (LeftMappingPart.this.treeViewer != null) {
                        LeftMappingPart.this.treeViewer.setSelection((ISelection)new StructuredSelection(selectionsArray), true);
                    }
                }
            };
            if (!this.isDisposed()) {
                this.getDisplay().asyncExec(runnable);
            }
        }
    }

    private void createTreeViewer(Composite parent) {
        this.treeViewer = new TreeViewer(parent);
        this.treeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory));
        this.treeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
    }

    protected static String getString(String key) {
        return CSVImporterPlugin.INSTANCE.getString(key);
    }

    public void dispose() {
        try {
            this.resource.delete(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.adapterFactory.dispose();
    }

    protected void populateManager(IContributionManager manager, Collection<? extends IAction> actions, String contributionID) {
        if (actions != null) {
            for (IAction iAction : actions) {
                if (contributionID != null) {
                    manager.insertBefore(contributionID, iAction);
                    continue;
                }
                manager.add(iAction);
            }
        }
    }

    public void setColumnMappingInput(List<String> columnMappingInput) {
    }

    protected class TreeViewerActionProvider
    implements IMenuListener {
        protected Collection<StaticSelectionCommandAction> createChildActions;
        private DeleteAction deleteAction;
        private UndoAction undoAction;
        private RedoAction redoAction;
        private CutAction cutAction;
        private CopyAction copyAction;
        private PasteAction pasteAction;
        private final TreeViewer viewer;
        private final ISelectionChangedListener selectionChangedListener;

        public TreeViewerActionProvider(TreeViewer viewer) {
            this.viewer = viewer;
            this.initializeActions();
            this.selectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    TreeViewerActionProvider.this.selectionChanged((IStructuredSelection)event.getSelection());
                }
            };
            this.viewer.addSelectionChangedListener(this.selectionChangedListener);
            this.viewer.getTree().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    TreeViewerActionProvider.this.viewer.removeSelectionChangedListener(TreeViewerActionProvider.this.selectionChangedListener);
                }
            });
            MenuManager manager = new MenuManager();
            Menu menu = manager.createContextMenu(viewer.getControl());
            manager.addMenuListener((IMenuListener)this);
            manager.setRemoveAllWhenShown(true);
            viewer.getControl().setMenu(menu);
        }

        private void initializeActions() {
            ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
            this.deleteAction = this.createDeleteAction();
            this.deleteAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
            this.undoAction = this.createUndoAction();
            this.undoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO"));
            this.redoAction = this.createRedoAction();
            this.redoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_REDO"));
            this.cutAction = this.createCutAction();
            this.cutAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT"));
            this.copyAction = this.createCopyAction();
            this.copyAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
            this.pasteAction = this.createPasteAction();
            this.pasteAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        }

        protected DeleteAction createDeleteAction() {
            return new DeleteAction(LeftMappingPart.this.editingDomain, true);
        }

        protected UndoAction createUndoAction() {
            return new UndoAction(LeftMappingPart.this.editingDomain);
        }

        protected RedoAction createRedoAction() {
            return new RedoAction(LeftMappingPart.this.editingDomain);
        }

        protected CutAction createCutAction() {
            return new CutAction(LeftMappingPart.this.editingDomain);
        }

        protected CopyAction createCopyAction() {
            return new CopyAction(LeftMappingPart.this.editingDomain);
        }

        protected PasteAction createPasteAction() {
            return new PasteAction(LeftMappingPart.this.editingDomain);
        }

        public void menuAboutToShow(IMenuManager menuManager) {
            MenuManager submenuManager = null;
            submenuManager = new MenuManager("New");
            LeftMappingPart.this.populateManager((IContributionManager)submenuManager, this.createChildActions, null);
            menuManager.add((IContributionItem)submenuManager);
            menuManager.add((IContributionItem)new Separator());
            menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.undoAction));
            menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.redoAction));
            menuManager.add((IContributionItem)new Separator());
            menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.cutAction));
            menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.copyAction));
            menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.pasteAction));
            menuManager.add((IContributionItem)new Separator());
            menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.deleteAction));
        }

        private void selectionChanged(IStructuredSelection selection) {
            this.deleteAction.selectionChanged(selection);
            this.undoAction.update();
            this.redoAction.update();
            this.cutAction.selectionChanged(selection);
            this.copyAction.selectionChanged(selection);
            this.pasteAction.selectionChanged(selection);
            Collection newChildDescriptors = null;
            if (selection.size() == 1) {
                Object object = selection.getFirstElement();
                newChildDescriptors = LeftMappingPart.this.editingDomain.getNewChildDescriptors(object, null);
            }
            this.createChildActions = this.generateCreateChildActions(newChildDescriptors, (ISelection)selection);
        }

        protected Collection<StaticSelectionCommandAction> generateCreateChildActions(Collection<?> descriptors, ISelection selection) {
            ArrayList<StaticSelectionCommandAction> actions = new ArrayList<StaticSelectionCommandAction>();
            if (descriptors != null) {
                for (Object descriptor : descriptors) {
                    actions.add((StaticSelectionCommandAction)this.createCreateChildAction(selection, descriptor));
                }
            }
            return actions;
        }

        protected CreateChildAction createCreateChildAction(ISelection selection, Object descriptor) {
            return new CreateChildAction(LeftMappingPart.this.editingDomain, selection, descriptor);
        }
    }
}

