/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.search.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultListener;

public class UsageSearchResult
implements ISearchResult {
    private final ISearchQuery query;
    private final Map<Resource, Collection<EObject>> searchEntries;
    private final Collection<ISearchResultListener> searchResultListeners = new ArrayList<ISearchResultListener>();

    public UsageSearchResult(ISearchQuery query) {
        this.query = query;
        this.searchEntries = new HashMap<Resource, Collection<EObject>>();
    }

    public void addListener(ISearchResultListener l) {
        this.searchResultListeners.add(l);
    }

    public void removeListener(ISearchResultListener l) {
        this.searchResultListeners.remove(l);
    }

    public String getLabel() {
        StringBuilder builder = new StringBuilder();
        int count = 0;
        for (Resource resource : this.searchEntries.keySet()) {
            builder.append(resource.getURI().lastSegment());
            if (++count > 2) {
                builder.append("..., ");
                break;
            }
            builder.append(", ");
        }
        Collection<Collection<EObject>> entries = this.searchEntries.values();
        int total = 0;
        for (Collection<EObject> entry : entries) {
            total += entry.size();
        }
        builder.append("count: ").append(total).append(". Query: \"").append(this.query.getLabel()).append("\"");
        return builder.toString();
    }

    public String getTooltip() {
        return null;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public ISearchQuery getQuery() {
        return this.query;
    }

    public Map<Resource, Collection<EObject>> getSearchEntries() {
        return this.searchEntries;
    }
}

