/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.search.filter.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.rmf.reqif10.AttributeDefinition;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.reqif10.SpecType;
import org.eclipse.rmf.reqif10.search.filter.AbstractTextFilter;
import org.eclipse.rmf.reqif10.search.filter.DateFilter;
import org.eclipse.rmf.reqif10.search.filter.IFilter;
import org.eclipse.rmf.reqif10.search.filter.ui.FilterControl;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class FilterPanel
extends Composite {
    private ReqIF reqif;
    private ComboViewer attributeCombo;

    public FilterPanel(Composite parent, ReqIF reqif) {
        super(parent, 2048);
        this.reqif = reqif;
        this.setLayout((Layout)new GridLayout(3, false));
        this.createCloseButton(parent);
        this.createAttributeCombo();
    }

    public FilterPanel(Composite parent, ReqIF reqif, IFilter filter) {
        this(parent, reqif);
        Object[] input = (Object[])this.attributeCombo.getInput();
        int attributeIndex = Arrays.asList(input).indexOf(filter.getAttribute());
        if (attributeIndex == -1) {
            return;
        }
        this.attributeCombo.getCombo().select(attributeIndex);
        FilterControl filterControl = FilterControl.createFilterControl(this, filter);
        filterControl.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.layout();
        this.getParent().pack();
    }

    private void createCloseButton(final Composite parent) {
        Label close = new Label((Composite)this, 0x800000);
        close.setText("\u2716");
        close.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        close.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                FilterPanel.this.dispose();
                parent.pack();
            }
        });
    }

    private void createAttributeCombo() {
        this.attributeCombo = new ComboViewer((Composite)this, 2060);
        GridData layoutData = new GridData(16384, 0x1000000, false, false);
        layoutData.widthHint = 180;
        this.attributeCombo.getControl().setLayoutData((Object)layoutData);
        this.attributeCombo.setLabelProvider((IBaseLabelProvider)new AttributeLabelProvider());
        this.attributeCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.attributeCombo.setInput((Object)this.createAttributeInput().toArray());
        this.attributeCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    Object selectedAttr = ((IStructuredSelection)event.getSelection()).getFirstElement();
                    FilterPanel.this.attributeChanged(selectedAttr);
                }
            }
        });
    }

    private List<?> createAttributeInput() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.addAll(Arrays.asList(AbstractTextFilter.InternalAttribute.values()));
        list.addAll(Arrays.asList(DateFilter.InternalAttribute.values()));
        HashMap<String, AttributeDefinition> attributes = new HashMap<String, AttributeDefinition>();
        for (SpecType specType : this.reqif.getCoreContent().getSpecTypes()) {
            for (AttributeDefinition ad : specType.getSpecAttributes()) {
                attributes.put(String.valueOf(specType.getLongName()) + "." + ad.getLongName() + "." + ad.getIdentifier(), ad);
            }
        }
        ArrayList sortedKeys = new ArrayList(attributes.keySet());
        Collections.sort(sortedKeys);
        for (String key : sortedKeys) {
            list.add(attributes.get(key));
        }
        return list;
    }

    protected void attributeChanged(Object attribute) {
        FilterControl filterControl;
        if (this.getFilterControl() != null) {
            this.getFilterControl().dispose();
        }
        if (attribute instanceof AbstractTextFilter.InternalAttribute) {
            filterControl = FilterControl.createFilterControl(this, (AbstractTextFilter.InternalAttribute)attribute);
        } else if (attribute instanceof DateFilter.InternalAttribute) {
            filterControl = FilterControl.createFilterControl(this, (DateFilter.InternalAttribute)attribute);
        } else if (attribute instanceof AttributeDefinition) {
            filterControl = FilterControl.createFilterControl(this, (AttributeDefinition)attribute);
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)"Invalid Selection", (String)("Cannot handle (yet): " + attribute));
            filterControl = null;
        }
        filterControl.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.layout();
        this.getParent().pack();
    }

    private FilterControl getFilterControl() {
        if (this.getChildren().length != 3) {
            return null;
        }
        Control control = this.getChildren()[2];
        if (!(control instanceof FilterControl)) {
            return null;
        }
        return (FilterControl)control;
    }

    public IFilter getFilter() {
        return this.getFilterControl() == null ? null : this.getFilterControl().getFilter();
    }

    class AttributeLabelProvider
    extends LabelProvider {
        AttributeLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof AttributeDefinition) {
                AttributeDefinition ad = (AttributeDefinition)element;
                SpecType specType = (SpecType)ad.eContainer();
                return String.valueOf(ad.getLongName()) + " (" + specType.getLongName() + ")";
            }
            return element.toString();
        }
    }
}

