/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.pror.util;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.reqif10.ReqIF10Factory;
import org.eclipse.rmf.reqif10.SpecHierarchy;
import org.eclipse.rmf.reqif10.SpecObject;
import org.eclipse.rmf.reqif10.Specification;
import org.eclipse.rmf.reqif10.pror.testframework.AbstractItemProviderTest;
import org.junit.Assert;
import org.junit.Test;

public class ReadAndWriteReqIF
extends AbstractItemProviderTest {
    @Test
    public void testReadWriteRead() throws URISyntaxException, IOException {
        ReqIF reqif = this.getTestReqif("simple.reqif");
        SpecHierarchy specHierarchy = ReqIF10Factory.eINSTANCE.createSpecHierarchy();
        specHierarchy.setObject((SpecObject)reqif.getCoreContent().getSpecObjects().get(0));
        ((Specification)reqif.getCoreContent().getSpecifications().get(0)).getChildren().add((Object)specHierarchy);
        URI uri = URI.createFileURI((String)File.createTempFile("testReadWriteRead-", ".reqif").getAbsolutePath());
        System.out.println("Test file: " + uri);
        Resource resource = (Resource)this.editingDomain.getResourceSet().getResources().get(0);
        resource.setURI(uri);
        resource.save(new HashMap());
        this.setupAbstractItemProviderTest();
        resource = this.editingDomain.getResourceSet().getResource(uri, true);
        reqif = (ReqIF)resource.getContents().get(0);
        Assert.assertEquals((long)2L, (long)((Specification)reqif.getCoreContent().getSpecifications().get(0)).getChildren().size());
    }

    @Test
    public void testAddElementReferencedTo() throws Exception {
        ReqIF reqif = this.getTestReqif("simple.reqif");
        SpecObject specObject = ReqIF10Factory.eINSTANCE.createSpecObject();
        specObject.setDesc("Some content");
        reqif.getCoreContent().getSpecObjects().add((Object)specObject);
        SpecHierarchy specHierarchy = ReqIF10Factory.eINSTANCE.createSpecHierarchy();
        specHierarchy.setObject(specObject);
        ((Specification)reqif.getCoreContent().getSpecifications().get(0)).getChildren().add((Object)specHierarchy);
        URI uri = URI.createFileURI((String)File.createTempFile("testAddElementReferencedTo-", ".reqif").getAbsolutePath());
        System.out.println("Test file: " + uri);
        Resource resource = (Resource)this.editingDomain.getResourceSet().getResources().get(0);
        resource.setURI(uri);
        resource.save(new HashMap());
        this.setupAbstractItemProviderTest();
        resource = this.editingDomain.getResourceSet().getResource(uri, true);
        reqif = (ReqIF)resource.getContents().get(0);
        SpecHierarchy sh = (SpecHierarchy)((Specification)reqif.getCoreContent().getSpecifications().get(0)).getChildren().get(1);
        SpecObject so = (SpecObject)reqif.getCoreContent().getSpecObjects().get(1);
        Assert.assertEquals((Object)so, (Object)sh.getObject());
    }
}

