/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.csv.importer.ui.wizards;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.rmf.reqif10.csv.importer.CSVImporterPlugin;
import org.eclipse.rmf.reqif10.csv.importer.mapping.MappingLibrary;
import org.eclipse.rmf.reqif10.csv.importer.ui.wizards.pages.CSVImportWizardPage;
import org.eclipse.rmf.reqif10.csv.importer.ui.wizards.pages.CSVMappingWizardPage;
import org.eclipse.rmf.reqif10.csv.importer.utils.Importer;
import org.eclipse.rmf.reqif10.csv.importer.utils.Utils;
import org.eclipse.rmf.reqif10.pror.editor.IReqifEditor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class CSVImportWizard
extends Wizard
implements IImportWizard {
    private CSVImportWizardPage importWizardPage;
    private CSVMappingWizardPage mappingWizardPage;

    public CSVImportWizard() {
        this.setWindowTitle("CSV Import Wizard");
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.importWizardPage = new CSVImportWizardPage();
        this.mappingWizardPage = new CSVMappingWizardPage();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.importWizardPage) {
            IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        final List<String> columnIDS = Utils.getColumnIds(CSVImportWizard.this.importWizardPage.getSelectedFilePath(), CSVImportWizard.this.importWizardPage.getSeparator(), CSVImportWizard.this.importWizardPage.isContainsHeader());
                        CSVImportWizard.this.getShell().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                CSVImportWizard.this.mappingWizardPage.setColumnMappingInput(columnIDS);
                            }
                        });
                    }
                    catch (IOException e) {
                        CSVImporterPlugin.INSTANCE.log(e);
                    }
                }
            };
            this.run(runnableWithProgress);
        }
        return super.getNextPage(page);
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.importWizardPage);
        this.addPage((IWizardPage)this.mappingWizardPage);
    }

    protected void run(IRunnableWithProgress runnableWithProgress) {
        try {
            this.getContainer().run(true, false, runnableWithProgress);
        }
        catch (InvocationTargetException e) {
            CSVImporterPlugin.INSTANCE.log(e);
        }
        catch (InterruptedException e) {
            CSVImporterPlugin.INSTANCE.log(e);
        }
    }

    public static EditingDomain getEditingDomain(URI uri) {
        return CSVImportWizard.getEditorsURIMap().get(uri);
    }

    public static Map<URI, EditingDomain> getEditorsURIMap() {
        IEditorReference[] editorReferences;
        HashMap<URI, EditingDomain> uriMap = new HashMap<URI, EditingDomain>();
        IEditorReference[] iEditorReferenceArray = editorReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int n = editorReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editorReference = iEditorReferenceArray[n2];
            IEditorPart editorPart = editorReference.getEditor(false);
            if (editorPart instanceof IReqifEditor) {
                try {
                    uriMap.put(EditUIUtil.getURI((IEditorInput)editorReference.getEditorInput()), ((IEditingDomainProvider)editorPart).getEditingDomain());
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        return uriMap;
    }

    public boolean performFinish() {
        boolean valid = true;
        IFile selectedDestinationFile = this.importWizardPage.getSelectedDestinationFile();
        String selectedFilePath = this.importWizardPage.getSelectedFilePath();
        MappingLibrary mappingLibrary = this.mappingWizardPage.getMappingLibrary();
        char separator = this.importWizardPage.getSeparator();
        boolean containsHeader = this.importWizardPage.isContainsHeader();
        URI uri = URI.createPlatformResourceURI((String)selectedDestinationFile.getFullPath().toOSString(), (boolean)true);
        EditingDomain editingDomain = CSVImportWizard.getEditingDomain(uri);
        try {
            Importer.importReq(editingDomain, selectedDestinationFile, selectedFilePath, mappingLibrary, separator, containsHeader);
        }
        catch (Exception e) {
            CSVImporterPlugin.getPlugin().log(e);
            valid = false;
            MessageDialog.openError((Shell)this.getShell(), (String)("Import Failed: " + e.getClass().getSimpleName()), (String)("Something went wrong: " + e.getMessage()));
        }
        return valid;
    }
}

