/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.tests.serialization.env.emf;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.URIHandlerImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLSaveImpl;
import org.eclipse.emf.ecore.xml.namespace.XMLNamespacePackage;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.rmf.tests.serialization.env.emf.myreqif.CORECONTENTType;
import org.eclipse.rmf.tests.serialization.env.emf.myreqif.DocumentRoot;
import org.eclipse.rmf.tests.serialization.env.emf.myreqif.MyreqifFactory;
import org.eclipse.rmf.tests.serialization.env.emf.myreqif.MyreqifPackage;
import org.eclipse.rmf.tests.serialization.env.emf.myreqif.REQIF;
import org.eclipse.rmf.tests.serialization.env.emf.myreqif.REQIFCONTENT;
import org.eclipse.rmf.tests.serialization.env.emf.myreqif.util.MyreqifResourceFactoryImpl;
import org.eclipse.rmf.tests.serialization.util.AbstractTestCase;
import org.junit.Assert;
import org.junit.Test;

public class EMFSerializationTests
extends AbstractTestCase {
    public static final String RELATIVE_WORK_DIR = "org.eclipse.rmf.tests.serialization.env.emf/EMFSerializationTests/";

    @Test
    public void testReqIFLangSerialization() throws Exception {
        String fileName = "org.eclipse.rmf.tests.serialization.env.emf/EMFSerializationTests/testReqIFLangSerialization.xml";
        DocumentRoot documentRoot = MyreqifFactory.eINSTANCE.createDocumentRoot();
        REQIF reqif = MyreqifFactory.eINSTANCE.createREQIF();
        CORECONTENTType coreContent = MyreqifFactory.eINSTANCE.createCORECONTENTType();
        REQIFCONTENT reqifContent = MyreqifFactory.eINSTANCE.createREQIFCONTENT();
        documentRoot.setREQIF(reqif);
        reqif.setCORECONTENT(coreContent);
        coreContent.setREQIFCONTENT(reqifContent);
        reqif.setLang("en");
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/emf/2003/XMLType", (Object)XMLTypePackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)"http://www.w3.org/XML/1998/namespace", (Object)XMLNamespacePackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/rmf/tests/serialization/env/myreqif.xsd", (Object)MyreqifPackage.eINSTANCE);
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put("EXTENDED_META_DATA", Boolean.TRUE);
        this.saveWorkingFile(fileName, documentRoot, new MyreqifResourceFactoryImpl(), options);
        String resourceAsString = this.loadWorkingFileAsString(fileName);
        Assert.assertTrue((boolean)resourceAsString.contains("xml:lang=\"en\""));
    }

    @Test
    public void testEcodingSerialization() throws Exception {
        String fileName = "org.eclipse.rmf.tests.serialization.env.emf/EMFSerializationTests/testEcodingSerialization.xml";
        DocumentRoot documentRoot = MyreqifFactory.eINSTANCE.createDocumentRoot();
        REQIF reqif = MyreqifFactory.eINSTANCE.createREQIF();
        CORECONTENTType coreContent = MyreqifFactory.eINSTANCE.createCORECONTENTType();
        REQIFCONTENT reqifContent = MyreqifFactory.eINSTANCE.createREQIFCONTENT();
        documentRoot.setREQIF(reqif);
        reqif.setCORECONTENT(coreContent);
        coreContent.setREQIFCONTENT(reqifContent);
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/emf/2003/XMLType", (Object)XMLTypePackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)"http://www.w3.org/XML/1998/namespace", (Object)XMLNamespacePackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/rmf/tests/serialization/env/myreqif.xsd", (Object)MyreqifPackage.eINSTANCE);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", "UTF-8");
        this.saveWorkingFile(fileName, documentRoot, new MyreqifResourceFactoryImpl(), options);
        String resourceAsString = this.loadWorkingFileAsString(fileName);
        Assert.assertTrue((boolean)resourceAsString.contains("encoding=\"UTF-8\""));
    }

    @Test
    public void testDefaultNamespacePrefixSerialization() throws Exception {
        String fileName = "org.eclipse.rmf.tests.serialization.env.emf/EMFSerializationTests/testDefaultNamespacePrefixSerialization.xml";
        DocumentRoot documentRoot = MyreqifFactory.eINSTANCE.createDocumentRoot();
        REQIF reqif = MyreqifFactory.eINSTANCE.createREQIF();
        CORECONTENTType coreContent = MyreqifFactory.eINSTANCE.createCORECONTENTType();
        REQIFCONTENT reqifContent = MyreqifFactory.eINSTANCE.createREQIFCONTENT();
        documentRoot.setREQIF(reqif);
        reqif.setCORECONTENT(coreContent);
        coreContent.setREQIFCONTENT(reqifContent);
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/emf/2003/XMLType", (Object)XMLTypePackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)"http://www.w3.org/XML/1998/namespace", (Object)XMLNamespacePackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/rmf/tests/serialization/env/myreqif.xsd", (Object)MyreqifPackage.eINSTANCE);
        this.saveWorkingFile(fileName, documentRoot, new MyreqifResourceFactoryImpl(), null);
        String resourceAsString = this.loadWorkingFileAsString(fileName);
        Assert.assertTrue((boolean)resourceAsString.contains("<myreqif:REQ-IF "));
        Assert.assertTrue((boolean)resourceAsString.contains("<myreqif:CORE-CONTENT>"));
        Assert.assertTrue((boolean)resourceAsString.contains("<myreqif:REQ-IF-CONTENT/>"));
    }

    @Test
    public void testCustomNamespacePrefixSerialization() throws Exception {
        String fileName = "org.eclipse.rmf.tests.serialization.env.emf/EMFSerializationTests/testCustomNamespacePrefixSerialization.xml";
        DocumentRoot documentRoot = MyreqifFactory.eINSTANCE.createDocumentRoot();
        documentRoot.getXMLNSPrefixMap().put((Object)"", (Object)"http://www.eclipse.org/rmf/tests/serialization/env/myreqif.xsd");
        REQIF reqif = MyreqifFactory.eINSTANCE.createREQIF();
        CORECONTENTType coreContent = MyreqifFactory.eINSTANCE.createCORECONTENTType();
        REQIFCONTENT reqifContent = MyreqifFactory.eINSTANCE.createREQIFCONTENT();
        documentRoot.setREQIF(reqif);
        reqif.setCORECONTENT(coreContent);
        coreContent.setREQIFCONTENT(reqifContent);
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/emf/2003/XMLType", (Object)XMLTypePackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)"http://www.w3.org/XML/1998/namespace", (Object)XMLNamespacePackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/rmf/tests/serialization/env/myreqif.xsd", (Object)MyreqifPackage.eINSTANCE);
        this.saveWorkingFile(fileName, documentRoot, new MyreqifResourceFactoryImpl(), null);
        String resourceAsString = this.loadWorkingFileAsString(fileName);
        Assert.assertTrue((boolean)resourceAsString.contains("<REQ-IF "));
    }

    @Test
    public void testDefaultNamespacePrefixWithoutDocumentRootSerialization_noMetadata() throws Exception {
        String fileName = "org.eclipse.rmf.tests.serialization.env.emf/EMFSerializationTests/testDefaultNamespacePrefixWithoutDocumentRootSerialization.xml";
        EPackage ePackage = EcoreFactory.eINSTANCE.createEPackage();
        EClass eClass = EcoreFactory.eINSTANCE.createEClass();
        ePackage.getEClassifiers().add((Object)eClass);
        ePackage.setName("the Package");
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/emf/2003/XMLType", (Object)XMLTypePackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)"http://www.w3.org/XML/1998/namespace", (Object)XMLNamespacePackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/rmf/tests/serialization/env/myreqif.xsd", (Object)MyreqifPackage.eINSTANCE);
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put("EXTENDED_META_DATA", Boolean.TRUE);
        this.saveWorkingFile(fileName, (EObject)ePackage, (ResourceFactoryImpl)new EcoreResourceFactoryImpl(), options);
        String resourceAsString = this.loadWorkingFileAsString(fileName);
        Assert.assertTrue((boolean)resourceAsString.contains("<ecore:EPackage "));
        Assert.assertTrue((boolean)resourceAsString.contains("<eClassifiers "));
        Assert.assertTrue((boolean)resourceAsString.contains(" name=\""));
    }

    @Test
    public void testCustomNamespacePrefixWithoutDocumentRootSerialization() throws Exception {
        String fileName = "org.eclipse.rmf.tests.serialization.env.emf/EMFSerializationTests/testCustomNamespacePrefixWithoutDocumentRootSerialization.xml";
        EPackage ePackage = EcoreFactory.eINSTANCE.createEPackage();
        EClass eClass = EcoreFactory.eINSTANCE.createEClass();
        ePackage.getEClassifiers().add((Object)eClass);
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/emf/2003/XMLType", (Object)XMLTypePackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)"http://www.w3.org/XML/1998/namespace", (Object)XMLNamespacePackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/rmf/tests/serialization/env/myreqif.xsd", (Object)MyreqifPackage.eINSTANCE);
        this.saveWorkingFile(fileName, (EObject)ePackage, (ResourceFactoryImpl)new EmptyPrefixResourceFactoryImpl(), null);
        String resourceAsString = this.loadWorkingFileAsString(fileName);
        Assert.assertTrue((boolean)resourceAsString.contains("<EPackage "));
    }

    class EmptyPrefixResourceFactoryImpl
    extends EcoreResourceFactoryImpl {
        EmptyPrefixResourceFactoryImpl() {
        }

        public Resource createResource(URI uri) {
            XMIResourceImpl result = new XMIResourceImpl(uri){

                protected boolean useIDs() {
                    return this.eObjectToIDMap != null || this.idToEObjectMap != null;
                }

                protected XMLSave createXMLSave(Map<?, ?> options) {
                    return new XMLSaveImpl(this.createXMLHelper()){

                        protected void init(XMLResource resource, Map<?, ?> options) {
                            super.init(resource, options);
                            this.helper.getPrefixToNamespaceMap().put((Object)"", (Object)"http://www.eclipse.org/emf/2002/Ecore");
                        }
                    };
                }
            };
            result.setEncoding("UTF-8");
            result.getDefaultSaveOptions().put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
            result.getDefaultSaveOptions().put("LINE_WIDTH", 80);
            result.getDefaultSaveOptions().put("URI_HANDLER", new URIHandlerImpl.PlatformSchemeAware());
            return result;
        }
    }
}

