/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.pror.editor.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.rmf.reqif10.pror.editor.presentation.ProrAdapterFactoryContentProvider;
import org.eclipse.rmf.reqif10.pror.editor.presentation.Reqif10Editor;
import org.eclipse.rmf.reqif10.pror.editor.propertiesview.ProrPropertySheetPage;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;

public class SubtreeDialog
extends TrayDialog
implements IMenuListener {
    private static final int VALIDATE_ID = 99;
    private final EObject input;
    private final String title;
    private final String helpContext;
    private ISelectionProvider originalSelectionProvider;
    private IAction[] actions = new IAction[0];
    private boolean presentAsDropdown;
    private TreeViewer viewer;
    private final List<ViewerFilter> filters = new ArrayList<ViewerFilter>();
    private final AdapterFactory adapterFactory;
    private final EditingDomain editingDomain;
    private final Reqif10Editor reqifEditor;

    protected SubtreeDialog(Reqif10Editor reqifEditor, EObject input, String title, String helpContext) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.reqifEditor = reqifEditor;
        this.editingDomain = reqifEditor.getEditingDomain();
        this.adapterFactory = reqifEditor.getAdapterFactory();
        this.input = input;
        this.title = title;
        this.helpContext = helpContext;
        this.setHelpAvailable(true);
    }

    void addFilter(ViewerFilter filter) {
        this.filters.add(filter);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.FINISH_LABEL, true);
        this.createButton(parent, 99, "Validate", false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 99) {
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            if (selection.getFirstElement() instanceof EObject) {
                EObject element = (EObject)selection.getFirstElement();
                Diagnostic diagnostic = Diagnostician.INSTANCE.validate(element);
                MessageDialog.openInformation((Shell)this.getShell(), (String)"Validation Report", (String)diagnostic.getMessage());
            }
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected Point getInitialSize() {
        return new Point(500, 600);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.title);
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new FormLayout());
        ToolBar toolbar = this.presentAsDropdown ? this.buildDropdownToolbar(composite) : this.buildRowToolbar(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.helpContext);
        final Sash sash = new Sash(composite, 2304);
        FormData data = new FormData();
        data.bottom = new FormAttachment(50, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        sash.setLayoutData((Object)data);
        sash.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                sash.setBounds(e.x, e.y, e.width, e.height);
                ((FormData)sash.getLayoutData()).bottom = new FormAttachment(0, e.y);
                sash.getParent().layout();
            }
        });
        this.viewer = new TreeViewer(composite, 2048);
        this.viewer.setContentProvider((IContentProvider)new ProrAdapterFactoryContentProvider(this.getAdapterFactory()));
        this.viewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.getAdapterFactory()));
        this.viewer.setInput((Object)this.input);
        this.viewer.setFilters(this.filters.toArray(new ViewerFilter[0]));
        this.createContextMenuFor((StructuredViewer)this.viewer);
        this.viewer.getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    ISelection selection = SubtreeDialog.this.viewer.getSelection();
                    TreeSelection treeSelection = (TreeSelection)selection;
                    Object firstElement = treeSelection.getFirstElement();
                    Command create = DeleteCommand.create((EditingDomain)SubtreeDialog.this.editingDomain, (Object)firstElement);
                    SubtreeDialog.this.editingDomain.getCommandStack().execute(create);
                }
            }
        });
        data = new FormData();
        data.top = new FormAttachment((Control)toolbar, 0);
        data.bottom = new FormAttachment((Control)sash, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        this.viewer.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.bottom = new FormAttachment(this.viewer.getControl(), 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        toolbar.setLayoutData((Object)data);
        final ProrPropertySheetPage propertySheet = new ProrPropertySheetPage((EditingDomain)((AdapterFactoryEditingDomain)this.editingDomain), this.adapterFactory);
        propertySheet.createControl(composite);
        data = new FormData();
        data.top = new FormAttachment((Control)sash, 0);
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        propertySheet.getControl().setLayoutData((Object)data);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                propertySheet.selectionChanged(null, event.getSelection());
            }
        });
        this.originalSelectionProvider = this.getActionBarContributor().getActiveEditor().getSite().getSelectionProvider();
        this.getActionBarContributor().getActiveEditor().getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ((ISelectionProvider)SubtreeDialog.this.getActionBarContributor().getActiveEditor()).setSelection(event.getSelection());
            }
        });
        return composite;
    }

    private ToolBar buildDropdownToolbar(Composite composite) {
        final ToolBar toolbar = new ToolBar(composite, 8);
        final Menu menu = new Menu((Decorations)this.getShell(), 8);
        IAction[] iActionArray = this.actions;
        int n = this.actions.length;
        int n2 = 0;
        while (n2 < n) {
            final IAction action = iActionArray[n2];
            MenuItem newItem = new MenuItem(menu, 8);
            newItem.setText(action.getText());
            newItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    action.run();
                }
            });
            ++n2;
        }
        final ToolItem item = new ToolItem(toolbar, 4);
        item.setText("Select Action...");
        item.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Rectangle rect = item.getBounds();
                Point pt = new Point(rect.x, rect.y + rect.height);
                pt = toolbar.toDisplay(pt);
                menu.setLocation(pt.x, pt.y);
                menu.setVisible(true);
            }
        });
        return toolbar;
    }

    private ToolBar buildRowToolbar(Composite composite) {
        ToolBar toolbar = new ToolBar(composite, 8);
        ToolBarManager toolbarManager = new ToolBarManager(toolbar);
        IAction[] iActionArray = this.actions;
        int n = this.actions.length;
        int n2 = 0;
        while (n2 < n) {
            IAction action = iActionArray[n2];
            toolbarManager.add(action);
            ++n2;
        }
        toolbarManager.update(true);
        return toolbar;
    }

    private AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void createContextMenuFor(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        viewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)viewer));
        viewer.addDropSupport(dndOperations, transfers, (DropTargetListener)new EditingDomainViewerDropAdapter(this.editingDomain, (Viewer)viewer));
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        this.getActionBarContributor().menuAboutToShow(menuManager);
    }

    private EditingDomainActionBarContributor getActionBarContributor() {
        return this.reqifEditor.getActionBarContributor();
    }

    public boolean close() {
        this.getActionBarContributor().getActiveEditor().getSite().setSelectionProvider(this.originalSelectionProvider);
        return super.close();
    }

    public void setActions(IAction[] actions, boolean presentAsDropdown) {
        this.actions = actions;
        this.presentAsDropdown = presentAsDropdown;
    }
}

