/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.tests.reqif10.serialization.uc001.tc1700;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.serialization.XMLPersistenceMappingResourceSetImpl;
import org.eclipse.rmf.tests.reqif10.serialization.uc001.tc1700.TC1700SpecRelationMultifile1ModelBuilder;
import org.eclipse.rmf.tests.reqif10.serialization.uc001.tc1700.TC1700SpecRelationMultifile2ModelBuilder;
import org.eclipse.rmf.tests.reqif10.serialization.util.AbstractTestCase;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TC1700SpecRelationMultifileTests
extends AbstractTestCase {
    static final String TEST_CASE_ID = "TC1700";
    static final String REFERENCE_DATA_FILENAME1 = TC1700SpecRelationMultifileTests.getWorkingFileName(TC1700SpecRelationMultifileTests.getReferenceDataFileName("TC17001", false));
    static final String REFERENCE_DATA_FILENAME2 = TC1700SpecRelationMultifileTests.getWorkingFileName(TC1700SpecRelationMultifileTests.getReferenceDataFileName("TC17002", false));
    static final String REFERENCE_DATA_ARCHIVE_FILENAME = TC1700SpecRelationMultifileTests.getWorkingFileName(TC1700SpecRelationMultifileTests.getReferenceDataFileName("TC1700", true));
    static final String EXPORT_DATA_FILENAME1 = TC1700SpecRelationMultifileTests.getWorkingFileName(TC1700SpecRelationMultifileTests.getFirstExportFileName("TC17001", false));
    static final String EXPORT_DATA_FILENAME2 = TC1700SpecRelationMultifileTests.getWorkingFileName(TC1700SpecRelationMultifileTests.getFirstExportFileName("TC17002", false));
    static final String EXPORT_DATA_ARCHIVE_FILENAME = TC1700SpecRelationMultifileTests.getWorkingFileName(TC1700SpecRelationMultifileTests.getFirstExportFileName("TC1700", true));
    static ReqIF originalReqIF1 = null;
    static ReqIF originalReqIF2 = null;
    static List<ReqIF> originalReqIFs = null;
    static ReqIF loadedReqIF1 = null;
    static ReqIF loadedReqIF2 = null;
    static List<ReqIF> loadedReqIFs = null;

    @BeforeClass
    public static void setupOnce() throws Exception {
        AbstractTestCase.setupOnce();
        TC1700SpecRelationMultifile1ModelBuilder modelBuilder = new TC1700SpecRelationMultifile1ModelBuilder();
        originalReqIF1 = modelBuilder.getReqIF();
        originalReqIF2 = new TC1700SpecRelationMultifile2ModelBuilder(modelBuilder).getReqIF();
        originalReqIFs = new ArrayList<ReqIF>();
        originalReqIFs.add(originalReqIF1);
        originalReqIFs.add(originalReqIF2);
        TC1700SpecRelationMultifileTests.saveReqIFsToZip(originalReqIFs, REFERENCE_DATA_ARCHIVE_FILENAME, (ResourceSetImpl)TC1700SpecRelationMultifileTests.getXMLPersistenceMappingResourceSet());
        loadedReqIFs = TC1700SpecRelationMultifileTests.loadReqIFFromZip(REFERENCE_DATA_ARCHIVE_FILENAME, (ResourceSetImpl)TC1700SpecRelationMultifileTests.getXMLPersistenceMappingResourceSet());
        XMLPersistenceMappingResourceSetImpl saveResourceSet = TC1700SpecRelationMultifileTests.getXMLPersistenceMappingResourceSet();
        TC1700SpecRelationMultifileTests.saveReqIFFile((EObject)originalReqIF1, REFERENCE_DATA_FILENAME1, (ResourceSet)saveResourceSet);
        TC1700SpecRelationMultifileTests.saveReqIFFile((EObject)originalReqIF2, REFERENCE_DATA_FILENAME2, (ResourceSet)saveResourceSet);
        XMLPersistenceMappingResourceSetImpl loadResourceSet = TC1700SpecRelationMultifileTests.getXMLPersistenceMappingResourceSet();
        loadedReqIF1 = TC1700SpecRelationMultifileTests.loadReqIFFile(REFERENCE_DATA_FILENAME1, (ResourceSet)loadResourceSet);
        loadedReqIF2 = TC1700SpecRelationMultifileTests.loadReqIFFile(REFERENCE_DATA_FILENAME1, (ResourceSet)loadResourceSet);
    }

    @Test
    public void testSchemaCompliance1() throws Exception {
        this.validateAgainstSchema(REFERENCE_DATA_FILENAME1);
    }

    @Test
    public void testSchemaCompliance2() throws Exception {
        this.validateAgainstSchema(REFERENCE_DATA_FILENAME2);
    }

    @Test
    public void testNoProxies() throws IOException {
        ResourceSet resourceSet = loadedReqIFs.get(0).eResource().getResourceSet();
        EcoreUtil.resolveAll((ResourceSet)resourceSet);
        Map map = EcoreUtil.ProxyCrossReferencer.find(loadedReqIFs);
        Assert.assertEquals((long)0L, (long)map.size());
    }

    @Test
    public void testResave() throws IOException {
        try {
            ArrayList<ReqIF> clonedReqIFs = new ArrayList<ReqIF>();
            for (ReqIF reqIF : loadedReqIFs) {
                clonedReqIFs.add((ReqIF)EcoreUtil.copy((EObject)reqIF));
            }
            TC1700SpecRelationMultifileTests.saveReqIFsToZip(clonedReqIFs, EXPORT_DATA_ARCHIVE_FILENAME, (ResourceSetImpl)TC1700SpecRelationMultifileTests.getXMLPersistenceMappingResourceSet());
        }
        catch (IOException ioe) {
            junit.framework.Assert.assertFalse((String)("We shall be able to save without exception. However the following exception occurred: " + ioe.toString()), (boolean)true);
        }
    }
}

