/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.launching;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.launching.PHPHyperLink;
import org.eclipse.php.internal.debug.core.launching.PHPLaunch;
import org.eclipse.php.internal.debug.core.launching.PHPStreamsProxy;
import org.eclipse.php.internal.debug.core.launching.XDebugLaunch;

public class PHPProcess
extends PlatformObject
implements IProcess {
    private ILaunch fLaunch;
    private String fName;
    private Map<String, String> fAttributes;
    private IConsole fConsole = null;
    private PHPStreamsProxy fProxy;
    private PHPHyperLink fPHPHyperLink;
    private IDebugTarget fDebugTarget;
    private int fExitValue;

    public PHPProcess(ILaunch launch, String name) {
        this.fLaunch = launch;
        this.fName = name;
        this.fProxy = new PHPStreamsProxy();
        this.fireCreationEvent();
    }

    public String getLabel() {
        String suffix = null;
        if (this.fLaunch.getLaunchMode().equals("debug")) {
            if (this.fLaunch instanceof PHPLaunch) {
                suffix = PHPDebugCoreMessages.PHPProcess_Zend_Debugger_suffix;
            } else if (this.fLaunch instanceof XDebugLaunch) {
                suffix = PHPDebugCoreMessages.PHPProcess_XDebug_suffix;
            }
        }
        return suffix != null ? this.fName + " " + suffix : this.fName;
    }

    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    public IStreamsProxy getStreamsProxy() {
        return this.fProxy;
    }

    public void setAttribute(String key, String value) {
        String origVal;
        if (this.fAttributes == null) {
            this.fAttributes = new HashMap<String, String>(5);
        }
        if ((origVal = this.fAttributes.get(key)) != null && origVal.equals(value)) {
            return;
        }
        this.fAttributes.put(key, value);
        this.fireChangeEvent();
    }

    public String getAttribute(String key) {
        if (this.fAttributes == null) {
            return null;
        }
        return this.fAttributes.get(key);
    }

    public int getExitValue() throws DebugException {
        return this.fExitValue;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IProcess.class)) {
            return this;
        }
        if (adapter.equals(IDebugTarget.class)) {
            ILaunch launch = this.getLaunch();
            IDebugTarget[] targets = launch.getDebugTargets();
            int i = 0;
            while (i < targets.length) {
                if (((Object)((Object)this)).equals(targets[i].getProcess())) {
                    return targets[i];
                }
                ++i;
            }
            return null;
        }
        if (adapter.equals(ITerminate.class)) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.fDebugTarget.isTerminated();
    }

    public void terminate() throws DebugException {
        if (this.fDebugTarget.canTerminate()) {
            this.fDebugTarget.terminate();
        }
        this.fireTerminateEvent();
    }

    public void setPHPHyperLink(PHPHyperLink pLink) {
        this.fPHPHyperLink = pLink;
    }

    public PHPHyperLink getPHPHyperLink() {
        return this.fPHPHyperLink;
    }

    public IConsole getConsole() {
        return this.fConsole;
    }

    public void setConsole(IConsole console) {
        this.fConsole = console;
    }

    public IDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }

    public void setDebugTarget(IDebugTarget target) {
        this.fDebugTarget = target;
    }

    public void setExitValue(int exitValue) {
        this.fExitValue = exitValue;
    }

    protected void fireCreationEvent() {
        this.fireEvent(new DebugEvent((Object)this, 4));
    }

    protected void fireTerminateEvent() {
        this.fireEvent(new DebugEvent((Object)this, 8));
    }

    protected void fireChangeEvent() {
        this.fireEvent(new DebugEvent((Object)this, 16));
    }

    protected void fireEvent(DebugEvent event) {
        DebugPlugin manager = DebugPlugin.getDefault();
        if (manager != null) {
            manager.fireDebugEventSet(new DebugEvent[]{event});
        }
    }
}

