/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.utils;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.ocl.examples.debug.vm.messages.VMMessages;
import org.eclipse.ocl.examples.debug.vm.utils.BaseProcess;

public class ShallowProcess
extends BaseProcess {
    private final ILaunch myLaunch;
    private BaseProcess.IRunnable myRunnable;

    public ShallowProcess(ILaunch launch, BaseProcess.IRunnable r) {
        this.myLaunch = launch;
        this.myRunnable = r;
    }

    public void run() throws Exception {
        this.run(null);
    }

    public void run(IDebugTarget debugTarget) throws Exception {
        this.myLaunch.addProcess((IProcess)this);
        try {
            if (debugTarget != null) {
                this.myLaunch.addDebugTarget(debugTarget);
            }
            this.myRunnable.run();
        }
        catch (Throwable throwable) {
            this.myRunnable = null;
            if (DebugPlugin.getDefault() != null) {
                DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)this, 8)});
            }
            throw throwable;
        }
        this.myRunnable = null;
        if (DebugPlugin.getDefault() != null) {
            DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)this, 8)});
        }
    }

    public String getLabel() {
        return VMMessages.ShallowProcess_Label;
    }

    public ILaunch getLaunch() {
        return this.myLaunch;
    }

    public void setAttribute(String key, String value) {
    }

    public String getAttribute(String key) {
        return null;
    }

    public int getExitValue() throws DebugException {
        if (!this.isTerminated()) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.ocl.examples.debug.vm", 1, VMMessages.ShallowProcess_InvalidState, null));
        }
        return 0;
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.myRunnable == null;
    }

    public void terminate() throws DebugException {
    }
}

