/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.event;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.debug.vm.data.VMLocationData;
import org.eclipse.ocl.examples.debug.vm.data.VMStackFrameData;
import org.eclipse.ocl.examples.debug.vm.data.VMSuspension;
import org.eclipse.ocl.examples.debug.vm.event.VMEvent;

public class VMSuspendEvent
extends VMEvent {
    private static final long serialVersionUID = 2494519177689939386L;
    public @NonNull VMLocationData location;
    public @NonNull VMStackFrameData @NonNull [] stackFrames;
    public Long breakpointID;
    public final @NonNull VMSuspension suspension;
    public String reason;
    public String reasonDetail;

    public VMSuspendEvent(@NonNull VMStackFrameData @NonNull [] stack, @NonNull VMSuspension suspension) {
        if (stack.length == 0) {
            throw new IllegalArgumentException("empty stack");
        }
        this.stackFrames = stack;
        this.location = stack[0].getLocation();
        this.suspension = suspension;
    }

    public Long getBreakpointID() {
        return this.breakpointID;
    }

    public String getReason() {
        return this.reason;
    }

    public String getReasonDetail() {
        return this.reasonDetail;
    }

    public void setBreakpointID(Long breakpointID) {
        this.breakpointID = breakpointID;
    }

    public void setReason(String reason, String reasonDetail) {
        if (reason == null && reasonDetail != null) {
            throw new IllegalArgumentException();
        }
        this.reason = reason;
        this.reasonDetail = reasonDetail;
    }

    public void setReasonDetail(String reasonDetail) {
        this.reasonDetail = reasonDetail;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.getClass().getSimpleName());
        s.append("(");
        this.suspension.toString(s);
        if (this.breakpointID != null) {
            s.append(" breakpointID:").append(this.breakpointID);
        }
        if (this.reason != null) {
            s.append(" reason:").append(this.reason.substring(0, Math.min(50, this.reason.length())));
        }
        if (this.stackFrames != null) {
            s.append(", {");
            int i = 0;
            while (i < this.stackFrames.length) {
                if (i > 0) {
                    s.append(",");
                }
                s.append("\n\t");
                s.append(this.stackFrames[i]);
                ++i;
            }
            s.append("}");
        }
        s.append(")");
        return s.toString();
    }
}

