/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.documentModel.partitioner;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPHPScriptRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public abstract class PHPPartitionTypes {
    public static final String PHP_DEFAULT = "org.eclipse.php.PHP_DEFAULT";
    public static final String PHP_SINGLE_LINE_COMMENT = "org.eclipse.php.PHP_SINGLE_LINE_COMMENT";
    public static final String PHP_MULTI_LINE_COMMENT = "org.eclipse.php.PHP_MULTI_LINE_COMMENT";
    public static final String PHP_DOC = "org.eclipse.php.PHP_DOC";
    public static final String PHP_QUOTED_STRING = "org.eclipse.php.PHP_QUOTED_STRING";

    public static String getPartitionType(String type) {
        assert (type != null);
        if (PHPPartitionTypes.isPHPMultiLineCommentState(type)) {
            return PHP_MULTI_LINE_COMMENT;
        }
        if (PHPPartitionTypes.isPHPLineCommentState(type)) {
            return PHP_SINGLE_LINE_COMMENT;
        }
        if (PHPPartitionTypes.isPHPDocState(type)) {
            return PHP_DOC;
        }
        if (PHPPartitionTypes.isPHPQuotesState(type)) {
            return PHP_QUOTED_STRING;
        }
        if (PHPPartitionTypes.isPHPRegularState(type)) {
            return PHP_DEFAULT;
        }
        assert (false);
        return null;
    }

    public static boolean isPHPCommentState(String type) {
        return PHPPartitionTypes.isPHPMultiLineCommentState(type) || PHPPartitionTypes.isPHPLineCommentState(type) || PHPPartitionTypes.isPHPDocState(type);
    }

    public static boolean isPHPDocState(String type) {
        return type == null ? false : type.startsWith("PHPDOC");
    }

    public static boolean isPHPDocTagState(String type) {
        return PHPPartitionTypes.isPHPDocState(type) && !type.startsWith("PHPDOC_COMMENT");
    }

    public static boolean isPHPDocRegion(String type) {
        return type == "PHPDOC_COMMENT" || PHPPartitionTypes.isPHPDocTagState(type);
    }

    public static boolean isPHPDocStartRegion(String type) {
        return type == "PHPDOC_COMMENT_START";
    }

    public static boolean isPHPDocEndRegion(String type) {
        return type == "PHPDOC_COMMENT_END";
    }

    public static boolean isPHPLineCommentState(String type) {
        return type == "PHP_LINE_COMMENT";
    }

    public static boolean isPHPMultiLineCommentStartRegion(String type) {
        return type == "PHP_COMMENT_START";
    }

    public static boolean isPHPMultiLineCommentRegion(String type) {
        return type == "PHP_COMMENT";
    }

    public static boolean isPHPMultiLineCommentEndRegion(String type) {
        return type == "PHP_COMMENT_END";
    }

    public static boolean isPHPMultiLineCommentState(String type) {
        return PHPPartitionTypes.isPHPMultiLineCommentStartRegion(type) || PHPPartitionTypes.isPHPMultiLineCommentRegion(type) || PHPPartitionTypes.isPHPMultiLineCommentEndRegion(type);
    }

    public static boolean isPHPQuotesState(String type) {
        return type == "PHP_CONSTANT_ENCAPSED_STRING" || type == "PHP_ENCAPSED_AND_WHITESPACE" || type == "PHP_HEREDOC_START_TAG" || type == "PHP_HEREDOC_CLOSE_TAG" || type == "PHP_NOWDOC_START_TAG" || type == "PHP_NOWDOC_CLOSE_TAG";
    }

    public static final boolean isPHPRegularState(String type) {
        return type != null && !PHPPartitionTypes.isPHPCommentState(type) && !PHPPartitionTypes.isPHPQuotesState(type);
    }

    public static final ITextRegion getPartitionStartRegion(IPHPScriptRegion region, int relativeOffset) throws BadLocationException {
        ITextRegion internalRegion;
        String partitionType = region.getPartition(relativeOffset);
        ITextRegion startRegion = internalRegion = region.getPHPToken(relativeOffset);
        while (internalRegion.getStart() != 0) {
            if (region.getPartition((internalRegion = region.getPHPToken(internalRegion.getStart() - 1)).getStart()) != partitionType) break;
            startRegion = internalRegion;
        }
        return startRegion;
    }

    public static final int getPartitionStart(IPHPScriptRegion region, int relativeOffset) throws BadLocationException {
        ITextRegion startRegion = PHPPartitionTypes.getPartitionStartRegion(region, relativeOffset);
        return startRegion.getStart();
    }

    public static final ITextRegion getPartitionEndRegion(IPHPScriptRegion region, int relativeOffset) throws BadLocationException {
        ITextRegion internalRegion;
        String partitionType = region.getPartition(relativeOffset);
        ITextRegion endRegion = internalRegion = region.getPHPToken(relativeOffset);
        while (internalRegion.getEnd() != region.getLength()) {
            if (region.getPartition((internalRegion = region.getPHPToken(internalRegion.getEnd())).getStart()) != partitionType) break;
            endRegion = internalRegion;
        }
        return endRegion;
    }

    public static final int getPartitionEnd(IPHPScriptRegion region, int relativeOffset) throws BadLocationException {
        ITextRegion endRegion = PHPPartitionTypes.getPartitionEndRegion(region, relativeOffset);
        return endRegion.getEnd();
    }

    public static final ITypedRegion getPartition(IPHPScriptRegion region, int relativeOffset) throws BadLocationException {
        String partitionType = region.getPartition(relativeOffset);
        int startOffset = PHPPartitionTypes.getPartitionStart(region, relativeOffset);
        int endOffset = PHPPartitionTypes.getPartitionEnd(region, relativeOffset);
        return new TypedRegion(startOffset, endOffset - startOffset, partitionType);
    }

    public static boolean isPHPCondition(String type) {
        return type == "PHP_IF" || type == "PHP_FOR" || type == "PHP_FOREACH";
    }

    public static boolean isPHPLoop(String type) {
        return type == "PHP_WHILE" || type == "PHP_DO";
    }
}

