/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.naming;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.naming.ICopyQualifiedNameService;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.util.PolymorphicDispatcher;
import org.eclipse.xtext.xbase.lib.Functions;

public class DefaultCopyQualifiedNameService
implements ICopyQualifiedNameService {
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    private PolymorphicDispatcher<String> dispatchGetQualifiedName = PolymorphicDispatcher.createForSingleTarget((String)"_getQualifiedName", (int)2, (int)2, (Object)this);

    @Override
    public String getQualifiedName(EObject it, EObject context) {
        return (String)this.dispatchGetQualifiedName.invoke(new Object[]{it, context});
    }

    protected String _getQualifiedName(EObject object, EObject context) {
        return this.toFullyQualifiedName(object);
    }

    protected String _getQualifiedName(EObject object, Void context) {
        return this.toFullyQualifiedName(object);
    }

    protected String _getQualifiedName(Void nullObject, EObject context) {
        return null;
    }

    protected String _getQualifiedName(Void nullObject, Void context) {
        return null;
    }

    protected <T> CharSequence toQualifiedNames(List<T> list, Functions.Function1<? super T, ? extends String> toQualifiedNameFunction) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        return Joiner.on((String)", ").skipNulls().join((Iterable)Lists.transform(list, arg_0 -> toQualifiedNameFunction.apply(arg_0)));
    }

    protected String toFullyQualifiedName(EObject object) {
        return this.toString(object, this.getFullyQualifiedName(object));
    }

    protected QualifiedName getFullyQualifiedName(EObject object) {
        if (object == null) {
            return null;
        }
        return this.qualifiedNameProvider.getFullyQualifiedName(object);
    }

    protected String toString(EObject it, QualifiedName fullyQualifiedName) {
        if (fullyQualifiedName == null) {
            return null;
        }
        return this.qualifiedNameConverter.toString(fullyQualifiedName);
    }
}

