import { LanguagePlugin, LanguageService, LanguageServiceEnvironment, ProviderResult, UriMap } from '@volar/language-service';
import { TypeScriptProjectHost, createSys } from '@volar/typescript';
import type * as ts from 'typescript';
import { URI } from 'vscode-uri';
import type { LanguageServer } from '../types';
export interface TypeScriptProjectLS {
    askedFiles: UriMap<boolean>;
    tryAddFile(fileName: string): void;
    getParsedCommandLine(): ts.ParsedCommandLine;
    languageService: LanguageService;
    dispose(): void;
}
export interface ProjectExposeContext {
    configFileName: string | undefined;
    projectHost: TypeScriptProjectHost;
    sys: ReturnType<typeof createSys>;
    asUri(fileName: string): URI;
    asFileName(scriptId: URI): string;
}
export declare function createTypeScriptLS(ts: typeof import('typescript'), tsLocalized: ts.MapLike<string> | undefined, tsconfig: string | ts.CompilerOptions, server: LanguageServer, serviceEnv: LanguageServiceEnvironment, workspaceFolder: URI, getLanguagePlugins: (env: LanguageServiceEnvironment, projectContext: ProjectExposeContext) => ProviderResult<LanguagePlugin<URI>[]>, { asUri, asFileName, }: {
    asUri(fileName: string): URI;
    asFileName(uri: URI): string;
}): Promise<TypeScriptProjectLS>;
