/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.gefTree.policy;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.wb.core.gef.command.EditCommand;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.gef.core.requests.PasteRequest;
import org.eclipse.wb.gef.tree.policies.LayoutEditPolicy;
import org.eclipse.wb.internal.core.utils.state.GlobalState;
import org.eclipse.wb.internal.core.utils.state.IPasteComponentProcessor;

public abstract class ObjectLayoutEditPolicy<C>
extends LayoutEditPolicy {
    private final ObjectInfo m_host;

    public ObjectLayoutEditPolicy(ObjectInfo host) {
        this.m_host = host;
    }

    @Override
    protected Command getCreateCommand(final Object newObject, final Object referenceObject) {
        return new EditCommand(this.m_host){

            @Override
            protected void executeEdit() throws Exception {
                ObjectLayoutEditPolicy.this.command_CREATE(ObjectLayoutEditPolicy.this.getObjectModel(newObject), ObjectLayoutEditPolicy.this.getReferenceModel(referenceObject));
            }
        };
    }

    @Override
    protected Command getPasteCommand(PasteRequest request, Object referenceObject) {
        final C reference = this.getReferenceModel(referenceObject);
        return GlobalState.getPasteRequestProcessor().getPasteCommand(request, new IPasteComponentProcessor(){

            @Override
            public void process(Object component) throws Exception {
                ObjectLayoutEditPolicy.this.command_CREATE(ObjectLayoutEditPolicy.this.getObjectModel(component), reference);
            }
        });
    }

    @Override
    protected Command getMoveCommand(final List<? extends EditPart> moveParts, final Object referenceObject) {
        return new EditCommand(this.m_host){

            @Override
            protected void executeEdit() throws Exception {
                List objects = ObjectLayoutEditPolicy.this.getModels(moveParts);
                ObjectLayoutEditPolicy.this.command_MOVE(objects, ObjectLayoutEditPolicy.this.getReferenceModel(referenceObject));
            }
        };
    }

    @Override
    protected Command getAddCommand(final List<? extends EditPart> addParts, final Object referenceObject) {
        return new EditCommand(this.m_host){

            @Override
            protected void executeEdit() throws Exception {
                List objects = ObjectLayoutEditPolicy.this.getModels(addParts);
                ObjectLayoutEditPolicy.this.command_ADD(objects, ObjectLayoutEditPolicy.this.getReferenceModel(referenceObject));
            }
        };
    }

    protected void command_CREATE(C newObject, C referenceObject) throws Exception {
    }

    protected void command_MOVE(List<C> objects, C referenceObject) throws Exception {
        for (C object : objects) {
            this.command_MOVE(object, referenceObject);
        }
    }

    protected void command_ADD(List<C> objects, C referenceObject) throws Exception {
        for (C object : objects) {
            this.command_ADD(object, referenceObject);
        }
    }

    protected void command_MOVE(C object, C referenceObject) throws Exception {
    }

    protected void command_ADD(C object, C referenceObject) throws Exception {
        this.command_MOVE(object, referenceObject);
    }

    private C getObjectModel(Object object) {
        return (C)object;
    }

    private C getReferenceModel(Object referenceObject) {
        return (C)referenceObject;
    }

    private List<C> getModels(List<? extends EditPart> editParts) {
        ArrayList<C> objects = new ArrayList<C>();
        for (EditPart editPart : editParts) {
            Object rawModel = editPart.getModel();
            C objectModel = this.getObjectModel(rawModel);
            objects.add(objectModel);
        }
        return objects;
    }
}

