/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.psystem.queries;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.psystem.IMultiQueryReference;
import org.eclipse.viatra.query.runtime.matchers.psystem.ITypeConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PTraceable;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PDisjunction;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameterDirection;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;

public final class PQueries {
    private PQueries() {
    }

    public static Predicate<PQuery> queryStatusPredicate(PQuery.PQueryStatus status) {
        return query -> query.getStatus().equals((Object)status);
    }

    public static Function<PBody, Stream<PQuery>> directlyReferencedQueriesFunction() {
        return body -> body.getConstraintsOfType(IMultiQueryReference.class).stream().flatMap(e -> e.getReferredQueries().stream()).distinct();
    }

    public static Stream<IInputKey> directlyRequiredTypesOfQuery(PQuery query, boolean enumerablesOnly) {
        return PQueries.directlyRequiredTypesOfDisjunction(query.getDisjunctBodies(), enumerablesOnly);
    }

    public static Stream<IInputKey> directlyRequiredTypesOfDisjunction(PDisjunction disjunctBodies, boolean enumerablesOnly) {
        Class filterClass = enumerablesOnly ? TypeConstraint.class : ITypeConstraint.class;
        return disjunctBodies.getBodies().stream().flatMap(body -> body.getConstraintsOfType(filterClass).stream()).map(constraint -> constraint.getEquivalentJudgement().getInputKey()).distinct();
    }

    public static Predicate<PParameter> parameterDirectionPredicate(PParameterDirection direction) {
        return input -> input.getDirection() == direction;
    }

    public static Set<PTraceable> getTraceables(PQuery query) {
        HashSet<PTraceable> traceables = new HashSet<PTraceable>();
        traceables.add(query);
        query.getDisjunctBodies().getBodies().forEach(body -> {
            traceables.add((PTraceable)body);
            body.getConstraints().forEach(traceables::add);
        });
        return traceables;
    }

    public static String calculateSimpleName(String qualifiedName) {
        return qualifiedName.substring(qualifiedName.lastIndexOf(46) + 1);
    }
}

