/**
 * Copyright (c) 2010-2012, Zoltan Ujhelyi, Abel Hegedus, Tamas Szabo, Istvan Rath and Daniel Varro
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-v20.html.
 * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.viatra.addon.validation.tooling;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.viatra.query.patternlanguage.emf.helper.PatternLanguageHelper;
import org.eclipse.viatra.query.patternlanguage.emf.jvmmodel.EMFPatternLanguageJvmModelInferrerUtil;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Annotation;
import org.eclipse.viatra.query.patternlanguage.emf.vql.AnnotationParameter;
import org.eclipse.viatra.query.patternlanguage.emf.vql.ListValue;
import org.eclipse.viatra.query.patternlanguage.emf.vql.PackageImport;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Pattern;
import org.eclipse.viatra.query.patternlanguage.emf.vql.PatternModel;
import org.eclipse.viatra.query.patternlanguage.emf.vql.StringValue;
import org.eclipse.viatra.query.patternlanguage.emf.vql.ValueReference;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Variable;
import org.eclipse.viatra.query.patternlanguage.emf.vql.VariableReference;
import org.eclipse.viatra.query.tooling.core.generator.ExtensionData;
import org.eclipse.viatra.query.tooling.core.generator.ExtensionGenerator;
import org.eclipse.viatra.query.tooling.core.generator.fragments.IGenerationFragment;
import org.eclipse.viatra.query.tooling.core.generator.genmodel.IVQGenmodelProvider;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.w3c.dom.Element;

@SuppressWarnings("all")
public class ValidationGenerator implements IGenerationFragment {
  @Inject
  @Extension
  private EMFPatternLanguageJvmModelInferrerUtil _eMFPatternLanguageJvmModelInferrerUtil;

  @Inject
  private IVQGenmodelProvider vqGenModelProvider;

  @Inject
  @Extension
  private ExtensionGenerator exGen;

  private static final String VALIDATIONEXTENSION_PREFIX = "validation.constraint.";

  private static final String UI_VALIDATION_MENUS_PREFIX = "generated.viatra.addon.validation.menu.";

  private static final String VALIDATION_EXTENSION_POINT = "org.eclipse.viatra.addon.validation.runtime.constraint";

  private static final String ECLIPSE_MENUS_EXTENSION_POINT = "org.eclipse.ui.menus";

  private static final String ANNOTATION_NAME = "Constraint";

  @Override
  public void generateFiles(final Pattern pattern, final IFileSystemAccess fsa) {
    final Function1<Annotation, Boolean> _function = (Annotation it) -> {
      String _name = it.getName();
      return Boolean.valueOf(Objects.equals(_name, ValidationGenerator.ANNOTATION_NAME));
    };
    final Consumer<Annotation> _function_1 = (Annotation ann) -> {
      fsa.generateFile(this.constraintClassJavaFile(pattern, ann), this.patternHandler(pattern, ann));
    };
    IterableExtensions.<Annotation>filter(pattern.getAnnotations(), _function).forEach(_function_1);
  }

  @Override
  public void cleanUp(final Pattern pattern, final IFileSystemAccess fsa) {
    final Function1<Annotation, Boolean> _function = (Annotation it) -> {
      String _name = it.getName();
      return Boolean.valueOf(Objects.equals(_name, ValidationGenerator.ANNOTATION_NAME));
    };
    final Consumer<Annotation> _function_1 = (Annotation ann) -> {
      fsa.deleteFile(this.constraintClassJavaFile(pattern, ann));
    };
    IterableExtensions.<Annotation>filter(pattern.getAnnotations(), _function).forEach(_function_1);
  }

  @Override
  public Iterable<Pair<String, String>> removeExtension(final Pattern pattern) {
    final Pair<String, String> p = Pair.<String, String>of(this.constraintContributionId(pattern), ValidationGenerator.VALIDATION_EXTENSION_POINT);
    final ArrayList<Pair<String, String>> extensionList = CollectionLiterals.<Pair<String, String>>newArrayList(p);
    EObject _eContainer = pattern.eContainer();
    final PatternModel patternModel = ((PatternModel) _eContainer);
    Iterable<PackageImport> _packageImportsIterable = PatternLanguageHelper.getPackageImportsIterable(patternModel);
    for (final PackageImport imp : _packageImportsIterable) {
      {
        final EPackage pack = imp.getEPackage();
        final GenPackage genPackage = this.vqGenModelProvider.findGenPackage(pattern, pack);
        if ((genPackage != null)) {
          String _qualifiedEditorClassName = genPackage.getQualifiedEditorClassName();
          final String editorId = (_qualifiedEditorClassName + "ID");
          boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(editorId);
          boolean _not = (!_isNullOrEmpty);
          if (_not) {
            extensionList.add(Pair.<String, String>of(this.menuContributionId(editorId), ValidationGenerator.ECLIPSE_MENUS_EXTENSION_POINT));
          }
        }
      }
    }
    EList<Annotation> _annotations = pattern.getAnnotations();
    for (final Annotation ann : _annotations) {
      String _name = ann.getName();
      boolean _equals = Objects.equals(_name, ValidationGenerator.ANNOTATION_NAME);
      if (_equals) {
        final ArrayList<ValueReference> editorIds = this.getAnnotationParameterValue(ann, "targetEditorId");
        for (final ValueReference id : editorIds) {
          {
            final String editorId = ((StringValue) id).getValue();
            extensionList.add(Pair.<String, String>of(this.menuContributionId(editorId), ValidationGenerator.ECLIPSE_MENUS_EXTENSION_POINT));
          }
        }
      }
    }
    return extensionList;
  }

  @Override
  public Collection<Pair<String, String>> getRemovableExtensions() {
    return CollectionLiterals.<Pair<String, String>>newArrayList(
      Pair.<String, String>of(ValidationGenerator.VALIDATIONEXTENSION_PREFIX, ValidationGenerator.VALIDATION_EXTENSION_POINT), 
      Pair.<String, String>of(ValidationGenerator.UI_VALIDATION_MENUS_PREFIX, ValidationGenerator.ECLIPSE_MENUS_EXTENSION_POINT));
  }

  @Override
  public String[] getProjectDependencies() {
    return ((String[])Conversions.unwrapArray(CollectionLiterals.<String>newArrayList(
      "org.eclipse.viatra.query.runtime", 
      "org.eclipse.viatra.addon.validation.core"), String.class));
  }

  @Override
  public String getProjectPostfix() {
    return "validation";
  }

  @Override
  public Iterable<ExtensionData> extensionContribution(final Pattern pattern) {
    final Procedure1<Element> _function = (Element it) -> {
      EList<Annotation> _annotations = pattern.getAnnotations();
      for (final Annotation ann : _annotations) {
        String _name = ann.getName();
        boolean _equals = Objects.equals(_name, ValidationGenerator.ANNOTATION_NAME);
        if (_equals) {
          final Procedure1<Element> _function_1 = (Element it_1) -> {
            this.exGen.contribAttribute(it_1, "class", this.constraintClassName(pattern, ann));
            this.exGen.contribAttribute(it_1, "name", PatternLanguageHelper.getFullyQualifiedName(pattern));
            final ArrayList<ValueReference> editorIds = this.getAnnotationParameterValue(ann, "targetEditorId");
            for (final ValueReference id : editorIds) {
              {
                final String editorId = ((StringValue) id).getValue();
                final Procedure1<Element> _function_2 = (Element it_2) -> {
                  this.exGen.contribAttribute(it_2, "editorId", editorId);
                };
                this.exGen.contribElement(it_1, "enabledForEditor", _function_2);
              }
            }
            EObject _eContainer = pattern.eContainer();
            final PatternModel patternModel = ((PatternModel) _eContainer);
            Iterable<PackageImport> _packageImportsIterable = PatternLanguageHelper.getPackageImportsIterable(patternModel);
            for (final PackageImport imp : _packageImportsIterable) {
              {
                final EPackage pack = imp.getEPackage();
                final GenPackage genPackage = this.vqGenModelProvider.findGenPackage(pattern, pack);
                if ((genPackage != null)) {
                  String _qualifiedEditorClassName = genPackage.getQualifiedEditorClassName();
                  final String editorId = (_qualifiedEditorClassName + "ID");
                  final Procedure1<Element> _function_2 = (Element it_2) -> {
                    this.exGen.contribAttribute(it_2, "editorId", editorId);
                  };
                  this.exGen.contribElement(it_1, "enabledForEditor", _function_2);
                }
              }
            }
          };
          this.exGen.contribElement(it, "constraint", _function_1);
        }
      }
    };
    final ArrayList<ExtensionData> extensionList = CollectionLiterals.<ExtensionData>newArrayList(
      this.exGen.contribExtension(this.constraintContributionId(pattern), ValidationGenerator.VALIDATION_EXTENSION_POINT, _function));
    return extensionList;
  }

  public String constraintClassName(final Pattern pattern, final Annotation annotation) {
    return String.format("%s.%s%s%s", this._eMFPatternLanguageJvmModelInferrerUtil.getPackageName(pattern), StringExtensions.toFirstUpper(this._eMFPatternLanguageJvmModelInferrerUtil.realPatternName(pattern)), ValidationGenerator.ANNOTATION_NAME, 
      Integer.valueOf(pattern.getAnnotations().indexOf(annotation)));
  }

  public String constraintClassPath(final Pattern pattern, final Annotation annotation) {
    return String.format("%s/%s%s%s", this._eMFPatternLanguageJvmModelInferrerUtil.getPackagePath(pattern), StringExtensions.toFirstUpper(this._eMFPatternLanguageJvmModelInferrerUtil.realPatternName(pattern)), ValidationGenerator.ANNOTATION_NAME, 
      Integer.valueOf(pattern.getAnnotations().indexOf(annotation)));
  }

  public String constraintClassJavaFile(final Pattern pattern, final Annotation annotation) {
    String _constraintClassPath = this.constraintClassPath(pattern, annotation);
    return (_constraintClassPath + ".java");
  }

  public String constraintContributionId(final Pattern pattern) {
    String _fullyQualifiedName = PatternLanguageHelper.getFullyQualifiedName(pattern);
    return (ValidationGenerator.VALIDATIONEXTENSION_PREFIX + _fullyQualifiedName);
  }

  public String menuContributionId(final String editorId) {
    return String.format("%s%s", ValidationGenerator.UI_VALIDATION_MENUS_PREFIX, editorId);
  }

  public String getElementOfConstraintAnnotation(final Annotation annotation, final String elementName) {
    final ValueReference ap = PatternLanguageHelper.getFirstAnnotationParameter(annotation, elementName);
    String _switchResult = null;
    boolean _matched = false;
    if (ap instanceof StringValue) {
      _matched=true;
      _switchResult = ((StringValue)ap).getValue();
    }
    if (!_matched) {
      if (ap instanceof VariableReference) {
        _matched=true;
        _switchResult = ((VariableReference)ap).getVar();
      }
    }
    if (!_matched) {
      _switchResult = null;
    }
    return _switchResult;
  }

  public ArrayList<ValueReference> getAnnotationParameterValue(final Annotation annotation, final String elementName) {
    final ArrayList<ValueReference> values = CollectionLiterals.<ValueReference>newArrayList();
    EList<AnnotationParameter> _parameters = annotation.getParameters();
    for (final AnnotationParameter ap : _parameters) {
      boolean _matches = ap.getName().matches(elementName);
      if (_matches) {
        values.add(ap.getValue());
      }
    }
    return values;
  }

  @Override
  public IPath[] getAdditionalBinIncludes() {
    Path _path = new Path("plugin.xml");
    return ((IPath[])Conversions.unwrapArray(CollectionLiterals.<IPath>newArrayList(_path), IPath.class));
  }

  public CharSequence patternHandler(final Pattern pattern, final Annotation annotation) {
    CharSequence _xblockexpression = null;
    {
      final JvmType specificationType = this._eMFPatternLanguageJvmModelInferrerUtil.findInferredSpecification(pattern);
      String _firstUpper = StringExtensions.toFirstUpper(pattern.getName());
      String _plus = (_firstUpper + ValidationGenerator.ANNOTATION_NAME);
      int _indexOf = pattern.getAnnotations().indexOf(annotation);
      final String className = (_plus + Integer.valueOf(_indexOf));
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("/**");
      _builder.newLine();
      String _fileComment = this._eMFPatternLanguageJvmModelInferrerUtil.getFileComment(pattern);
      _builder.append(_fileComment);
      _builder.newLineIfNotEmpty();
      _builder.append("*/");
      _builder.newLine();
      _builder.append("package ");
      String _packageName = this._eMFPatternLanguageJvmModelInferrerUtil.getPackageName(pattern);
      _builder.append(_packageName);
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("import java.util.HashMap;");
      _builder.newLine();
      _builder.append("import java.util.HashSet;");
      _builder.newLine();
      _builder.append("import java.util.List;");
      _builder.newLine();
      _builder.append("import java.util.Map;");
      _builder.newLine();
      _builder.append("import java.util.Set;");
      _builder.newLine();
      _builder.append("import java.util.Arrays;");
      _builder.newLine();
      _builder.newLine();
      _builder.append("import org.eclipse.viatra.addon.validation.core.api.Severity;");
      _builder.newLine();
      _builder.append("import org.eclipse.viatra.addon.validation.core.api.IConstraintSpecification;");
      _builder.newLine();
      _builder.append("import org.eclipse.viatra.query.runtime.api.IPatternMatch;");
      _builder.newLine();
      _builder.append("import org.eclipse.viatra.query.runtime.api.IQuerySpecification;");
      _builder.newLine();
      _builder.append("import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;");
      _builder.newLine();
      _builder.newLine();
      _builder.append("import ");
      String _qualifiedName = specificationType.getQualifiedName();
      _builder.append(_qualifiedName);
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("public class ");
      _builder.append(className);
      _builder.append(" implements IConstraintSpecification {");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("    ");
      _builder.append("private ");
      String _simpleName = specificationType.getSimpleName();
      _builder.append(_simpleName, "    ");
      _builder.append(" querySpecification;");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("    ");
      _builder.append("public ");
      _builder.append(className, "    ");
      _builder.append("() {");
      _builder.newLineIfNotEmpty();
      _builder.append("        ");
      _builder.append("querySpecification = ");
      String _simpleName_1 = specificationType.getSimpleName();
      _builder.append(_simpleName_1, "        ");
      _builder.append(".instance();");
      _builder.newLineIfNotEmpty();
      _builder.append("    ");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("    ");
      _builder.append("@Override");
      _builder.newLine();
      _builder.append("    ");
      _builder.append("public String getMessageFormat() {");
      _builder.newLine();
      _builder.append("        ");
      _builder.append("return \"");
      String _xifexpression = null;
      boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(this.getElementOfConstraintAnnotation(annotation, "message"));
      if (_isNullOrEmpty) {
        _xifexpression = "";
      } else {
        _xifexpression = Strings.convertToJavaString(this.getElementOfConstraintAnnotation(annotation, "message"));
      }
      _builder.append(_xifexpression, "        ");
      _builder.append("\";");
      _builder.newLineIfNotEmpty();
      _builder.append("    ");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.newLine();
      _builder.append("    ");
      _builder.append("@Override");
      _builder.newLine();
      _builder.append("    ");
      _builder.append("public Map<String,Object> getKeyObjects(IPatternMatch signature) {");
      _builder.newLine();
      _builder.append("        ");
      _builder.append("Map<String,Object> map = new HashMap<>();");
      _builder.newLine();
      {
        List<String> _keyList = this.getKeyList(pattern, annotation);
        for(final String key : _keyList) {
          _builder.append("        ");
          _builder.append("map.put(\"");
          _builder.append(key, "        ");
          _builder.append("\",signature.get(\"");
          _builder.append(key, "        ");
          _builder.append("\"));");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.append("        ");
      _builder.append("return map;");
      _builder.newLine();
      _builder.append("    ");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("    ");
      _builder.append("@Override");
      _builder.newLine();
      _builder.append("    ");
      _builder.append("public List<String> getKeyNames() {");
      _builder.newLine();
      _builder.append("        ");
      _builder.append("List<String> keyNames = Arrays.asList(");
      _builder.newLine();
      {
        List<String> _keyList_1 = this.getKeyList(pattern, annotation);
        boolean _hasElements = false;
        for(final String key_1 : _keyList_1) {
          if (!_hasElements) {
            _hasElements = true;
          } else {
            _builder.appendImmediate(",", "            ");
          }
          _builder.append("            ");
          _builder.append("\"");
          _builder.append(key_1, "            ");
          _builder.append("\"");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.append("        ");
      _builder.append(");");
      _builder.newLine();
      _builder.append("        ");
      _builder.append("return keyNames;");
      _builder.newLine();
      _builder.append("    ");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("    ");
      _builder.append("@Override");
      _builder.newLine();
      _builder.append("    ");
      _builder.append("public List<String> getPropertyNames() {");
      _builder.newLine();
      _builder.append("        ");
      _builder.append("List<String> propertyNames = Arrays.asList(");
      _builder.newLine();
      {
        Iterable<String> _propertyList = this.getPropertyList(pattern, annotation);
        boolean _hasElements_1 = false;
        for(final String property : _propertyList) {
          if (!_hasElements_1) {
            _hasElements_1 = true;
          } else {
            _builder.appendImmediate(",", "            ");
          }
          _builder.append("            ");
          _builder.append("\"");
          _builder.append(property, "            ");
          _builder.append("\"");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.append("        ");
      _builder.append(");");
      _builder.newLine();
      _builder.append("        ");
      _builder.append("return propertyNames;");
      _builder.newLine();
      _builder.append("    ");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("    ");
      _builder.append("@Override");
      _builder.newLine();
      _builder.append("    ");
      _builder.append("public Set<List<String>> getSymmetricPropertyNames() {");
      _builder.newLine();
      _builder.append("        ");
      _builder.append("Set<List<String>> symmetricPropertyNamesSet = new HashSet<>();");
      _builder.newLine();
      _builder.append("        ");
      final Function1<List<String>, Boolean> _function = (List<String> it) -> {
        boolean _containsAll = this.getKeyList(pattern, annotation).containsAll(it);
        return Boolean.valueOf((!_containsAll));
      };
      final Iterable<List<String>> symmetricProperties = IterableExtensions.<List<String>>filter(this.getSymmetricList(pattern, annotation), _function);
      _builder.newLineIfNotEmpty();
      {
        for(final List<String> propertyList : symmetricProperties) {
          _builder.append("        ");
          _builder.append("symmetricPropertyNamesSet.add(Arrays.asList(");
          {
            boolean _hasElements_2 = false;
            for(final String property_1 : propertyList) {
              if (!_hasElements_2) {
                _hasElements_2 = true;
              } else {
                _builder.appendImmediate(",", "        ");
              }
              _builder.append("\"");
              _builder.append(property_1, "        ");
              _builder.append("\"");
            }
          }
          _builder.append("));");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.append("        ");
      _builder.append("return symmetricPropertyNamesSet;");
      _builder.newLine();
      _builder.append("    ");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("    ");
      _builder.append("@Override");
      _builder.newLine();
      _builder.append("    ");
      _builder.append("public Set<List<String>> getSymmetricKeyNames() {");
      _builder.newLine();
      _builder.append("        ");
      _builder.append("Set<List<String>> symmetricKeyNamesSet = new HashSet<>();");
      _builder.newLine();
      _builder.append("        ");
      final Function1<List<String>, Boolean> _function_1 = (List<String> it) -> {
        return Boolean.valueOf(this.getKeyList(pattern, annotation).containsAll(it));
      };
      final Iterable<List<String>> symmetricKeys = IterableExtensions.<List<String>>filter(this.getSymmetricList(pattern, annotation), _function_1);
      _builder.newLineIfNotEmpty();
      {
        for(final List<String> symmetricKeyList : symmetricKeys) {
          _builder.append("        ");
          _builder.append("symmetricKeyNamesSet.add(Arrays.asList(");
          {
            boolean _hasElements_3 = false;
            for(final String key_2 : symmetricKeyList) {
              if (!_hasElements_3) {
                _hasElements_3 = true;
              } else {
                _builder.appendImmediate(",", "        ");
              }
              _builder.append("\"");
              _builder.append(key_2, "        ");
              _builder.append("\"");
            }
          }
          _builder.append("));");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.append("        ");
      _builder.append("return symmetricKeyNamesSet;");
      _builder.newLine();
      _builder.append("    ");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("    ");
      _builder.append("@Override");
      _builder.newLine();
      _builder.append("    ");
      _builder.append("public Severity getSeverity() {");
      _builder.newLine();
      _builder.append("        ");
      _builder.append("return Severity.");
      String _upperCase = this.getElementOfConstraintAnnotation(annotation, "severity").toUpperCase();
      _builder.append(_upperCase, "        ");
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.append("    ");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("    ");
      _builder.append("@Override");
      _builder.newLine();
      _builder.append("    ");
      _builder.append("public IQuerySpecification<? extends ViatraQueryMatcher<? extends IPatternMatch>> getQuerySpecification() {");
      _builder.newLine();
      _builder.append("        ");
      _builder.append("return querySpecification;");
      _builder.newLine();
      _builder.append("    ");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("}");
      _builder.newLine();
      _xblockexpression = _builder;
    }
    return _xblockexpression;
  }

  public List<String> getKeyList(final Pattern pattern, final Annotation annotation) {
    List<String> _xblockexpression = null;
    {
      ValueReference _firstAnnotationParameter = PatternLanguageHelper.getFirstAnnotationParameter(annotation, "key");
      final EList<ValueReference> keyParamValues = ((ListValue) _firstAnnotationParameter).getValues();
      final Function1<ValueReference, String> _function = (ValueReference it) -> {
        return this.getNameOfParameterFromValueReference(it);
      };
      _xblockexpression = ListExtensions.<ValueReference, String>map(keyParamValues, _function);
    }
    return _xblockexpression;
  }

  public Iterable<String> getPropertyList(final Pattern pattern, final Annotation annotation) {
    Iterable<String> _xblockexpression = null;
    {
      final Function1<Variable, String> _function = (Variable it) -> {
        return it.getName();
      };
      final List<String> parameters = ListExtensions.<Variable, String>map(pattern.getParameters(), _function);
      ValueReference _firstAnnotationParameter = PatternLanguageHelper.getFirstAnnotationParameter(annotation, "key");
      final EList<ValueReference> keyParamValues = ((ListValue) _firstAnnotationParameter).getValues();
      final Function1<ValueReference, String> _function_1 = (ValueReference it) -> {
        return this.getNameOfParameterFromValueReference(it);
      };
      final List<String> keys = ListExtensions.<ValueReference, String>map(keyParamValues, _function_1);
      final Function1<String, Boolean> _function_2 = (String it) -> {
        boolean _contains = keys.contains(it);
        return Boolean.valueOf((!_contains));
      };
      _xblockexpression = IterableExtensions.<String>filter(parameters, _function_2);
    }
    return _xblockexpression;
  }

  public Iterable<List<String>> getSymmetricList(final Pattern pattern, final Annotation annotation) {
    Iterable<List<String>> _xblockexpression = null;
    {
      final Collection<ValueReference> symmetricParams = PatternLanguageHelper.getAnnotationParameters(annotation, "symmetric");
      final Function1<ValueReference, List<String>> _function = (ValueReference it) -> {
        final Function1<ValueReference, String> _function_1 = (ValueReference it_1) -> {
          return this.getNameOfParameterFromValueReference(it_1);
        };
        return ListExtensions.<ValueReference, String>map(((ListValue) it).getValues(), _function_1);
      };
      _xblockexpression = IterableExtensions.<ValueReference, List<String>>map(symmetricParams, _function);
    }
    return _xblockexpression;
  }

  public String getNameOfParameterFromValueReference(final ValueReference ref) {
    String _xifexpression = null;
    if ((ref instanceof StringValue)) {
      _xifexpression = ((StringValue)ref).getValue();
    } else {
      String _xifexpression_1 = null;
      if ((ref instanceof VariableReference)) {
        _xifexpression_1 = ((VariableReference)ref).getVariable().getName();
      } else {
        _xifexpression_1 = ref.toString();
      }
      _xifexpression = _xifexpression_1;
    }
    return _xifexpression;
  }
}
