/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.serializer;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.xtext.base.serializer.DataTypeRuleValue;
import org.eclipse.ocl.xtext.base.serializer.DeclarativeSerializer;
import org.eclipse.ocl.xtext.base.serializer.DiagnosticStringBuilder;
import org.eclipse.ocl.xtext.base.serializer.DynamicRuleMatch;
import org.eclipse.ocl.xtext.base.serializer.EnumerationValue;
import org.eclipse.ocl.xtext.base.serializer.GrammarCardinality;
import org.eclipse.ocl.xtext.base.serializer.GrammarRuleValue;
import org.eclipse.ocl.xtext.base.serializer.GrammarRuleVector;
import org.eclipse.ocl.xtext.base.serializer.ParserRuleValue;
import org.eclipse.ocl.xtext.base.serializer.SerializationBuilder;
import org.eclipse.ocl.xtext.base.serializer.SerializationMetaData;
import org.eclipse.ocl.xtext.base.serializer.SerializationRule;
import org.eclipse.ocl.xtext.base.serializer.SerializationSegment;
import org.eclipse.ocl.xtext.base.serializer.SerializationUtils;
import org.eclipse.ocl.xtext.base.serializer.UserElementAnalysis;
import org.eclipse.ocl.xtext.base.serializer.UserElementMatcher;
import org.eclipse.ocl.xtext.base.serializer.UserElementSerializer;
import org.eclipse.ocl.xtext.base.serializer.UserModelAnalysis;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.impl.CompositeNodeWithSemanticElement;
import org.eclipse.xtext.nodemodel.impl.LeafNode;
import org.eclipse.xtext.util.Strings;

public abstract class SerializationStep {
    protected final @NonNull SerializationSegment @NonNull [] serializationSegments;
    private @Nullable Integer hashCode = null;

    protected SerializationStep(@NonNull SerializationSegment @Nullable [] serializationSegments) {
        this.serializationSegments = serializationSegments != null ? serializationSegments : SerializationSegment.VALUE_SEGMENTS_ARRAY;
    }

    protected @Nullable Integer basicGetHashCode() {
        return this.hashCode;
    }

    protected int computeHashCode() {
        int hash = this.getClass().hashCode();
        SerializationSegment[] serializationSegmentArray = this.serializationSegments;
        int n = this.serializationSegments.length;
        int n2 = 0;
        while (n2 < n) {
            @NonNull SerializationSegment serializationSegment = serializationSegmentArray[n2];
            hash = 3 * hash + serializationSegment.hashCode();
            ++n2;
        }
        return hash;
    }

    public abstract boolean equals(Object var1);

    protected boolean equalTo(@NonNull SerializationStep that) {
        @NonNull SerializationSegment[] theseSegments = this.serializationSegments;
        @NonNull SerializationSegment[] thoseSegments = that.serializationSegments;
        if (theseSegments.length != thoseSegments.length) {
            return false;
        }
        int i = 0;
        while (i < theseSegments.length) {
            if (!theseSegments[i].equals(thoseSegments[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public abstract @NonNull String getFailureReason(@NonNull DynamicRuleMatch var1);

    public abstract @NonNull String getGlobalSortKey(@NonNull Map<@NonNull List<@NonNull SerializationSegment>, @Nullable Integer> var1);

    protected void getGlobalSortKey(@NonNull StringBuilder s, @NonNull Map<@NonNull List<@NonNull SerializationSegment>, @Nullable Integer> serializationSegments2id) {
        s.append("-");
        if (this.serializationSegments.length > 0) {
            s.append(serializationSegments2id.get(Lists.newArrayList((Object[])this.serializationSegments)));
        } else {
            s.append("0");
        }
    }

    public @NonNull SerializationSegment @Nullable [] getSerializationSegments() {
        return this.serializationSegments;
    }

    public final int hashCode() {
        Integer hashCode2 = this.hashCode;
        if (hashCode2 == null) {
            this.hashCode = hashCode2 = Integer.valueOf(this.computeHashCode());
        }
        return hashCode2;
    }

    public abstract int matchOuterValue(int var1, @NonNull UserElementMatcher var2);

    public abstract boolean matches(@NonNull INode var1, @NonNull UserElementSerializer var2);

    public abstract void serializeInnerValue(int var1, @NonNull UserElementSerializer var2, @NonNull SerializationBuilder var3);

    public int serializeOuterValue(int thisSerializationStepIndex, @NonNull UserElementSerializer serializer, @NonNull SerializationBuilder serializationBuilder) {
        assert (serializer.getSerializationRule().getSerializationSteps()[thisSerializationStepIndex] == this);
        UserModelAnalysis modelAnalysis = serializer.getModelAnalysis();
        boolean isTracing = DeclarativeSerializer.SERIALIZER_FRAGMENTS.isActive();
        modelAnalysis.pushDepth();
        SerializationSegment[] serializationSegmentArray = this.serializationSegments;
        int n = this.serializationSegments.length;
        int n2 = 0;
        while (n2 < n) {
            SerializationSegment serializationSegment = serializationSegmentArray[n2];
            if (isTracing) {
                DeclarativeSerializer.SERIALIZER_FRAGMENTS.println(String.valueOf(modelAnalysis.getIndent()) + "segment: " + serializationSegment);
            }
            serializationSegment.serialize(thisSerializationStepIndex, serializer, serializationBuilder);
            ++n2;
        }
        modelAnalysis.popDepth();
        return thisSerializationStepIndex + 1;
    }

    public void toSegmentsString(@NonNull DiagnosticStringBuilder s, int depth) {
        SerializationSegment[] serializationSegments2;
        SerializationSegment[] serializationSegmentArray = serializationSegments2 = this.serializationSegments;
        int n = serializationSegments2.length;
        int n2 = 0;
        while (n2 < n) {
            SerializationSegment serializationSegment = serializationSegmentArray[n2];
            s.append(" ");
            s.append(serializationSegment.toString());
            ++n2;
        }
    }

    public abstract void toStepString(@NonNull DiagnosticStringBuilder var1);

    public @NonNull String toString() {
        DiagnosticStringBuilder s = new DiagnosticStringBuilder();
        this.toString(s, 0);
        return s.toString();
    }

    public void toString(@NonNull DiagnosticStringBuilder s, int depth) {
        this.toStepString(s);
        s.append(" ||");
        this.toSegmentsString(s, depth);
    }

    public static abstract class SerializationStepAbstractFeature
    extends SerializationStep {
        protected final @NonNull EStructuralFeature eStructuralFeature;

        protected SerializationStepAbstractFeature(@NonNull EStructuralFeature eStructuralFeature, @NonNull SerializationSegment @Nullable [] serializationSegments) {
            super(serializationSegments);
            assert (eStructuralFeature != null);
            this.eStructuralFeature = eStructuralFeature;
        }

        @Override
        public int computeHashCode() {
            return super.computeHashCode() + 3 * this.eStructuralFeature.hashCode();
        }

        protected boolean equalTo(@NonNull SerializationStepAbstractFeature that) {
            return super.equalTo(that) && this.eStructuralFeature.equals(that.eStructuralFeature);
        }

        public @NonNull EStructuralFeature getEStructuralFeature() {
            return this.eStructuralFeature;
        }

        @Override
        public final @NonNull String getGlobalSortKey(@NonNull Map<@NonNull List<@NonNull SerializationSegment>, @Nullable Integer> serializationSegments2id) {
            StringBuilder s = new StringBuilder();
            s.append("a-");
            s.append(this.eStructuralFeature.getName());
            s.append("-");
            s.append(this.eStructuralFeature.getEContainingClass().getName());
            s.append("-");
            s.append(this.eStructuralFeature.getEContainingClass().getEPackage().getName());
            this.getGlobalSortKey(s, serializationSegments2id);
            return s.toString();
        }
    }

    public static class SerializationStepAssignKeyword
    extends SerializationStepAbstractFeature {
        protected final @NonNull EnumerationValue enumerationValue;
        protected final boolean isBoolean;

        public SerializationStepAssignKeyword(@NonNull EStructuralFeature eStructuralFeature, @NonNull EnumerationValue enumerationValue, @NonNull SerializationSegment @Nullable [] serializationSegments) {
            super(eStructuralFeature, serializationSegments);
            assert (eStructuralFeature instanceof EAttribute);
            this.enumerationValue = enumerationValue;
            Class instanceClass = eStructuralFeature.getEType().getInstanceClass();
            this.isBoolean = instanceClass == Boolean.TYPE || instanceClass == Boolean.class;
        }

        @Override
        public int computeHashCode() {
            return super.computeHashCode() + 3 * this.enumerationValue.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SerializationStepAssignKeyword)) {
                return false;
            }
            return this.equalTo((SerializationStepAssignKeyword)obj);
        }

        protected boolean equalTo(@NonNull SerializationStepAssignKeyword that) {
            return super.equalTo(that) && this.enumerationValue == that.enumerationValue;
        }

        public @NonNull EnumerationValue getEnumerationValue() {
            return this.enumerationValue;
        }

        @Override
        public @NonNull String getFailureReason(@NonNull DynamicRuleMatch dynamicRuleMatch) {
            String prefixReason;
            Integer size = dynamicRuleMatch.getSize((EAttribute)this.eStructuralFeature, this.enumerationValue);
            String string = prefixReason = size > 0 ? "Incompatible" : "Missing";
            if (!this.isBoolean) {
                return String.valueOf(prefixReason) + " '" + this.eStructuralFeature.getEContainingClass().getName() + "::" + this.eStructuralFeature.getName() + "' String value.";
            }
            return String.valueOf(prefixReason) + " '" + this.eStructuralFeature.getEContainingClass().getName() + "::" + this.eStructuralFeature.getName() + "' Boolean value.";
        }

        @Override
        public int matchOuterValue(int thisSerializationStepIndex, @NonNull UserElementMatcher matcher) {
            boolean isOk;
            assert (matcher.getSerializationRule().getSerializationSteps()[thisSerializationStepIndex] == this);
            Object object = matcher.consumeNext(this.eStructuralFeature, null);
            if (!this.isBoolean) {
                isOk = object instanceof String && this.enumerationValue.isElement((String)object);
            } else {
                boolean bl = isOk = object == Boolean.TRUE;
            }
            if (!isOk) {
                matcher.setFailureStep(this);
                return -1;
            }
            return thisSerializationStepIndex + 1;
        }

        @Override
        public boolean matches(@NonNull INode node, @NonNull UserElementSerializer serializer) {
            EObject grammarElement;
            if (node instanceof LeafNode && (grammarElement = node.getGrammarElement()) instanceof Keyword) {
                String value = ((Keyword)grammarElement).getValue();
                return ClassUtil.safeEquals((Object)value, (Object)this.eStructuralFeature.getName());
            }
            return false;
        }

        @Override
        public void serializeInnerValue(int thisSerializationStepIndex, @NonNull UserElementSerializer serializer, @NonNull SerializationBuilder serializationBuilder) {
            Object object = serializer.consumeNext(this.eStructuralFeature);
            if (!this.isBoolean) {
                serializationBuilder.append(String.valueOf(object));
                DeclarativeSerializer.SERIALIZER_FRAGMENTS.println(String.valueOf(serializer.getModelAnalysis().getIndent(1)) + "assign: " + String.valueOf(object));
            } else if (object == Boolean.TRUE) {
                serializationBuilder.append(this.enumerationValue.getName());
                DeclarativeSerializer.SERIALIZER_FRAGMENTS.println(String.valueOf(serializer.getModelAnalysis().getIndent(1)) + "assign: " + this.enumerationValue.getName());
            }
        }

        @Override
        public void toStepString(@NonNull DiagnosticStringBuilder s) {
            s.append(SerializationUtils.getName((ENamedElement)SerializationUtils.getEContainingClass(this.eStructuralFeature)));
            s.append("::");
            s.append(SerializationUtils.getName((ENamedElement)this.eStructuralFeature));
            s.append(this.eStructuralFeature.isMany() ? "+=" : (this.isBoolean ? "?=" : "="));
            s.append("'");
            s.append(this.enumerationValue.getName());
            s.append("'");
        }
    }

    public static class SerializationStepAssignedRuleCall
    extends SerializationStepAbstractFeature {
        private int calledRuleIndex;

        public SerializationStepAssignedRuleCall(@NonNull EStructuralFeature eStructuralFeature, int calledValueIndex, @NonNull SerializationSegment @Nullable [] serializationSegments) {
            super(eStructuralFeature, serializationSegments);
            this.calledRuleIndex = calledValueIndex;
        }

        @Override
        public int computeHashCode() {
            return super.computeHashCode() + 5 * this.calledRuleIndex;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SerializationStepAssignedRuleCall)) {
                return false;
            }
            return this.equalTo((SerializationStepAssignedRuleCall)obj);
        }

        protected boolean equalTo(@NonNull SerializationStepAssignedRuleCall that) {
            return super.equalTo(that) && this.calledRuleIndex == that.calledRuleIndex;
        }

        public int getCalledRuleIndex() {
            return this.calledRuleIndex;
        }

        @Override
        public @NonNull String getFailureReason(@NonNull DynamicRuleMatch dynamicRuleMatch) {
            SerializationMetaData serializationMetaData = dynamicRuleMatch.getModelAnalysis().getSerializationMetaData();
            String ruleName = serializationMetaData.getGrammarRuleValue(this.calledRuleIndex).getRuleName();
            return "Incompatible/missing '" + ruleName + "' value for a '" + this.eStructuralFeature.getEContainingClass().getName() + "::" + this.eStructuralFeature.getName() + "'";
        }

        private boolean matchInnerValue(int thisSerializationStepIndex, @NonNull UserElementMatcher matcher) {
            UserModelAnalysis modelAnalysis = matcher.getModelAnalysis();
            Object eGet = matcher.consumeNext(this.eStructuralFeature, new int[]{this.calledRuleIndex});
            if (eGet == UserElementMatcher.NOT_AN_OBJECT) {
                matcher.setFailureStep(this);
                return false;
            }
            if (this.eStructuralFeature instanceof EReference) {
                assert (((EReference)this.eStructuralFeature).isContainment());
            } else {
                try {
                    SerializationMetaData serializationMetaData = modelAnalysis.getSerializationMetaData();
                    GrammarRuleValue grammarRuleValue = serializationMetaData.getGrammarRuleValue(this.calledRuleIndex);
                    String string = modelAnalysis.getValueConverterService().toString(eGet, grammarRuleValue.getRuleName());
                }
                catch (Throwable t) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public int matchOuterValue(int thisSerializationStepIndex, @NonNull UserElementMatcher matcher) {
            assert (matcher.getSerializationRule().getSerializationSteps()[thisSerializationStepIndex] == this);
            if (!this.matchInnerValue(thisSerializationStepIndex, matcher)) {
                assert (matcher.hasFailed()) : "No matcher failure for a " + this.getClass().getSimpleName();
                return -1;
            }
            return thisSerializationStepIndex + 1;
        }

        @Override
        public boolean matches(@NonNull INode node, @NonNull UserElementSerializer serializer) {
            EObject grammarElement;
            if (node instanceof LeafNode && (grammarElement = node.getGrammarElement()) instanceof RuleCall) {
                AbstractRule rule = ((RuleCall)grammarElement).getRule();
                GrammarRuleValue grammarRuleValue = serializer.getSerializationMetaData().getGrammarRuleValue(this.calledRuleIndex);
                return grammarRuleValue.getName().equals(rule.getName());
            }
            return false;
        }

        @Override
        public void serializeInnerValue(int thisSerializationStepIndex, @NonNull UserElementSerializer serializer, @NonNull SerializationBuilder serializationBuilder) {
            UserModelAnalysis modelAnalysis = serializer.getModelAnalysis();
            SerializationMetaData serializationMetaData = modelAnalysis.getSerializationMetaData();
            GrammarRuleValue grammarRuleValue = serializationMetaData.getGrammarRuleValue(this.calledRuleIndex);
            Object eGet = serializer.consumeNext(this.eStructuralFeature);
            if (this.eStructuralFeature instanceof EReference) {
                assert (((EReference)this.eStructuralFeature).isContainment());
                if (eGet != null) {
                    serializer.serializeElement(serializationBuilder, (EObject)eGet, (ParserRuleValue)grammarRuleValue);
                }
            } else if (grammarRuleValue instanceof DataTypeRuleValue) {
                DataTypeRuleValue dataTypeRuleValue = (DataTypeRuleValue)grammarRuleValue;
                String value = modelAnalysis.getValueConverterService().toString(eGet, grammarRuleValue.getRuleName()).trim();
                @NonNull SerializationSegment[] serializationSegments = dataTypeRuleValue.getSerializationSegments(value);
                int i = 0;
                SerializationSegment[] serializationSegmentArray = serializationSegments;
                int n = serializationSegments.length;
                int n2 = 0;
                while (n2 < n) {
                    SerializationSegment serializationSegment = serializationSegmentArray[n2];
                    if (serializationSegment instanceof SerializationSegment.ValueSerializationSegment) {
                        serializationBuilder.append(value);
                        DeclarativeSerializer.SERIALIZER_FRAGMENTS.println(String.valueOf(serializer.getModelAnalysis().getIndent(1)) + "assign: " + value);
                    } else {
                        serializationSegment.serialize(i, serializer, serializationBuilder);
                    }
                    ++i;
                    ++n2;
                }
            } else {
                String val = modelAnalysis.getValueConverterService().toString(eGet, grammarRuleValue.getRuleName());
                serializationBuilder.append(String.valueOf(val));
                DeclarativeSerializer.SERIALIZER_FRAGMENTS.println(String.valueOf(serializer.getModelAnalysis().getIndent(1)) + "assign: " + String.valueOf(val));
            }
        }

        @Override
        public void toStepString(@NonNull DiagnosticStringBuilder s) {
            s.append(SerializationUtils.getName((ENamedElement)SerializationUtils.getEContainingClass(this.eStructuralFeature)));
            s.append("::");
            s.append(SerializationUtils.getName((ENamedElement)this.eStructuralFeature));
            s.append(this.eStructuralFeature.isMany() ? "+=" : "=");
            s.appendRuleName(this.calledRuleIndex);
        }
    }

    public static class SerializationStepAssigns
    extends SerializationStepAbstractFeature {
        private @NonNull EnumerationValue enumerationValue;
        private int @NonNull [] calledRuleIndexes;

        public SerializationStepAssigns(@NonNull EStructuralFeature eStructuralFeature, @NonNull EnumerationValue enumerationValue, int @NonNull [] calledRuleIndexes, @NonNull SerializationSegment @Nullable [] serializationSegments) {
            super(eStructuralFeature, serializationSegments);
            this.enumerationValue = enumerationValue;
            this.calledRuleIndexes = calledRuleIndexes;
        }

        @Override
        public int computeHashCode() {
            int hashCode = super.computeHashCode() + this.enumerationValue.hashCode();
            int[] nArray = this.calledRuleIndexes;
            int n = this.calledRuleIndexes.length;
            int n2 = 0;
            while (n2 < n) {
                int calledRuleIndex = nArray[n2];
                hashCode += calledRuleIndex;
                ++n2;
            }
            return hashCode;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SerializationStepAssigns)) {
                return false;
            }
            return this.equalTo((SerializationStepAssigns)obj);
        }

        protected boolean equalTo(@NonNull SerializationStepAssigns that) {
            if (!super.equalTo(that)) {
                return false;
            }
            if (!this.enumerationValue.equals(that.enumerationValue)) {
                return false;
            }
            if (this.calledRuleIndexes.length != that.calledRuleIndexes.length) {
                return false;
            }
            int i = 0;
            while (i < this.calledRuleIndexes.length) {
                if (this.calledRuleIndexes[i] != that.calledRuleIndexes[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public int @NonNull [] getCalledRuleIndexes() {
            return this.calledRuleIndexes;
        }

        public @NonNull EnumerationValue getEnumerationValue() {
            return this.enumerationValue;
        }

        @Override
        public @NonNull String getFailureReason(@NonNull DynamicRuleMatch dynamicRuleMatch) {
            SerializationMetaData serializationMetaData = dynamicRuleMatch.getModelAnalysis().getSerializationMetaData();
            DiagnosticStringBuilder.SerializationMetaDataDiagnosticStringBuilder s = new DiagnosticStringBuilder.SerializationMetaDataDiagnosticStringBuilder(serializationMetaData);
            s.append("Incompatible/missing '");
            new GrammarRuleVector(this.calledRuleIndexes).toString(s);
            s.append("' value for a '");
            s.append(SerializationUtils.getName((ENamedElement)SerializationUtils.getEContainingClass(this.eStructuralFeature)));
            s.append("::");
            s.append(SerializationUtils.getName((ENamedElement)this.eStructuralFeature));
            s.append("'");
            return s.toString();
        }

        private boolean matchInnerValue(int thisSerializationStepIndex, @NonNull UserElementMatcher matcher) {
            Object object = matcher.consumeNext(this.eStructuralFeature, this.calledRuleIndexes);
            if (object == UserElementMatcher.NOT_AN_OBJECT) {
                matcher.setFailureStep(this);
                return false;
            }
            UserModelAnalysis modelAnalysis = matcher.getModelAnalysis();
            SerializationMetaData serializationMetaData = modelAnalysis.getSerializationMetaData();
            if (this.eStructuralFeature instanceof EAttribute) {
                EnumerationValue enumerationValue2 = this.enumerationValue;
                @NonNull String string = String.valueOf(object);
                if (enumerationValue2.isElement(string)) {
                    return true;
                }
                int[] nArray = this.calledRuleIndexes;
                int n = this.calledRuleIndexes.length;
                int n2 = 0;
                while (n2 < n) {
                    int calledRuleIndex = nArray[n2];
                    @NonNull GrammarRuleValue calledRuleValue = serializationMetaData.getGrammarRuleValue(calledRuleIndex);
                    try {
                        String val = modelAnalysis.getValueConverterService().toString(object, calledRuleValue.getRuleName());
                        return true;
                    }
                    catch (ValueConverterException valueConverterException) {
                        ++n2;
                    }
                }
            } else if (object != null) {
                EReference eReference = (EReference)this.eStructuralFeature;
                EObject eObject = (EObject)object;
                assert (eReference.isContainment());
                UserElementAnalysis elementAnalysis = modelAnalysis.getElementAnalysis(eObject);
                @NonNull SerializationRule @NonNull [] callableSerializationRules = elementAnalysis.getSerializationRules();
                int[] nArray = this.calledRuleIndexes;
                int n = this.calledRuleIndexes.length;
                int n3 = 0;
                while (n3 < n) {
                    int calledRuleIndex = nArray[n3];
                    @NonNull GrammarRuleValue calledRuleValue = serializationMetaData.getGrammarRuleValue(calledRuleIndex);
                    SerializationRule[] serializationRuleArray = ((ParserRuleValue)calledRuleValue).getSerializationRules();
                    int n4 = serializationRuleArray.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        SerializationRule calledSerializationRule = serializationRuleArray[n5];
                        SerializationRule[] serializationRuleArray2 = callableSerializationRules;
                        int n6 = callableSerializationRules.length;
                        int n7 = 0;
                        while (n7 < n6) {
                            SerializationRule callableSerializationRule = serializationRuleArray2[n7];
                            if (calledSerializationRule == callableSerializationRule) {
                                DynamicRuleMatch match = elementAnalysis.basicCreateDynamicRuleMatch(calledSerializationRule);
                                if (match == null) break;
                                return true;
                            }
                            ++n7;
                        }
                        ++n5;
                    }
                    ++n3;
                }
            }
            matcher.setFailureStep(this);
            return false;
        }

        @Override
        public int matchOuterValue(int thisSerializationStepIndex, @NonNull UserElementMatcher matcher) {
            assert (matcher.getSerializationRule().getSerializationSteps()[thisSerializationStepIndex] == this);
            if (!this.matchInnerValue(thisSerializationStepIndex, matcher)) {
                assert (matcher.hasFailed()) : "No matcher failure for a " + this.getClass().getSimpleName();
                return -1;
            }
            return thisSerializationStepIndex + 1;
        }

        @Override
        public boolean matches(@NonNull INode node, @NonNull UserElementSerializer serializer) {
            EObject grammarElement;
            if (node instanceof LeafNode && (grammarElement = node.getGrammarElement()) instanceof RuleCall) {
                AbstractRule rule = ((RuleCall)grammarElement).getRule();
                String ruleName = rule.getName();
                SerializationMetaData serializationMetaData = serializer.getSerializationMetaData();
                int[] nArray = this.calledRuleIndexes;
                int n = this.calledRuleIndexes.length;
                int n2 = 0;
                while (n2 < n) {
                    int calledRuleIndex = nArray[n2];
                    GrammarRuleValue grammarRuleValue = serializationMetaData.getGrammarRuleValue(calledRuleIndex);
                    if (grammarRuleValue.getName().equals(ruleName)) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }

        @Override
        public void serializeInnerValue(int thisSerializationStepIndex, @NonNull UserElementSerializer serializer, @NonNull SerializationBuilder serializationBuilder) {
            Object object = serializer.consumeNext(this.eStructuralFeature);
            UserModelAnalysis modelAnalysis = serializer.getModelAnalysis();
            SerializationMetaData serializationMetaData = modelAnalysis.getSerializationMetaData();
            if (this.eStructuralFeature instanceof EAttribute) {
                @NonNull String string = String.valueOf(object);
                if (this.enumerationValue.isElement(string)) {
                    serializationBuilder.append(string);
                    return;
                }
                int[] nArray = this.calledRuleIndexes;
                int n = this.calledRuleIndexes.length;
                int n2 = 0;
                while (n2 < n) {
                    int calledRuleIndex = nArray[n2];
                    @NonNull GrammarRuleValue calledRuleValue = serializationMetaData.getGrammarRuleValue(calledRuleIndex);
                    try {
                        String val = modelAnalysis.getValueConverterService().toString(object, calledRuleValue.getRuleName());
                        serializationBuilder.append(String.valueOf(val));
                        return;
                    }
                    catch (ValueConverterException valueConverterException) {
                        ++n2;
                    }
                }
                serializationBuilder.appendError("Failed to convert '" + String.valueOf(object) + "'");
            } else if (object != null) {
                EReference eReference = (EReference)this.eStructuralFeature;
                EObject eObject = (EObject)object;
                assert (eReference.isContainment());
                UserElementAnalysis elementAnalysis = modelAnalysis.getElementAnalysis(eObject);
                int[] nArray = this.calledRuleIndexes;
                int n = this.calledRuleIndexes.length;
                int n3 = 0;
                while (n3 < n) {
                    int calledRuleIndex = nArray[n3];
                    @NonNull GrammarRuleValue calledRuleValue = serializationMetaData.getGrammarRuleValue(calledRuleIndex);
                    SerializationRule[] serializationRuleArray = ((ParserRuleValue)calledRuleValue).getSerializationRules();
                    int n4 = serializationRuleArray.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        SerializationRule serializationRule = serializationRuleArray[n5];
                        DynamicRuleMatch match = elementAnalysis.basicCreateDynamicRuleMatch(serializationRule);
                        if (match != null) {
                            serializer.serializeElement(serializationBuilder, eObject, (ParserRuleValue)calledRuleValue);
                            return;
                        }
                        ++n5;
                    }
                    ++n3;
                }
                serializationBuilder.appendError("Failed to convert " + eObject.eClass().getName() + ": '" + String.valueOf(object) + "'");
            }
            DeclarativeSerializer.SERIALIZER_FRAGMENTS.println(String.valueOf(modelAnalysis.getIndent(1)) + "assigns: ???");
        }

        @Override
        public void toStepString(@NonNull DiagnosticStringBuilder s) {
            s.append(SerializationUtils.getName((ENamedElement)SerializationUtils.getEContainingClass(this.eStructuralFeature)));
            s.append("::");
            s.append(SerializationUtils.getName((ENamedElement)this.eStructuralFeature));
            s.append(this.eStructuralFeature.isMany() ? "+=" : "=");
            boolean isFirst = true;
            int[] nArray = this.calledRuleIndexes;
            int n = this.calledRuleIndexes.length;
            int n2 = 0;
            while (n2 < n) {
                int calledRuleIndex = nArray[n2];
                if (!isFirst) {
                    s.append("|");
                }
                s.appendRuleName(calledRuleIndex);
                isFirst = false;
                ++n2;
            }
        }
    }

    public static class SerializationStepCrossReference
    extends SerializationStepAbstractFeature {
        protected final @NonNull CrossReference crossReference;
        protected final int calledRuleIndex;

        public SerializationStepCrossReference(@NonNull EStructuralFeature eStructuralFeature, @NonNull CrossReference crossReference, int calledRuleIndex, @NonNull SerializationSegment @Nullable [] serializationSegments) {
            super(eStructuralFeature, serializationSegments);
            assert (eStructuralFeature != null);
            this.crossReference = crossReference;
            this.calledRuleIndex = calledRuleIndex;
        }

        @Override
        public int computeHashCode() {
            int hash = super.computeHashCode();
            AbstractElement terminal = this.crossReference.getTerminal();
            hash = terminal instanceof RuleCall ? (hash += ((RuleCall)terminal).getRule().getName().hashCode()) : (hash += terminal.hashCode());
            return hash;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SerializationStepCrossReference)) {
                return false;
            }
            return this.equalTo((SerializationStepCrossReference)obj);
        }

        protected boolean equalTo(@NonNull SerializationStepCrossReference that) {
            if (!super.equalTo(that)) {
                return false;
            }
            AbstractElement thisTerminal = this.crossReference.getTerminal();
            AbstractElement thatTerminal = that.crossReference.getTerminal();
            if (thisTerminal instanceof RuleCall && thatTerminal instanceof RuleCall) {
                return ((RuleCall)thisTerminal).getRule() == ((RuleCall)thatTerminal).getRule();
            }
            return ClassUtil.safeEquals((Object)thisTerminal, (Object)thatTerminal);
        }

        public int getCalledRuleIndex() {
            return this.calledRuleIndex;
        }

        public @NonNull CrossReference getCrossReference() {
            return this.crossReference;
        }

        @Override
        public @NonNull String getFailureReason(@NonNull DynamicRuleMatch dynamicRuleMatch) {
            SerializationMetaData serializationMetaData = dynamicRuleMatch.getModelAnalysis().getSerializationMetaData();
            String ruleName = serializationMetaData.getGrammarRuleValue(this.calledRuleIndex).getRuleName();
            return "Incompatible/missing '" + ruleName + "' value for a '" + this.eStructuralFeature.getEContainingClass().getName() + "::" + this.eStructuralFeature.getName() + "'";
        }

        @Override
        public int matchOuterValue(int thisSerializationStepIndex, @NonNull UserElementMatcher matcher) {
            assert (matcher.getSerializationRule().getSerializationSteps()[thisSerializationStepIndex] == this);
            Object object = matcher.consumeNext(this.eStructuralFeature, new int[]{this.calledRuleIndex});
            if (object == UserElementMatcher.NOT_AN_OBJECT) {
                matcher.setFailureStep(this);
                assert (matcher.hasFailed()) : "No matcher failure for a " + this.getClass().getSimpleName();
                return -1;
            }
            return thisSerializationStepIndex + 1;
        }

        @Override
        public boolean matches(@NonNull INode node, @NonNull UserElementSerializer serializer) {
            EObject grammarContainer;
            EObject grammarElement;
            if (node instanceof LeafNode && (grammarElement = node.getGrammarElement()) instanceof CrossReference && (grammarContainer = grammarElement.eContainer()) instanceof Assignment) {
                EStructuralFeature eStructuralFeature = SerializationUtils.getEStructuralFeature((Assignment)grammarContainer);
                return eStructuralFeature == this.eStructuralFeature;
            }
            return false;
        }

        @Override
        public void serializeInnerValue(int thisSerializationStepIndex, @NonNull UserElementSerializer serializer, @NonNull SerializationBuilder serializationBuilder) {
            EObject eGet = (EObject)serializer.consumeNext(this.eStructuralFeature);
            EObject context = serializer.getElement();
            String string = serializer.getModelAnalysis().getCrossReferenceSerializer().serializeCrossRef(context, this.crossReference, eGet, null, null);
            serializationBuilder.append(string);
            DeclarativeSerializer.SERIALIZER_FRAGMENTS.println(String.valueOf(serializer.getModelAnalysis().getIndent(1)) + "xref ???: ");
        }

        @Override
        public void toStepString(@NonNull DiagnosticStringBuilder s) {
            s.append(SerializationUtils.getName((ENamedElement)SerializationUtils.getEContainingClass(this.eStructuralFeature)));
            s.append("::");
            s.append(SerializationUtils.getName((ENamedElement)this.eStructuralFeature));
            s.append(this.eStructuralFeature.isMany() ? "+=" : "=");
            s.append(SerializationUtils.getName(SerializationUtils.getRule((RuleCall)SerializationUtils.getTerminal(this.crossReference))));
        }
    }

    public static class SerializationStepKeyword
    extends SerializationStep {
        protected final @NonNull String keyword;

        public SerializationStepKeyword(@NonNull String keyword, @NonNull SerializationSegment @Nullable [] serializationSegments) {
            super(serializationSegments);
            this.keyword = keyword;
        }

        @Override
        public int computeHashCode() {
            return super.computeHashCode() + 5 * this.keyword.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SerializationStepKeyword)) {
                return false;
            }
            return this.equalTo((SerializationStepKeyword)obj);
        }

        protected boolean equalTo(@NonNull SerializationStepKeyword that) {
            return super.equalTo(that) && this.keyword.equals(that.keyword);
        }

        @Override
        public @NonNull String getFailureReason(@NonNull DynamicRuleMatch dynamicRuleMatch) {
            throw new IllegalStateException();
        }

        @Override
        public @NonNull String getGlobalSortKey(@NonNull Map<@NonNull List<@NonNull SerializationSegment>, @Nullable Integer> serializationSegments2id) {
            StringBuilder s = new StringBuilder();
            s.append("k-");
            s.append(this.keyword);
            this.getGlobalSortKey(s, serializationSegments2id);
            return s.toString();
        }

        public @NonNull String getKeyword() {
            return this.keyword;
        }

        @Override
        public int matchOuterValue(int thisSerializationStepIndex, @NonNull UserElementMatcher matcher) {
            assert (matcher.getSerializationRule().getSerializationSteps()[thisSerializationStepIndex] == this);
            return thisSerializationStepIndex + 1;
        }

        @Override
        public boolean matches(@NonNull INode node, @NonNull UserElementSerializer serializer) {
            EObject grammarElement;
            if (node instanceof LeafNode && (grammarElement = node.getGrammarElement()) instanceof Keyword) {
                String value = ((Keyword)grammarElement).getValue();
                return this.keyword.equals(value);
            }
            return false;
        }

        @Override
        public void serializeInnerValue(int thisSerializationStepIndex, @NonNull UserElementSerializer serializer, @NonNull SerializationBuilder serializationBuilder) {
            serializationBuilder.append(this.keyword);
            DeclarativeSerializer.SERIALIZER_FRAGMENTS.println(String.valueOf(serializer.getModelAnalysis().getIndent(1)) + "keyword: '" + this.keyword + "'");
        }

        @Override
        public void toStepString(@NonNull DiagnosticStringBuilder s) {
            @NonNull String javaString = Strings.convertToJavaString((String)this.keyword);
            s.append("'");
            s.append(javaString);
            s.append("'");
        }
    }

    public static class SerializationStepSequence
    extends SerializationStep {
        protected final int variableIndex;
        protected final @NonNull GrammarCardinality grammarCardinality;
        private int stepsRange = 0;

        public SerializationStepSequence(int variableIndex, int stepsRange, @NonNull GrammarCardinality grammarCardinality, @NonNull SerializationSegment @Nullable [] serializationSegments) {
            super(serializationSegments);
            this.variableIndex = variableIndex;
            this.grammarCardinality = grammarCardinality;
            this.stepsRange = stepsRange;
            assert (variableIndex >= 0 || serializationSegments != null);
        }

        @Override
        public int computeHashCode() {
            return this.getClass().hashCode() + 3 * this.variableIndex + 5 * this.stepsRange + 7 * this.grammarCardinality.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SerializationStepSequence)) {
                return false;
            }
            return this.equalTo((SerializationStepSequence)obj);
        }

        protected boolean equalTo(@NonNull SerializationStepSequence that) {
            return super.equalTo(that) && this.variableIndex == that.variableIndex && this.stepsRange == that.stepsRange && this.grammarCardinality == that.grammarCardinality;
        }

        @Override
        public @NonNull String getFailureReason(@NonNull DynamicRuleMatch dynamicRuleMatch) {
            throw new IllegalStateException();
        }

        @Override
        public @NonNull String getGlobalSortKey(@NonNull Map<@NonNull List<@NonNull SerializationSegment>, @Nullable Integer> serializationSegments2id) {
            StringBuilder s = new StringBuilder();
            s.append("s-");
            s.append(this.variableIndex);
            s.append("-");
            s.append(this.stepsRange);
            s.append("-");
            s.append(this.grammarCardinality.ordinal());
            this.getGlobalSortKey(s, serializationSegments2id);
            return s.toString();
        }

        public @NonNull GrammarCardinality getGrammarCardinality() {
            return this.grammarCardinality;
        }

        public int getStepsRange() {
            return this.stepsRange;
        }

        public int getVariableIndex() {
            return this.variableIndex;
        }

        private boolean matchInnerValue(int thisSerializationStepIndex, @NonNull UserElementMatcher matcher) {
            @NonNull SerializationStep[] serializationSteps = matcher.getSerializationRule().getSerializationSteps();
            assert (serializationSteps[thisSerializationStepIndex] == this);
            int startIndex = thisSerializationStepIndex + 1;
            int endIndex = startIndex + this.stepsRange;
            int index = startIndex;
            while (index < endIndex) {
                SerializationStep serializationStep = serializationSteps[index];
                if ((index = serializationStep.matchOuterValue(index, matcher)) >= startIndex) continue;
                assert (matcher.hasFailed());
                return false;
            }
            return true;
        }

        private int matchNextValue(int thisSerializationStepIndex, UserElementMatcher matcher, int matchedCount) {
            boolean matches;
            matcher.push();
            boolean bl = matches = this.matchInnerValue(thisSerializationStepIndex, matcher) && matcher.hasProgressed();
            if (matches) {
                matchedCount = this.matchNextValue(thisSerializationStepIndex, matcher, matchedCount + 1);
            }
            matcher.pop(matches);
            return matchedCount;
        }

        @Override
        public int matchOuterValue(int thisSerializationStepIndex, @NonNull UserElementMatcher matcher) {
            Integer knownValue = this.variableIndex < 0 ? Integer.valueOf(-this.variableIndex) : matcher.basicGetValue(this.variableIndex);
            if (knownValue != null) {
                if (!this.matchInnerValue(thisSerializationStepIndex, matcher)) assert (matcher.hasFailed()) : "No matcher failure for a " + this.getClass().getSimpleName();
            } else {
                int matchedCount = this.matchNextValue(thisSerializationStepIndex, matcher, 0);
                matcher.setValue(this.variableIndex, matchedCount);
            }
            return thisSerializationStepIndex + 1 + this.stepsRange;
        }

        @Override
        public boolean matches(@NonNull INode node, @NonNull UserElementSerializer serializer) {
            return false;
        }

        @Override
        public void serializeInnerValue(int thisSerializationStepIndex, @NonNull UserElementSerializer serializer, @NonNull SerializationBuilder serializationBuilder) {
            @NonNull SerializationStep[] serializationSteps = serializer.getSerializationRule().getSerializationSteps();
            assert (serializationSteps[thisSerializationStepIndex] == this);
            int startIndex = thisSerializationStepIndex + 1;
            int endIndex = startIndex + this.stepsRange;
            int stepLoopCount = this.variableIndex >= 0 ? serializer.getValue(this.variableIndex) : 1;
            boolean isTracing = DeclarativeSerializer.SERIALIZER_FRAGMENTS.isActive();
            int i = 0;
            while (i < stepLoopCount) {
                int index = startIndex;
                while (index < endIndex) {
                    SerializationStep serializationStep = serializationSteps[index];
                    if (isTracing) {
                        DeclarativeSerializer.SERIALIZER_FRAGMENTS.println(String.valueOf(serializer.getModelAnalysis().getIndent()) + "sub-step: " + serializationStep);
                    }
                    index = serializationStep.serializeOuterValue(index, serializer, serializationBuilder);
                }
                ++i;
            }
        }

        @Override
        public int serializeOuterValue(int thisSerializationStepIndex, @NonNull UserElementSerializer serializer, @NonNull SerializationBuilder serializationBuilder) {
            if (this.variableIndex < 0 || serializer.getValue(this.variableIndex) > 0) {
                super.serializeOuterValue(thisSerializationStepIndex, serializer, serializationBuilder);
            }
            return thisSerializationStepIndex + 1 + this.stepsRange;
        }

        public void setStepsRange(int stepsRange) {
            assert (stepsRange >= 0);
            assert (this.basicGetHashCode() == null);
            this.stepsRange = stepsRange;
        }

        @Override
        public void toStepString(@NonNull DiagnosticStringBuilder s) {
            @NonNull String rangeString = Integer.toString(this.stepsRange);
            if (this.variableIndex >= 0) {
                s.appendWithFormat("V%02d", this.variableIndex);
            } else {
                s.append("1");
            }
            s.append("*");
            s.append(rangeString);
            s.append("-steps");
        }
    }

    public static class SerializationStepWrapper
    extends SerializationStep {
        public SerializationStepWrapper(@NonNull SerializationSegment @NonNull [] serializationSegments) {
            super(serializationSegments);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SerializationStepWrapper)) {
                return false;
            }
            return this.equalTo((SerializationStepWrapper)obj);
        }

        @Override
        public @NonNull String getFailureReason(@NonNull DynamicRuleMatch dynamicRuleMatch) {
            throw new IllegalStateException();
        }

        @Override
        public @NonNull String getGlobalSortKey(@NonNull Map<@NonNull List<@NonNull SerializationSegment>, @Nullable Integer> serializationSegments2id) {
            StringBuilder s = new StringBuilder();
            s.append("w");
            this.getGlobalSortKey(s, serializationSegments2id);
            return s.toString();
        }

        @Override
        public int matchOuterValue(int thisSerializationStepIndex, @NonNull UserElementMatcher matcher) {
            assert (matcher.getSerializationRule().getSerializationSteps()[thisSerializationStepIndex] == this);
            return thisSerializationStepIndex + 1;
        }

        @Override
        public boolean matches(@NonNull INode node, @NonNull UserElementSerializer serializer) {
            return node instanceof CompositeNodeWithSemanticElement;
        }

        @Override
        public void serializeInnerValue(int thisSerializationStepIndex, @NonNull UserElementSerializer serializer, @NonNull SerializationBuilder serializationBuilder) {
            boolean isTracing = DeclarativeSerializer.SERIALIZER_FRAGMENTS.isActive();
            @NonNull SerializationStep[] serializationSteps = serializer.getSerializationRule().getSerializationSteps();
            int index = 1;
            while (index < serializationSteps.length) {
                SerializationStep serializationStep = serializationSteps[index];
                if (isTracing) {
                    DeclarativeSerializer.SERIALIZER_FRAGMENTS.println(String.valueOf(serializer.getModelAnalysis().getIndent()) + "step: " + serializationStep);
                }
                index = serializationStep.serializeOuterValue(index, serializer, serializationBuilder);
            }
        }

        @Override
        public int serializeOuterValue(int thisSerializationStepIndex, @NonNull UserElementSerializer serializer, @NonNull SerializationBuilder serializationBuilder) {
            SerializationRule serializationRule = serializer.getSerializationRule();
            assert (thisSerializationStepIndex == 0);
            assert (serializationRule.getSerializationSteps()[thisSerializationStepIndex] == this);
            assert (this.serializationSegments != null);
            SerializationSegment[] serializationSegmentArray = this.serializationSegments;
            int n = this.serializationSegments.length;
            int n2 = 0;
            while (n2 < n) {
                SerializationSegment serializationSegment = serializationSegmentArray[n2];
                serializationSegment.serialize(0, serializer, serializationBuilder);
                ++n2;
            }
            return serializationRule.getSerializationSteps().length;
        }

        @Override
        public void toStepString(@NonNull DiagnosticStringBuilder s) {
            s.append("wrapper");
        }
    }
}

