/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde.target;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Properties;
import java.util.function.Function;
import org.apache.maven.RepositoryUtils;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.impl.SyncContextFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.pde.target.BNDInstructions;
import org.eclipse.m2e.pde.target.MavenTargetLocation;
import org.eclipse.m2e.pde.target.MissingMetadataMode;
import org.eclipse.m2e.pde.target.shared.MavenBundleWrapper;
import org.eclipse.m2e.pde.target.shared.ProcessingMessage;
import org.eclipse.m2e.pde.target.shared.WrappedBundle;
import org.eclipse.pde.core.target.TargetBundle;

public class MavenTargetBundle
extends TargetBundle {
    private static final ILog LOGGER = Platform.getLog(MavenTargetBundle.class);
    private TargetBundle bundle;
    private IStatus status;
    private final BundleInfo bundleInfo;
    private boolean isWrapped;
    private Artifact artifact;

    public BundleInfo getBundleInfo() {
        if (this.bundle == null) {
            return this.bundleInfo;
        }
        return this.bundle.getBundleInfo();
    }

    public boolean isSourceBundle() {
        return this.bundle != null && this.bundle.isSourceBundle();
    }

    public BundleInfo getSourceTarget() {
        if (this.bundle == null) {
            return null;
        }
        return this.bundle.getSourceTarget();
    }

    public boolean isFragment() {
        return this.bundle != null && this.bundle.isFragment();
    }

    public String getSourcePath() {
        if (this.bundle == null) {
            return null;
        }
        return this.bundle.getSourcePath();
    }

    public MavenTargetBundle(Artifact artifact, MavenTargetLocation location, IProgressMonitor monitor) {
        this.artifact = artifact;
        File file = artifact.getFile();
        this.bundleInfo = new BundleInfo(artifact.getGroupId() + "." + artifact.getArtifactId(), artifact.getVersion(), file != null ? file.toURI() : null, -1, false);
        try {
            this.bundle = new TargetBundle(file);
        }
        catch (Exception ex) {
            MissingMetadataMode metadataMode = location.getMetadataMode();
            if (metadataMode == MissingMetadataMode.ERROR) {
                this.status = Status.error((String)(String.valueOf(artifact) + " is not a bundle"), (Throwable)ex);
                LOGGER.log(this.status);
            }
            if (metadataMode == MissingMetadataMode.GENERATE) {
                try {
                    this.bundle = MavenTargetBundle.getWrappedArtifact(artifact, location, monitor);
                    this.isWrapped = true;
                }
                catch (Exception e) {
                    String message = String.valueOf(artifact) + " is not a bundle and cannot be automatically bundled as such ";
                    if (e.getMessage() != null) {
                        message = message + " (" + e.getMessage() + ")";
                    }
                    this.status = Status.error((String)message, (Throwable)e);
                    LOGGER.log(this.status);
                }
            }
            this.status = Status.CANCEL_STATUS;
            LOGGER.log(this.status);
        }
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    private static TargetBundle getWrappedArtifact(Artifact artifact, MavenTargetLocation location, IProgressMonitor monitor) throws Exception {
        IMaven maven = MavenPlugin.getMaven();
        List repositories = RepositoryUtils.toRepos(location.getAvailableArtifactRepositories(maven));
        Function<DependencyNode, Properties> instructionsLookup = node -> {
            BNDInstructions instructions = location.getInstructionsForArtifact(node.getArtifact());
            return instructions == null ? BNDInstructions.getDefaultInstructionProperties() : instructions.asProperties();
        };
        IMavenExecutionContext exeContext = IMavenExecutionContext.getThreadContext().orElseGet(() -> ((IMaven)maven).createExecutionContext());
        final MultiStatus bundleStatus = new MultiStatus(MavenTargetBundle.class, 0, "Some problems where detected while wrapping " + String.valueOf(artifact));
        Path wrappedBundle = (Path)exeContext.execute((context, monitor1) -> {
            RepositorySystem repoSystem = MavenPluginActivator.getDefault().getRepositorySystem();
            RepositorySystemSession repositorySession = context.getRepositorySession();
            try {
                WrappedBundle wrap = MavenBundleWrapper.getWrappedArtifact(artifact, instructionsLookup, repositories, repoSystem, repositorySession, (SyncContextFactory)context.getComponentLookup().lookup(SyncContextFactory.class));
                List<ProcessingMessage> directErrors = wrap.messages(false).filter(msg -> msg.type() == ProcessingMessage.Type.ERROR).toList();
                if (directErrors.isEmpty()) {
                    wrap.messages(true).map(ProcessingMessage::message).distinct().forEach(msg -> bundleStatus.add(Status.warning((String)msg)));
                    return wrap.getFile().get();
                }
                if (directErrors.size() == 1) {
                    throw new CoreException(Status.error((String)directErrors.get(0).message()));
                }
                MultiStatus multiStatus2 = new MultiStatus(MavenTargetBundle.class, 4, "wrapping artifact " + artifact.getArtifactId() + " failed!");
                for (ProcessingMessage message : directErrors) {
                    multiStatus2.add(Status.error((String)message.message()));
                }
                throw new CoreException((IStatus)multiStatus2);
            }
            catch (CoreException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CoreException(Status.error((String)"Can't collect dependencies!", (Throwable)e));
            }
        }, monitor);
        TargetBundle bundle = new TargetBundle(wrappedBundle.toFile()){

            public IStatus getStatus() {
                bundleStatus.isOK();
                return super.getStatus();
            }
        };
        return bundle;
    }

    public boolean isWrapped() {
        return this.isWrapped;
    }

    public IStatus getStatus() {
        if (this.bundle == null) {
            if (this.status == null) {
                return Status.OK_STATUS;
            }
            return this.status;
        }
        return this.bundle.getStatus();
    }

    public int hashCode() {
        return this.getBundleInfo().hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        Object object = obj;
        if (object instanceof MavenTargetBundle) {
            void other;
            MavenTargetBundle mavenTargetBundle = (MavenTargetBundle)((Object)object);
            MavenTargetBundle cfr_ignored_0 = (MavenTargetBundle)((Object)object);
            if (this.getBundleInfo().equals((Object)other.getBundleInfo())) {
                return true;
            }
        }
        return false;
    }
}

