/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.libhover;

import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.ui.ICHelpBook;
import org.eclipse.cdt.ui.ICHelpProvider;
import org.eclipse.cdt.ui.ICHelpResourceDescriptor;
import org.eclipse.cdt.ui.IFunctionSummary;
import org.eclipse.cdt.ui.IRequiredInclude;
import org.eclipse.cdt.ui.text.ICHelpInvocationContext;
import org.eclipse.cdt.ui.text.IContentAssistHelpInvocationContext;
import org.eclipse.cdt.ui.text.IHoverHelpInvocationContext;
import org.eclipse.cdt.ui.text.SharedASTJob;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.IHelpResource;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IRegion;
import org.eclipse.linuxtools.cdt.libhover.ClassInfo;
import org.eclipse.linuxtools.cdt.libhover.FunctionInfo;
import org.eclipse.linuxtools.cdt.libhover.HelpBook;
import org.eclipse.linuxtools.cdt.libhover.LibHoverInfo;
import org.eclipse.linuxtools.cdt.libhover.LibhoverPlugin;
import org.eclipse.linuxtools.cdt.libhover.MemberInfo;
import org.eclipse.linuxtools.internal.cdt.libhover.LibHoverLibrary;

public class LibHover
implements ICHelpProvider {
    public static final String LIBHOVER_DOC_EXTENSION = "org.eclipse.linuxtools.cdt.libhover.library";
    private static ConcurrentHashMap<ICHelpBook, LibHoverLibrary> libraries = new ConcurrentHashMap();
    static final String[] constructTypes = new String[]{"dtype", "enum", "function", "groupsynopsis", "struct", "type", "union"};
    static final int dtypeIndex = 0;
    static final int enumIndex = 1;
    static final int functionIndex = 2;
    static final int groupsynopsisIndex = 3;
    static final int structIndex = 4;
    static final int typeIndex = 5;
    static final int unionIndex = 6;
    private static ArrayList<ICHelpBook> helpBooks = new ArrayList();
    private static Map<String, ICHelpBook> helpBooksMap = new HashMap<String, ICHelpBook>();
    public static boolean docsFetched = false;

    public static Collection<LibHoverLibrary> getLibraries() {
        return libraries.values();
    }

    public static void saveLibraries(IPath locationBase, IPreferenceStore ps) {
        if (ps.getBoolean("org.eclipse.linuxtools.cdt.libhover.cacheExtLibhover")) {
            for (LibHoverLibrary l : libraries.values()) {
                try {
                    IPath locationDir = locationBase;
                    locationDir = l.isCPP() ? locationBase.append("CPP") : locationBase.append("C");
                    File lDir = new File(locationDir.toOSString());
                    lDir.mkdir();
                    IPath location = locationDir.append(LibHover.getTransformedName(l.getName()) + ".libhover");
                    File target = new File(location.toOSString());
                    if (target.exists()) continue;
                    try (FileOutputStream f = new FileOutputStream(locationDir.append("tmpFile").toOSString());
                         ObjectOutputStream out = new ObjectOutputStream(f);){
                        out.writeObject(l.getHoverInfo());
                        out.close();
                        File tmp = new File(locationDir.append("tmpFile").toOSString());
                        tmp.renameTo(target);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static synchronized void getLibHoverDocs() {
        if (docsFetched) {
            return;
        }
        libraries.clear();
        helpBooks.clear();
        helpBooksMap.clear();
        IPreferenceStore ps = LibhoverPlugin.getDefault().getPreferenceStore();
        if (ps.getBoolean("org.eclipse.linuxtools.cdt.libhover.cacheExtLibhover")) {
            IFileStore cppDir;
            IPath stateLocation = LibhoverPlugin.getDefault().getStateLocation();
            IFileSystem fs = EFS.getLocalFileSystem();
            IPath CLibraryLocation = stateLocation.append("C");
            IPath CPPLibraryLocation = stateLocation.append("CPP");
            IFileStore cDir = fs.getStore(CLibraryLocation);
            if (cDir.fetchInfo().exists()) {
                LibHover.getCachedLibraries(cDir, "C");
            }
            if ((cppDir = fs.getStore(CPPLibraryLocation)).fetchInfo().exists()) {
                LibHover.getCachedLibraries(cppDir, "C++");
            }
        }
        IExtensionRegistry x = RegistryFactory.getRegistry();
        IConfigurationElement[] ces = x.getConfigurationElementsFor(LIBHOVER_DOC_EXTENSION);
        for (int i = 0; i < ces.length; ++i) {
            IConfigurationElement ce = ces[i];
            if (!ce.getName().equals("library")) continue;
            String location = ce.getAttribute("location");
            String name = ce.getAttribute("name");
            String helpdocs = ce.getAttribute("docs");
            String type = ce.getAttribute("type");
            String nameSpace = ce.getContributor().getName();
            ICHelpBook book = helpBooksMap.get(name);
            if (book == null) {
                HelpBook h = new HelpBook(name, type);
                helpBooks.add(h);
                helpBooksMap.put(name, h);
                LibHoverLibrary l = new LibHoverLibrary(name, location, helpdocs, nameSpace, "C++".equals(type));
                libraries.put(h, l);
            } else {
                LibHoverLibrary l = libraries.get(book);
                if (l != null) {
                    l.setDocs(helpdocs);
                }
            }
            docsFetched = true;
        }
    }

    private static String getTransformedName(String name) {
        return name.replaceAll("\\s", "_");
    }

    private static String getCleanName(String name) {
        return name.replaceAll("_", " ");
    }

    private static void getCachedLibraries(IFileStore dir, String type) {
        try {
            boolean isCPP = type.equals("C++");
            IFileStore[] files = dir.childStores(0, null);
            for (int i = 0; i < files.length; ++i) {
                File f;
                IFileStore file = files[i];
                String fileName = file.fetchInfo().getName();
                if (!fileName.endsWith(".libhover") || (f = file.toLocalFile(0, null)) == null) continue;
                String name = LibHover.getCleanName(fileName.substring(0, fileName.length() - 9));
                HelpBook h = new HelpBook(name, type);
                helpBooks.add(h);
                helpBooksMap.put(name, h);
                String location = file.toURI().toString();
                LibHoverLibrary l = new LibHoverLibrary(name, location, null, null, isCPP);
                libraries.put(h, l);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public LibHover() {
        LibHover.getLibHoverDocs();
    }

    public void initialize() {
        LibHover.getLibHoverDocs();
    }

    public ICHelpBook[] getCHelpBooks() {
        ICHelpBook[] chelpbooks = new ICHelpBook[helpBooks.size()];
        return helpBooks.toArray(chelpbooks);
    }

    public IFunctionSummary getFunctionInfo(ICHelpInvocationContext context, ICHelpBook[] helpBooks, String name) {
        ICPPFunctionType methodType;
        String className;
        IFunctionSummary f;
        block12: {
            f = null;
            ITranslationUnit t = context.getTranslationUnit();
            className = null;
            methodType = null;
            if (t.isCXXLanguage()) {
                try {
                    IBinding binding;
                    if (!(context instanceof IHoverHelpInvocationContext)) break block12;
                    IRegion region = ((IHoverHelpInvocationContext)context).getHoverRegion();
                    IASTName[] result = new IASTName[]{null};
                    EnclosingASTNameJob job = new EnclosingASTNameJob(t, region.getOffset(), region.getLength());
                    job.schedule();
                    try {
                        job.join();
                    }
                    catch (InterruptedException e) {
                        return null;
                    }
                    if (job.getResult() == Status.OK_STATUS) {
                        result[0] = job.getASTName();
                    }
                    if (result[0] != null && (binding = result[0].getBinding()) instanceof ICPPFunction) {
                        ICPPFunction cppfunction = (ICPPFunction)binding;
                        methodType = cppfunction.getType();
                        IBinding owner = cppfunction.getOwner();
                        if (owner instanceof ICPPClassType) {
                            ICPPClassType classType = (ICPPClassType)owner;
                            className = this.getClassName(classType);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }
        for (int i = 0; i < helpBooks.length; ++i) {
            LibHoverLibrary l = libraries.get(helpBooks[i]);
            if (name == null) continue;
            if (className != null) {
                if (l.isCPP()) {
                    f = this.getMemberSummary(l, className, name, methodType);
                }
            } else {
                f = this.getFunctionSummary(l, name);
            }
            if (f == null) continue;
            return f;
        }
        return null;
    }

    private String getClassName(ICPPClassType c) {
        Object className = null;
        try {
            String[] qualified = c.getQualifiedName();
            className = qualified[0];
            for (int k = 1; k < qualified.length; ++k) {
                className = (String)className + "::" + qualified[k];
            }
            if (c instanceof ICPPTemplateInstance) {
                ICPPTemplateInstance ti = (ICPPTemplateInstance)c;
                ICPPTemplateParameterMap tiMap = ti.getTemplateParameterMap();
                ICPPTemplateDefinition td = ti.getTemplateDefinition();
                ICPPTemplateParameter[] templateArgs = td.getTemplateParameters();
                className = (String)className + "<";
                String separator = "";
                for (int x = 0; x < templateArgs.length; ++x) {
                    ICPPTemplateParameter tp = templateArgs[x];
                    ICPPTemplateArgument ta = tiMap.getArgument(tp);
                    IType type = null;
                    type = ta.isTypeValue() ? ta.getTypeValue() : ta.getTypeOfNonTypeValue();
                    if (tp.getTemplateNestingLevel() != 0) continue;
                    className = type instanceof ICPPClassType ? (String)className + separator + this.getClassName((ICPPClassType)type) : (String)className + separator + type.toString();
                    separator = ",";
                }
                className = (String)className + ">";
            }
        }
        catch (DOMException e) {
            return null;
        }
        return className;
    }

    private IFunctionSummary getFunctionSummary(LibHoverLibrary l, String name) {
        FunctionInfo x = l.getFunctionInfo(name);
        if (x != null) {
            FunctionSummary f = new FunctionSummary();
            f.ReturnType = x.getReturnType();
            f.Prototype = x.getPrototype();
            f.Summary = x.getDescription();
            f.Name = x.getName();
            ArrayList<String> headers = x.getHeaders();
            for (int i = 0; i < headers.size(); ++i) {
                f.setIncludeName(headers.get(i));
            }
            return f;
        }
        return null;
    }

    private IFunctionSummary getMemberSummary(LibHoverLibrary l, String className, String memberName, ICPPFunctionType methodType) {
        MemberInfo member;
        ArrayList<String> templateTypes = new ArrayList<String>();
        ClassInfo info = l.getClassInfo(className, templateTypes);
        String[] args = new String[]{};
        IType returnType = null;
        if (info == null) {
            return null;
        }
        if (methodType != null) {
            try {
                args = this.resolveArgs(info, methodType.getParameterTypes(), templateTypes);
                returnType = methodType.getReturnType();
            }
            catch (Exception e) {
                return null;
            }
        }
        if ((member = info.getMember(memberName)) != null) {
            MemberInfo m = null;
            if (!this.isParmMatch(member, args, templateTypes, info)) {
                ArrayList<MemberInfo> members = member.getChildren();
                for (int i = 0; i < members.size(); ++i) {
                    MemberInfo k = members.get(i);
                    if (!this.isParmMatch(k, args, templateTypes, info)) continue;
                    m = k;
                    break;
                }
            } else {
                m = member;
            }
            if (m != null) {
                FunctionSummary f = new FunctionSummary();
                f.ReturnType = m.getReturnType();
                f.Prototype = m.getPrototype();
                f.Summary = m.getDescription();
                f.Name = className + "::" + memberName;
                String[] templateParms = info.getTemplateParms();
                for (int i = 0; i < templateTypes.size(); ++i) {
                    f.ReturnType = f.ReturnType.replaceAll(templateParms[i], templateTypes.get(i));
                    f.Prototype = f.Prototype.replaceAll(templateParms[i], templateTypes.get(i));
                    f.Name = f.Name.replaceAll(templateParms[i], templateTypes.get(i));
                }
                if (f.ReturnType.indexOf(60) >= 0) {
                    f.ReturnType = f.ReturnType.replaceAll("<", "&lt;");
                    f.ReturnType = f.ReturnType.replaceAll(">", "&gt;");
                }
                if (f.Prototype.indexOf(60) >= 0) {
                    f.Prototype = f.Prototype.replaceAll("<", "&lt;");
                    f.Prototype = f.Prototype.replaceAll(">", "&gt;");
                }
                if (f.Name.indexOf(60) >= 0) {
                    f.Name = f.Name.replaceAll("<", "&lt;");
                    f.Name = f.Name.replaceAll(">", "&gt;");
                }
                f.setPrototypeHasBrackets(true);
                f.setIncludeName(info.getInclude());
                return f;
            }
        }
        return null;
    }

    private boolean isParmMatch(MemberInfo m, String[] args, ArrayList<String> templateTypes, ClassInfo info) {
        Object[] memberParms = m.getParamTypes();
        String className = info.getClassName();
        int index = className.lastIndexOf("::");
        String unqualifiedName = className.substring(index + 2);
        for (int i = 0; i < memberParms.length; ++i) {
            String[] templateParms = info.getTemplateParms();
            for (int j = 0; j < templateTypes.size(); ++j) {
                memberParms[i] = ((String)memberParms[i]).replaceAll(templateParms[j], templateTypes.get(j));
            }
            if (!((String)memberParms[i]).contains(unqualifiedName) || ((String)memberParms[i]).contains(className)) continue;
            Object classTemplate = "";
            if (!templateTypes.isEmpty()) {
                classTemplate = "<";
                String separator = "";
                for (int j = 0; j < templateTypes.size(); ++j) {
                    classTemplate = (String)classTemplate + separator + templateTypes.get(j);
                    separator = ",";
                }
                classTemplate = (String)classTemplate + ">";
            }
            memberParms[i] = ((String)memberParms[i]).replaceAll(unqualifiedName, className + (String)classTemplate);
        }
        return Arrays.equals(memberParms, args);
    }

    private String[] resolveArgs(ClassInfo info, IType[] parameterTypes, ArrayList<String> templateTypes) {
        String[] templateParms = info.getTemplateParms();
        String[] result = new String[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            String param = parameterTypes[i].toString();
            param = param.replaceAll("\\{.*\\}", "");
            param = param.trim();
            int index = param.indexOf(35);
            while (index >= 0) {
                int digit = param.charAt(index + 1) - 48;
                param = digit < templateTypes.size() ? param.replaceFirst(param.substring(index, index + 2), templateTypes.get(digit)) : param.replaceFirst(param.substring(index, index + 2), templateParms[digit]);
                index = param.indexOf(35);
            }
            result[i] = param;
        }
        return result;
    }

    public IFunctionSummary[] getMatchingFunctions(ICHelpInvocationContext context, ICHelpBook[] helpBooks, String prefix) {
        boolean qualifiedCPP;
        ArrayList<FunctionSummary> fList;
        block9: {
            fList = new ArrayList<FunctionSummary>();
            ITranslationUnit t = context.getTranslationUnit();
            qualifiedCPP = false;
            if (t.isCXXLanguage()) {
                try {
                    IASTName[] names;
                    if (!(context instanceof IContentAssistHelpInvocationContext)) break block9;
                    IContentAssistHelpInvocationContext helpContext = (IContentAssistHelpInvocationContext)context;
                    IASTCompletionNode node = helpContext.getCompletionNode();
                    for (IASTName name : names = node.getNames()) {
                        if (!name.isQualified()) continue;
                        qualifiedCPP = true;
                        break;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (!qualifiedCPP) {
            for (int di = 0; di < helpBooks.length; ++di) {
                LibHoverLibrary l = libraries.get(helpBooks[di]);
                LibHoverInfo cppInfo = l.getHoverInfo();
                SortedMap<String, FunctionInfo> map = cppInfo.functions.tailMap(prefix);
                Set<Map.Entry<String, FunctionInfo>> c = map.entrySet();
                for (Map.Entry<String, FunctionInfo> e : c) {
                    FunctionInfo x = e.getValue();
                    String name = x.getName();
                    if (!name.startsWith(prefix) || name.startsWith("0")) continue;
                    FunctionSummary f = new FunctionSummary();
                    f.ReturnType = x.getReturnType();
                    f.Prototype = x.getPrototype();
                    f.Summary = x.getDescription();
                    f.Name = x.getName();
                    ArrayList<String> headers = x.getHeaders();
                    for (int i1 = 0; i1 < headers.size(); ++i1) {
                        f.setIncludeName(headers.get(i1));
                    }
                    fList.add(f);
                }
            }
        }
        IFunctionSummary[] summaries = new IFunctionSummary[fList.size()];
        for (int k = 0; k < summaries.length; ++k) {
            summaries[k] = (IFunctionSummary)fList.get(k);
        }
        return summaries;
    }

    public ICHelpResourceDescriptor[] getHelpResources(ICHelpInvocationContext context, ICHelpBook[] helpBooks, String name) {
        for (int i = 0; i < helpBooks.length; ++i) {
            LibHoverLibrary l;
            IFunctionSummary fs = this.getFunctionInfo(context, new ICHelpBook[]{helpBooks[i]}, name);
            if (fs == null || (l = libraries.get(helpBooks[i])) == null || l.getDocs() == null) continue;
            return new HelpResourceDescriptor[]{new HelpResourceDescriptor(helpBooks[i])};
        }
        return null;
    }

    private static class EnclosingASTNameJob
    extends SharedASTJob {
        private final int tlength;
        private final int toffset;
        private IASTName result = null;

        public EnclosingASTNameJob(ITranslationUnit t, int toffset, int tlength) {
            super("EnclosingASTNameJob", t);
            this.toffset = toffset;
            this.tlength = tlength;
        }

        public IStatus runOnAST(ILanguage lang, IASTTranslationUnit ast) {
            if (ast != null) {
                this.result = ast.getNodeSelector(null).findEnclosingName(this.toffset, this.tlength);
            }
            return Status.OK_STATUS;
        }

        public IASTName getASTName() {
            return this.result;
        }
    }

    private static class FunctionSummary
    implements IFunctionSummary,
    Comparable<FunctionSummary> {
        private String Name;
        private String NameSpace;
        private String ReturnType;
        private String Prototype;
        private String Summary;
        private boolean prototypeHasBrackets;
        private final ArrayList<RequiredInclude> Includes = new ArrayList();

        private FunctionSummary() {
        }

        @Override
        public int compareTo(FunctionSummary x) {
            FunctionSummary y = x;
            return this.getName().compareTo(y.getName());
        }

        private void setIncludeName(String iname) {
            RequiredInclude nri = new RequiredInclude(this, iname);
            this.Includes.add(nri);
        }

        public String getName() {
            return this.Name;
        }

        public String getNamespace() {
            return this.NameSpace;
        }

        public String getDescription() {
            return this.Summary;
        }

        public boolean prototypeHasBrackets() {
            return this.prototypeHasBrackets;
        }

        public void setPrototypeHasBrackets(boolean value) {
            this.prototypeHasBrackets = value;
        }

        public IFunctionSummary.IFunctionPrototypeSummary getPrototype() {
            return new FunctionPrototypeSummary();
        }

        public IRequiredInclude[] getIncludes() {
            IRequiredInclude[] includes = new IRequiredInclude[this.Includes.size()];
            for (int i = 0; i < this.Includes.size(); ++i) {
                includes[i] = this.Includes.get(i);
            }
            return includes;
        }

        private class RequiredInclude
        implements IRequiredInclude {
            private final String include;

            public RequiredInclude(FunctionSummary functionSummary, String file) {
                this.include = file;
            }

            public String getIncludeName() {
                return this.include;
            }

            public boolean isStandard() {
                return true;
            }
        }

        public class FunctionPrototypeSummary
        implements IFunctionSummary.IFunctionPrototypeSummary {
            public String getName() {
                return FunctionSummary.this.Name;
            }

            public String getReturnType() {
                return FunctionSummary.this.ReturnType;
            }

            public String getArguments() {
                return FunctionSummary.this.Prototype;
            }

            public String getPrototypeString(boolean namefirst) {
                if (namefirst) {
                    if (FunctionSummary.this.prototypeHasBrackets()) {
                        return FunctionSummary.this.Name + " " + FunctionSummary.this.Prototype + " " + FunctionSummary.this.ReturnType;
                    }
                    return FunctionSummary.this.Name + " (" + FunctionSummary.this.Prototype + ") " + FunctionSummary.this.ReturnType;
                }
                if (FunctionSummary.this.prototypeHasBrackets()) {
                    return FunctionSummary.this.ReturnType + " " + FunctionSummary.this.Name + " " + FunctionSummary.this.Prototype;
                }
                return FunctionSummary.this.ReturnType + " " + FunctionSummary.this.Name + " (" + FunctionSummary.this.Prototype + ")";
            }
        }
    }

    private static class HelpResourceDescriptor
    implements ICHelpResourceDescriptor {
        private final ICHelpBook helpbook;

        public HelpResourceDescriptor(ICHelpBook helpbook) {
            this.helpbook = helpbook;
        }

        public ICHelpBook getCHelpBook() {
            return this.helpbook;
        }

        public IHelpResource[] getHelpResources() {
            LibHoverLibrary l = libraries.get(this.helpbook);
            if (l != null) {
                IHelpResource[] hr = new IHelpResource[]{new HelpResource(l.getDocs(), l.getName())};
                return hr;
            }
            return null;
        }
    }

    private static class HelpResource
    implements IHelpResource {
        private final String href;
        private final String label;

        public HelpResource(String href, String label) {
            this.href = href;
            this.label = label;
        }

        public String getHref() {
            return this.href;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

