/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.db.internal.plugin;

import java.util.Hashtable;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.jpt.common.core.internal.utility.JptPlugin;
import org.eclipse.jpt.jpa.db.internal.DTPConnectionProfileFactory;
import org.osgi.framework.BundleContext;

public class JptJpaDbPlugin
extends JptPlugin {
    private final Hashtable<IWorkspace, DTPConnectionProfileFactory> connectionProfileFactories = new Hashtable();
    private static volatile JptJpaDbPlugin INSTANCE;

    public static JptJpaDbPlugin instance() {
        return INSTANCE;
    }

    protected void setInstance(JptPlugin plugin) {
        INSTANCE = (JptJpaDbPlugin)plugin;
    }

    public void stop(BundleContext context) throws Exception {
        try {
            this.disposeConnectionProfileFactories();
        }
        finally {
            super.stop(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DTPConnectionProfileFactory getConnectionProfileFactory(IWorkspace workspace) {
        Hashtable<IWorkspace, DTPConnectionProfileFactory> hashtable = this.connectionProfileFactories;
        synchronized (hashtable) {
            return this.getConnectionProfileFactory_(workspace);
        }
    }

    private DTPConnectionProfileFactory getConnectionProfileFactory_(IWorkspace workspace) {
        DTPConnectionProfileFactory factory = this.connectionProfileFactories.get(workspace);
        if (factory == null && this.isActive()) {
            factory = this.buildConnectionProfileFactory(workspace);
            this.connectionProfileFactories.put(workspace, factory);
        }
        return factory;
    }

    private DTPConnectionProfileFactory buildConnectionProfileFactory(IWorkspace workspace) {
        return new DTPConnectionProfileFactory(workspace);
    }

    private void disposeConnectionProfileFactories() {
        for (DTPConnectionProfileFactory factory : this.connectionProfileFactories.values()) {
            try {
                factory.dispose();
            }
            catch (Throwable ex) {
                this.logError(ex);
            }
        }
        this.connectionProfileFactories.clear();
    }
}

