/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.merge.properties;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertyMerger {
    protected String sourceProperties;
    protected String targetProperties;
    protected Map<String, String> sourceToTargetMap = new LinkedHashMap<String, String>();
    protected Map<String, String> targetToSourceMap = new LinkedHashMap<String, String>();
    protected static Pattern nlPattern = Pattern.compile("([\\n][\\r]?|[\\r][\\n]?)", 8);
    protected static Pattern propertyLine = Pattern.compile("\\s*(\\S+)\\s*=.*", 8);

    public String getSourceProperties() {
        return this.sourceProperties;
    }

    public void setSourceProperties(String sourceProperties) {
        this.sourceProperties = sourceProperties;
    }

    public String getTargetProperties() {
        return this.targetProperties;
    }

    public void setTargetProperties(String targetProperties) {
        this.targetProperties = targetProperties;
    }

    public Map<String, String> getSourceToTargetMap() {
        return this.sourceToTargetMap;
    }

    public String createPropertiesForURI(String uri) {
        try {
            URL url = null;
            try {
                url = new URL(uri);
            }
            catch (MalformedURLException exception) {
                url = new URL("file:" + uri);
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(url.openStream());
            byte[] input = new byte[bufferedInputStream.available()];
            bufferedInputStream.read(input);
            bufferedInputStream.close();
            return new String(input, "ISO-8859-1");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String createPropertiesForInputStream(InputStream inputStream) {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            byte[] input = new byte[bufferedInputStream.available()];
            bufferedInputStream.read(input);
            bufferedInputStream.close();
            return new String(input, "ISO-8859-1");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void merge() {
        Matcher matcher = nlPattern.matcher(this.targetProperties);
        String nl = null;
        if (matcher.find()) {
            String sourceNL;
            nl = matcher.group(1);
            matcher = nlPattern.matcher(this.sourceProperties);
            if (matcher.find() && !(sourceNL = matcher.group(1)).equals(nl)) {
                this.sourceProperties = this.sourceProperties.replace(sourceNL, nl);
            }
        } else {
            matcher = nlPattern.matcher(this.sourceProperties);
            if (matcher.find()) {
                nl = matcher.group(1);
            }
        }
        if (nl != null) {
            if (!this.targetProperties.endsWith(nl)) {
                this.targetProperties = String.valueOf(this.targetProperties) + nl;
            }
            if (!this.sourceProperties.endsWith(nl)) {
                this.sourceProperties = String.valueOf(this.sourceProperties) + nl;
            }
        }
        Map<String, String> sourcePropertyFragments = this.parse(this.sourceProperties);
        Map<String, String> targetPropertyFragments = this.parse(this.targetProperties);
        StringBuffer result = new StringBuffer(this.targetProperties);
        for (Map.Entry<String, String> entry : sourcePropertyFragments.entrySet()) {
            if (targetPropertyFragments.containsKey(entry.getKey())) continue;
            result.append(entry.getValue());
        }
        this.targetProperties = result.toString();
    }

    public Map<String, String> parse(String properties) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        int i = 0;
        while (i < properties.length()) {
            int eol;
            int start = i;
            while (true) {
                if ((eol = properties.indexOf("\n", start)) != -1) {
                    if (eol + 1 < properties.length() && properties.charAt(eol + 1) == '\r') {
                        if (eol > start && properties.charAt(eol - 1) == '\\') {
                            start = eol + 2;
                            continue;
                        }
                        ++eol;
                        break;
                    }
                    if ((eol <= start || properties.charAt(eol - 1) != '\\') && (eol - 1 <= start || properties.charAt(eol - 1) != '\r' || properties.charAt(eol - 2) != '\\')) break;
                    start = eol + 1;
                    continue;
                }
                eol = properties.indexOf("\r", start);
                if (eol == -1) {
                    eol = properties.length() - 1;
                    break;
                }
                if (eol <= start || properties.charAt(eol - 1) != '\\') break;
                start = eol + 1;
            }
            String property = properties.substring(i, eol + 1);
            Matcher matcher = propertyLine.matcher(property);
            if (matcher.find() && matcher.groupCount() >= 1) {
                int end;
                int begin = matcher.start(1);
                String propertyName = property.substring(begin, end = matcher.end(1));
                if (propertyName.indexOf("#") == -1) {
                    result.put(propertyName, property);
                } else if (propertyName.startsWith("#")) {
                    result.put(propertyName.substring(1), property);
                }
            }
            i = eol + 1;
        }
        return result;
    }

    public Object run(Object object) {
        try {
            String[] arguments = (String[])object;
            this.sourceProperties = this.createPropertiesForURI(arguments[0]);
            this.targetProperties = this.createPropertiesForURI(arguments[1]);
            this.merge();
            System.out.println("**********************************************");
            System.out.println(this.targetProperties);
            return 0;
        }
        catch (Exception exception) {
            return 1;
        }
    }

    @Deprecated
    public static class PlatformRunnable
    extends PropertyMerger {
    }
}

