/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.reviews.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.emf.cdo.common.branch.CDOBranchPointRef;
import org.eclipse.emf.cdo.common.branch.CDOBranchRef;
import org.eclipse.emf.cdo.lm.Change;
import org.eclipse.emf.cdo.lm.Delivery;
import org.eclipse.emf.cdo.lm.Dependency;
import org.eclipse.emf.cdo.lm.DropType;
import org.eclipse.emf.cdo.lm.FixedBaseline;
import org.eclipse.emf.cdo.lm.LMPackage;
import org.eclipse.emf.cdo.lm.Stream;
import org.eclipse.emf.cdo.lm.impl.FixedBaselineImpl;
import org.eclipse.emf.cdo.lm.reviews.DropReview;
import org.eclipse.emf.cdo.lm.reviews.ReviewsPackage;
import org.eclipse.emf.cdo.lm.reviews.impl.ReviewImpl;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.equinox.p2.metadata.Version;

public class DropReviewImpl
extends ReviewImpl
implements DropReview {
    protected static final Version VERSION_EDEFAULT = null;
    protected static final long TARGET_TIME_STAMP_EDEFAULT = 0L;
    protected static final String DROP_LABEL_EDEFAULT = null;

    protected DropReviewImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return ReviewsPackage.Literals.DROP_REVIEW;
    }

    public Version getVersion() {
        return (Version)this.eDynamicGet(12, (EStructuralFeature)LMPackage.Literals.FIXED_BASELINE__VERSION, true, true);
    }

    public void setVersion(Version newVersion) {
        this.eDynamicSet(12, (EStructuralFeature)LMPackage.Literals.FIXED_BASELINE__VERSION, newVersion);
    }

    public EList<Dependency> getDependencies() {
        return (EList)this.eDynamicGet(13, (EStructuralFeature)LMPackage.Literals.FIXED_BASELINE__DEPENDENCIES, true, true);
    }

    @Override
    public Delivery getDelivery() {
        return (Delivery)this.eDynamicGet(14, (EStructuralFeature)ReviewsPackage.Literals.DROP_REVIEW__DELIVERY, true, true);
    }

    @Override
    public void setDelivery(Delivery newDelivery) {
        this.eDynamicSet(14, (EStructuralFeature)ReviewsPackage.Literals.DROP_REVIEW__DELIVERY, newDelivery);
    }

    @Override
    public long getTargetTimeStamp() {
        Delivery delivery = this.getDelivery();
        return delivery == null ? -1L : delivery.getBaseTimeStamp();
    }

    @Override
    public DropType getDropType() {
        return (DropType)this.eDynamicGet(16, (EStructuralFeature)ReviewsPackage.Literals.DROP_REVIEW__DROP_TYPE, true, true);
    }

    @Override
    public void setDropType(DropType newDropType) {
        this.eDynamicSet(16, (EStructuralFeature)ReviewsPackage.Literals.DROP_REVIEW__DROP_TYPE, newDropType);
    }

    @Override
    public String getDropLabel() {
        return (String)this.eDynamicGet(17, (EStructuralFeature)ReviewsPackage.Literals.DROP_REVIEW__DROP_LABEL, true, true);
    }

    @Override
    public void setDropLabel(String newDropLabel) {
        this.eDynamicSet(17, (EStructuralFeature)ReviewsPackage.Literals.DROP_REVIEW__DROP_LABEL, newDropLabel);
    }

    public EList<Change> getBasedChanges() {
        return FixedBaselineImpl.getBasedChanges((FixedBaseline)this);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 13: {
                return ((InternalEList)this.getDependencies()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 12: {
                return this.getVersion();
            }
            case 13: {
                return this.getDependencies();
            }
            case 14: {
                return this.getDelivery();
            }
            case 15: {
                return this.getTargetTimeStamp();
            }
            case 16: {
                return this.getDropType();
            }
            case 17: {
                return this.getDropLabel();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 12: {
                this.setVersion((Version)newValue);
                return;
            }
            case 13: {
                this.getDependencies().clear();
                this.getDependencies().addAll((Collection)newValue);
                return;
            }
            case 14: {
                this.setDelivery((Delivery)newValue);
                return;
            }
            case 16: {
                this.setDropType((DropType)newValue);
                return;
            }
            case 17: {
                this.setDropLabel((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 12: {
                this.setVersion(VERSION_EDEFAULT);
                return;
            }
            case 13: {
                this.getDependencies().clear();
                return;
            }
            case 14: {
                this.setDelivery(null);
                return;
            }
            case 16: {
                this.setDropType(null);
                return;
            }
            case 17: {
                this.setDropLabel(DROP_LABEL_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 12: {
                return VERSION_EDEFAULT == null ? this.getVersion() != null : !VERSION_EDEFAULT.equals(this.getVersion());
            }
            case 13: {
                return !this.getDependencies().isEmpty();
            }
            case 14: {
                return this.getDelivery() != null;
            }
            case 15: {
                return this.getTargetTimeStamp() != 0L;
            }
            case 16: {
                return this.getDropType() != null;
            }
            case 17: {
                return DROP_LABEL_EDEFAULT == null ? this.getDropLabel() != null : !DROP_LABEL_EDEFAULT.equals(this.getDropLabel());
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == FixedBaseline.class) {
            switch (derivedFeatureID) {
                case 12: {
                    return 3;
                }
                case 13: {
                    return 4;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    @Override
    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == FixedBaseline.class) {
            switch (baseFeatureID) {
                case 3: {
                    return 12;
                }
                case 4: {
                    return 13;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public int eDerivedOperationID(int baseOperationID, Class<?> baseClass) {
        if (baseClass == FixedBaseline.class) {
            switch (baseOperationID) {
                case 7: {
                    return 7;
                }
            }
            return -1;
        }
        return super.eDerivedOperationID(baseOperationID, baseClass);
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 7: {
                return this.getBasedChanges();
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    public boolean isFloating() {
        return false;
    }

    public String getTypeName() {
        return "Drop Review";
    }

    public String getName() {
        return this.getDropLabel();
    }

    public int getSortPriority() {
        DropType dropType = this.getDropType();
        return dropType != null && dropType.isRelease() ? 275 : 250;
    }

    public long getBaseTimeStamp() {
        return this.getTargetTimeStamp();
    }

    public CDOBranchPointRef getBranchPoint() {
        Stream stream = this.getStream();
        if (stream == null) {
            stream = this.getContainerStream();
        }
        if (stream == null) {
            return null;
        }
        CDOBranchRef targetBranch = stream.getBranch();
        if (targetBranch == null) {
            return null;
        }
        long baseTimeStamp = this.getBaseTimeStamp();
        return targetBranch.getPointRef(baseTimeStamp);
    }

    private Stream getContainerStream() {
        EObject container = this.eContainer();
        while (container != null) {
            if (container instanceof Stream) {
                return (Stream)container;
            }
            container = container.eContainer();
        }
        return null;
    }
}

